/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.integration.gauss;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegrator;
import org.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import org.apache.commons.math3.analysis.integration.gauss.GaussianQuadratureAbstractTest;
import org.apache.commons.math3.util.FastMath;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class HermiteParametricTest
extends GaussianQuadratureAbstractTest {
    private static final double SQRT_PI = FastMath.sqrt((double)Math.PI);
    private static final GaussIntegratorFactory factory = new GaussIntegratorFactory();
    public static final int MAX_NUM_POINTS = 30;

    public HermiteParametricTest(int numberOfPoints, int maxDegree, double eps, double numUlps) {
        super((GaussIntegrator)factory.hermite(numberOfPoints), maxDegree, eps, numUlps);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int k = 1; k <= 30; ++k) {
            parameters.add(new Object[]{k, 2 * k - 1, Math.ulp(1.0), 195});
        }
        return parameters;
    }

    @Override
    public double getExpectedValue(int n) {
        if (n % 2 == 1) {
            return 0.0;
        }
        int iMax = n / 2;
        double p = 1.0;
        double q = 1.0;
        for (int i = 0; i < iMax; ++i) {
            p *= (double)(2 * i + 1);
            q *= 2.0;
        }
        return p / q * SQRT_PI;
    }
}

