/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model.dom;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.ri.model.AbstractXMLModelTest;
import org.apache.commons.jxpath.ri.model.dom.TestDOMFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMModelTest
extends AbstractXMLModelTest {
    private void appendXMLSignature(StringBuilder buffer, NodeList children, boolean elements, boolean attributes, boolean text, boolean pi) {
        for (int i = 0; i < children.getLength(); ++i) {
            this.appendXMLSignature(buffer, children.item(i), elements, attributes, text, pi);
        }
    }

    private void appendXMLSignature(StringBuilder buffer, Object object, boolean elements, boolean attributes, boolean text, boolean pi) {
        Node node = (Node)object;
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                buffer.append("<D>");
                this.appendXMLSignature(buffer, node.getChildNodes(), elements, attributes, text, pi);
                buffer.append("</D");
                break;
            }
            case 1: {
                String tag = elements ? ((Element)node).getTagName() : "E";
                buffer.append("<");
                buffer.append(tag);
                buffer.append(">");
                this.appendXMLSignature(buffer, node.getChildNodes(), elements, attributes, text, pi);
                buffer.append("</");
                buffer.append(tag);
                buffer.append(">");
                break;
            }
            case 3: 
            case 4: {
                if (!text) break;
                String string = node.getNodeValue();
                string = string.replace('\n', '=');
                buffer.append(string);
            }
        }
    }

    @Override
    protected AbstractFactory getAbstractFactory() {
        return new TestDOMFactory();
    }

    @Override
    protected String getModel() {
        return "DOM";
    }

    @Override
    protected String getXMLSignature(Object node, boolean elements, boolean attributes, boolean text, boolean pi) {
        StringBuilder buffer = new StringBuilder();
        this.appendXMLSignature(buffer, node, elements, attributes, text, pi);
        return buffer.toString();
    }

    @Test
    public void testGetElementDescendantOrSelf() {
        JXPathContext childContext = this.context.getRelativeContext(this.context.getPointer("/vendor"));
        Assertions.assertInstanceOf(Element.class, (Object)childContext.getContextBean());
        this.assertXPathNodeType(childContext, "//vendor", Element.class);
    }

    @Test
    public void testGetNode() {
        this.assertXPathNodeType(this.context, "/", Document.class);
        this.assertXPathNodeType(this.context, "/vendor/location", Element.class);
        this.assertXPathNodeType(this.context, "//location/@name", Attr.class);
        this.assertXPathNodeType(this.context, "//vendor", Element.class);
    }
}

