/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.JxltEngine;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IssuesTest
extends JexlTestCase {
    public IssuesTest() {
        super("IssuesTest", null);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Test
    public void test49() throws Exception {
        Engine jexl = new Engine();
        HashMap vars = new HashMap();
        MapContext ctxt = new MapContext(vars);
        String stmt = "a = 'b'; c = 'd';";
        JexlScript expr = jexl.createScript("a = 'b'; c = 'd';");
        expr.execute((JexlContext)ctxt);
        Assert.assertTrue((String)"JEXL-49 is not fixed", (vars.get("a").equals("b") && vars.get("c").equals("d") ? 1 : 0) != 0);
    }

    @Test
    public void test48() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        options.setStrict(true);
        options.setSilent(false);
        try {
            String jexlExp = "(foo.getInner().foo() eq true) and (foo.getInner().goo() = (foo.getInner().goo()+1-1))";
            JexlExpression e = jexl.createExpression("(foo.getInner().foo() eq true) and (foo.getInner().goo() = (foo.getInner().goo()+1-1))");
            jc.set("foo", new Foo());
            e.evaluate((JexlContext)jc);
            Assert.fail((String)"Should have failed due to invalid assignment");
        }
        catch (JexlException.Assignment xparse) {
            String string = xparse.toString();
        }
        catch (JexlException xjexl) {
            Assert.fail((String)"Should have thrown a parse exception");
        }
    }

    @Test
    public void test47() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlExpression expr = jexl.createExpression("true//false\n");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assert.assertTrue((String)"should be true", (boolean)((Boolean)value));
        expr = jexl.createExpression("/*true*/false");
        value = expr.evaluate((JexlContext)ctxt);
        Assert.assertFalse((String)"should be false", (boolean)((Boolean)value));
        expr = jexl.createExpression("/*\"true\"*/false");
        value = expr.evaluate((JexlContext)ctxt);
        Assert.assertFalse((String)"should be false", (boolean)((Boolean)value));
    }

    @Test
    public void test42() throws Exception {
        JexlEngine jexl = new JexlBuilder().create();
        JxltEngine uel = jexl.createJxltEngine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.set(jexl);
        options.setStrict(false);
        options.setStrictArithmetic(false);
        ctxt.set("ax", "ok");
        JxltEngine.Expression expr = uel.createExpression("${ax+(bx)}");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assert.assertEquals((String)"should be ok", (Object)"ok", (Object)value);
    }

    @Test
    public void test40() throws Exception {
        Engine jexl = new Engine();
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.set((JexlEngine)jexl);
        options.setSilent(false);
        ctxt.set("derived", new Derived());
        JexlExpression expr = jexl.createExpression("derived.foo()");
        Object value = expr.evaluate((JexlContext)ctxt);
        Assert.assertTrue((String)"should be true", (boolean)((Boolean)value));
    }

    @Test
    public void test52base() throws Exception {
        Engine jexl = (Engine)IssuesTest.createEngine(false);
        Uberspect uber = (Uberspect)jexl.getUberspect();
        String[] names = uber.getMethodNames(Another.class);
        Assert.assertTrue((String)"should find methods", (names.length > 0 ? 1 : 0) != 0);
        int found = 0;
        for (String name : names) {
            if (!"foo".equals(name) && !"goo".equals(name)) continue;
            ++found;
        }
        Assert.assertEquals((String)"should have foo & goo", (long)2L, (long)found);
        names = uber.getFieldNames(Another.class);
        Assert.assertTrue((String)"should find fields", (names.length > 0 ? 1 : 0) != 0);
        found = 0;
        for (String name : names) {
            if (!"name".equals(name)) continue;
            ++found;
        }
        Assert.assertEquals((String)"should have name", (long)1L, (long)found);
    }

    @Test
    public void test11() throws Exception {
        String[] exprs;
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        options.setStrict(true);
        ctxt.set("a", null);
        for (String s : exprs = new String[]{"a % b"}) {
            try {
                JexlExpression expr = jexl.createExpression(s);
                expr.evaluate((JexlContext)ctxt);
                Assert.fail((String)(s + " : should have failed due to null argument"));
            }
            catch (JexlException jexlException) {
                // empty catch block
            }
        }
    }

    @Test
    public void test62() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        MapContext vars = new MapContext();
        JexlEvalContext ctxt = new JexlEvalContext((JexlContext)vars);
        JexlOptions options = ctxt.getEngineOptions();
        options.setStrict(true);
        options.setSilent(true);
        JexlScript jscript = jexl.createScript("dummy.hashCode()");
        Assert.assertNull((String)jscript.getSourceText(), (Object)jscript.execute((JexlContext)ctxt));
        ctxt.set("dummy", "abcd");
        Assert.assertEquals((String)jscript.getSourceText(), (Object)"abcd".hashCode(), (Object)jscript.execute((JexlContext)ctxt));
        jscript = jexl.createScript("dummy.hashCode");
        Assert.assertNull((String)jscript.getSourceText(), (Object)jscript.execute((JexlContext)ctxt));
        vars.clear();
        JexlExpression jexpr = jexl.createExpression("dummy.hashCode()");
        Assert.assertNull((String)jexpr.toString(), (Object)jexpr.evaluate((JexlContext)ctxt));
        ctxt.set("dummy", "abcd");
        Assert.assertEquals((String)jexpr.toString(), (Object)"abcd".hashCode(), (Object)jexpr.evaluate((JexlContext)ctxt));
        jexpr = jexl.createExpression("dummy.hashCode");
        Assert.assertNull((String)jexpr.toString(), (Object)jexpr.evaluate((JexlContext)ctxt));
    }

    @Test
    public void test87() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlExpression divide = jexl.createExpression("l / r");
        JexlExpression modulo = jexl.createExpression("l % r");
        ctxt.set("l", BigInteger.valueOf(7L));
        ctxt.set("r", BigInteger.valueOf(2L));
        Assert.assertEquals((Object)BigInteger.valueOf(3L), (Object)divide.evaluate((JexlContext)ctxt));
        Assert.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
        ctxt.set("l", BigDecimal.valueOf(7L));
        ctxt.set("r", BigDecimal.valueOf(2L));
        Assert.assertEquals((Object)BigDecimal.valueOf(3.5), (Object)divide.evaluate((JexlContext)ctxt));
        Assert.assertTrue((boolean)jexl.getArithmetic().equals((Object)1, modulo.evaluate((JexlContext)ctxt)));
    }

    @Test
    public void test90() throws Exception {
        String[] fexprs;
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        for (String fexpr : fexprs = new String[]{"a=3 b=4", "while(a) while(a)", "1 2", "if (true) 2; 3 {}", "while (x) 1 if (y) 2 3"}) {
            try {
                jexl.createScript(fexpr);
                Assert.fail((String)(fexpr + ": Should have failed in parse"));
            }
            catch (JexlException jexlException) {
                // empty catch block
            }
        }
        String[] exprs = new String[]{"if (x) {1} if (y) {2}", "if (x) 1 if (y) 2", "while (x) 1 if (y) 2 else 3", "for(z : [3, 4, 5]) { z } y ? 2 : 1", "for(z : [3, 4, 5]) { z } if (y) 2 else 1"};
        ctxt.set("x", Boolean.FALSE);
        ctxt.set("y", Boolean.TRUE);
        for (String expr : exprs) {
            JexlScript s = jexl.createScript(expr);
            Assert.assertEquals((Object)2, (Object)s.execute((JexlContext)ctxt));
        }
        IssuesTest.debuggerCheck(jexl);
    }

    @Test
    public void test44() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        JexlScript script = jexl.createScript("'hello world!'//commented");
        Assert.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!';//commented\n'bye...'");
        Assert.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!'## commented");
        Assert.assertEquals((Object)"hello world!", (Object)script.execute((JexlContext)ctxt));
        script = jexl.createScript("'hello world!';## commented\n'bye...'");
        Assert.assertEquals((Object)"bye...", (Object)script.execute((JexlContext)ctxt));
    }

    @Test
    public void test97() throws Exception {
        JexlEngine jexl = IssuesTest.createEngine(false);
        JexlEvalContext ctxt = new JexlEvalContext();
        JexlOptions options = ctxt.getEngineOptions();
        options.setSilent(false);
        for (char v = 'a'; v <= 'z'; v = (char)(v + '\u0001')) {
            ctxt.set(Character.toString(v), 10);
        }
        String input = "(((((((((((((((((((((((((z+y)/x)*w)-v)*u)/t)-s)*r)/q)+p)-o)*n)-m)+l)*k)+j)/i)+h)*g)+f)/e)+d)-c)/b)+a)";
        long start = System.nanoTime();
        JexlExpression script = jexl.createExpression("(((((((((((((((((((((((((z+y)/x)*w)-v)*u)/t)-s)*r)/q)+p)-o)*n)-m)+l)*k)+j)/i)+h)*g)+f)/e)+d)-c)/b)+a)");
        Object value = script.evaluate((JexlContext)ctxt);
        Assert.assertEquals((Object)11, (Object)value);
        long end = System.nanoTime();
        double millisec = (double)(end - start) / 1000000.0;
        double limit = 200.0;
        Assert.assertTrue((String)("Expected parse to take less than 200.0ms, actual " + millisec), (millisec < 200.0 ? 1 : 0) != 0);
    }

    @Test
    public void test98() throws Exception {
        String[] exprs = new String[]{"fn:replace('DOMAIN\\somename', '\\\\', '\\\\\\\\')", "fn:replace(\"DOMAIN\\somename\", \"\\\\\", \"\\\\\\\\\")", "fn:replace('DOMAIN\\somename', '\\u005c', '\\u005c\\u005c')"};
        HashMap<String, fn98> funcs = new HashMap<String, fn98>();
        funcs.put("fn", new fn98());
        JexlEngine jexl = new JexlBuilder().namespaces(funcs).create();
        for (String expr : exprs) {
            Object value = jexl.createExpression(expr).evaluate(null);
            Assert.assertEquals((String)expr, (Object)"DOMAIN\\\\somename", (Object)value);
        }
    }

    public static class fn98 {
        public String replace(String str, String target, String replacement) {
            return str.replace(target, replacement);
        }
    }

    static class Derived
    extends Base {
        Derived() {
        }

        @Override
        public boolean foo() {
            return true;
        }
    }

    public static abstract class Base {
        public abstract boolean foo();
    }

    public static class Foo {
        private final Another inner = new Another();

        Foo() {
        }

        public Another getInner() {
            return this.inner;
        }
    }

    public static class Another {
        public String name = "whatever";
        private final Boolean foo = Boolean.TRUE;

        public Boolean foo() {
            return this.foo;
        }

        public int goo() {
            return 100;
        }
    }
}

