/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.junit.Assert;
import org.junit.Test;

public class IfTest
extends JexlTestCase {
    public IfTest() {
        super("IfTest");
    }

    @Test
    public void testSimpleIfTrue() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) 1");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 1", (Object)new Integer(1), (Object)o);
    }

    @Test
    public void testSimpleIfFalse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) 1");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertNull((String)"Return value is not empty", (Object)o);
    }

    @Test
    public void testSimpleElse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) 1 else 2;");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not 2", (Object)new Integer(2), (Object)o);
    }

    @Test
    public void testBlockIfTrue() throws Exception {
        JexlScript e = this.JEXL.createScript("if (true) { 'hello'; }");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)"hello", (Object)o);
    }

    @Test
    public void testBlockElse() throws Exception {
        JexlScript e = this.JEXL.createScript("if (false) {1} else {2 ; 3}");
        MapContext jc = new MapContext();
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is wrong", (Object)new Integer(3), (Object)o);
    }

    @Test
    public void testIfWithSimpleExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(1));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    @Test
    public void testIfElseIfExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) { 10; } else if (x == 2) 20  else 30", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assert.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assert.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assert.assertEquals((Object)30, (Object)o);
    }

    @Test
    public void testIfElseIfReturnExpression0() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) return 10; if (x == 2)  return 20; else if (x == 3) return 30  else { return 40 }", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assert.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assert.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{3});
        Assert.assertEquals((Object)30, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assert.assertEquals((Object)40, (Object)o);
    }

    @Test
    public void testIfElseIfReturnExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if (x == 1) return 10;  if (x == 2) return 20  else if (x == 3) return 30; else return 40;", new String[]{"x"});
        Object o = e.execute(null, new Object[]{1});
        Assert.assertEquals((Object)10, (Object)o);
        o = e.execute(null, new Object[]{2});
        Assert.assertEquals((Object)20, (Object)o);
        o = e.execute(null, new Object[]{3});
        Assert.assertEquals((Object)30, (Object)o);
        o = e.execute(null, new Object[]{4});
        Assert.assertEquals((Object)40, (Object)o);
    }

    @Test
    public void testIfWithArithmeticExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) + 1 == 5) true;");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Integer(2));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    @Test
    public void testIfWithDecimalArithmeticExpression() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) == 5) true");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Float(2.5f));
        Object o = e.execute((JexlContext)jc);
        Assert.assertEquals((String)"Result is not true", (Object)Boolean.TRUE, (Object)o);
    }

    @Test
    public void testIfWithAssignment() throws Exception {
        JexlScript e = this.JEXL.createScript("if ((x * 2) == 5) {y = 1} else {y = 2;}");
        MapContext jc = new MapContext();
        jc.set("x", (Object)new Float(2.5f));
        e.execute((JexlContext)jc);
        Object result = jc.get("y");
        Assert.assertEquals((String)"y has the wrong value", (Object)new Integer(1), (Object)result);
    }

    @Test
    public void testTernary() throws Exception {
        Object o;
        int l;
        JexlEngine jexl = this.JEXL;
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = jexl.createExpression("x.y.z = foo ?'bar':'quux'");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.TRUE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(jexl);
    }

    @Test
    public void testTernaryShorthand() throws Exception {
        Object o;
        int l;
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = this.JEXL.createExpression("x.y.z = foo?:'quux'");
        JexlExpression f = this.JEXL.createExpression("foo??'quux'");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", null);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
        }
        jc.set("foo", Boolean.FALSE);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be false", (Object)false, (Object)o);
        }
        jc.set("foo", Double.NaN);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertTrue((String)"Should be NaN", (boolean)Double.isNaN((Double)o));
        }
        jc.set("foo", "");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be empty string", (Object)"", (Object)o);
        }
        jc.set("foo", "false");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be 'false'", (Object)"false", (Object)o);
        }
        jc.set("foo", 0.0);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be 0", (Object)0.0, (Object)o);
        }
        jc.set("foo", 0);
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be quux", (Object)"quux", (Object)o);
            o = f.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be 0", (Object)0, (Object)o);
        }
        jc.set("foo", "bar");
        for (l = 0; l < 4; ++l) {
            options.setStrict((l & 1) == 0);
            options.setSilent((l & 2) != 0);
            o = e.evaluate((JexlContext)jc);
            Assert.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
            o = jc.get("x.y.z");
            Assert.assertEquals((String)"Should be bar", (Object)"bar", (Object)o);
        }
        IfTest.debuggerCheck(this.JEXL);
    }

    @Test
    public void testNullCoaelescing() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlExpression xtrue = this.JEXL.createExpression("x??true");
        Object o = xtrue.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Should be true", (Object)true, (Object)o);
        jc.set("x", false);
        o = xtrue.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Should be false", (Object)false, (Object)o);
        JexlExpression yone = this.JEXL.createExpression("y??1");
        o = yone.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Should be 1", (Object)1, (Object)o);
        jc.set("y", 0);
        o = yone.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Should be 0", (Object)0, (Object)o);
        IfTest.debuggerCheck(this.JEXL);
    }

    @Test
    public void testNullCoaelescingScript() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlScript xtrue = this.JEXL.createScript("x??true");
        Object o = xtrue.execute((JexlContext)jc);
        Assert.assertEquals((String)"Should be true", (Object)true, (Object)o);
        jc.set("x", false);
        o = xtrue.execute((JexlContext)jc);
        Assert.assertEquals((String)"Should be false", (Object)false, (Object)o);
        JexlScript yone = this.JEXL.createScript("y??1");
        o = yone.execute((JexlContext)jc);
        Assert.assertEquals((String)"Should be 1", (Object)1, (Object)o);
        jc.set("y", 0);
        o = yone.execute((JexlContext)jc);
        Assert.assertEquals((String)"Should be 0", (Object)0, (Object)o);
        IfTest.debuggerCheck(this.JEXL);
    }

    @Test
    public void testTernaryFail() throws Exception {
        JexlEvalContext jc = new JexlEvalContext();
        JexlOptions options = jc.getEngineOptions();
        JexlExpression e = this.JEXL.createExpression("false ? bar : quux");
        options.setStrict(true);
        options.setSilent(false);
        try {
            Object o = e.evaluate((JexlContext)jc);
            Assert.fail((String)"Should have failed");
        }
        catch (JexlException xjexl) {
            Assert.assertTrue((boolean)xjexl.toString().contains("quux"));
        }
    }
}

