/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.util.Arrays;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlFeatures;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.junit.Assert;
import org.junit.Test;

public class FeaturesTest
extends JexlTestCase {
    private final JexlEngine jexl = new JexlBuilder().create();

    public FeaturesTest() {
        super("BlockTest");
    }

    private void checkFeature(JexlFeatures features, String[] scripts) throws Exception {
        for (String script : scripts) {
            JexlScript ctl = this.JEXL.createScript(script);
            Assert.assertNotNull((Object)ctl);
            try {
                JexlScript e = this.jexl.createScript(features, null, script, new String[0]);
                Assert.fail((String)("should fail parse: " + script));
            }
            catch (JexlException.Parsing xfeature) {
                String msg = xfeature.getMessage();
                Assert.assertNotNull((Object)msg);
            }
        }
    }

    private void assertOk(JexlFeatures features, String[] scripts) {
        for (String str : scripts) {
            try {
                JexlScript jexlScript = this.jexl.createScript(str);
            }
            catch (JexlException.Feature xfeature) {
                Assert.fail((String)(str + " :: should not fail parse: " + xfeature.getMessage()));
            }
        }
    }

    @Test
    public void testNoScript() throws Exception {
        JexlFeatures f = new JexlFeatures().script(false);
        String[] scripts = new String[]{"if (false) { block(); }", "{ noway(); }", "while(true);", "for(var i : {0 .. 10}) { bar(i); }"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testNoLoop() throws Exception {
        JexlFeatures f = new JexlFeatures().loops(false);
        String[] scripts = new String[]{"while(true);", "for(var i : {0 .. 10}) { bar(i); }"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testNoLambda() throws Exception {
        JexlFeatures f = new JexlFeatures().lambda(false);
        String[] scripts = new String[]{"var x  = ()->{ return 0 };", "()->{ return 0 };", "(x, y)->{ return 0 };", "function() { return 0 };", "function(x, y) { return 0 };", "if (false) { (function(x, y) { return x + y })(3, 4) }"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testNoNew() throws Exception {
        JexlFeatures f = new JexlFeatures().newInstance(false);
        String[] scripts = new String[]{"return new(clazz);", "new('java.math.BigDecimal', 12) + 1"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testNoSideEffects() throws Exception {
        JexlFeatures f = new JexlFeatures().sideEffect(false);
        String[] scripts = new String[]{"x = 1", "x.y = 1", "x().y = 1", "x += 1", "x.y += 1", "x().y += 1", "x -= 1", "x *= 1", "x /= 1", "x ^= 1", "x &= 1", "x |= 1"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testNoSideEffectsGlobal() throws Exception {
        JexlFeatures f = new JexlFeatures().sideEffectGlobal(false);
        String[] scripts = new String[]{"x = 1", "x.y = 1", "x().y = 1", "x += 1", "x.y += 1", "x().y += 1", "x -= 1", "x *= 1", "x /= 1", "x ^= 1", "x &= 1", "x |= 1", "4 + (x.y = 1)", "if (true) x.y.z = 4"};
        this.checkFeature(f, scripts);
        for (String str : scripts) {
            try {
                JexlScript jexlScript = this.jexl.createScript("var x = foo(); " + str);
            }
            catch (JexlException.Feature xfeature) {
                Assert.fail((String)(str + " :: should not fail parse: " + xfeature.getMessage()));
            }
        }
    }

    @Test
    public void testNoLocals() throws Exception {
        JexlFeatures f = new JexlFeatures().localVar(false);
        String[] scripts = new String[]{"var x = 0;", "(x)->{ x }"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testReservedVars() throws Exception {
        JexlFeatures f = new JexlFeatures().reservedNames(Arrays.asList("foo", "bar"));
        String[] scripts = new String[]{"var foo = 0;", "(bar)->{ bar }", "var f = function(bar) { bar; }"};
        this.checkFeature(f, scripts);
        String[] scriptsOk = new String[]{"var foo0 = 0;", "(bar1)->{ bar }", "var f = function(bar2) { bar2; }"};
        this.assertOk(f, scriptsOk);
    }

    @Test
    public void testArrayRefs() throws Exception {
        JexlFeatures f = new JexlFeatures().arrayReferenceExpr(false);
        String[] scripts = new String[]{"x[y]", "x['a'][b]", "x()['a'][b]", "x.y['a'][b]"};
        this.checkFeature(f, scripts);
        this.assertOk(f, scripts);
        String[] scriptsOk = new String[]{"x['y']", "x['a'][1]", "x()['a']['b']", "x.y['a']['b']"};
        this.assertOk(f, scriptsOk);
    }

    @Test
    public void testMethodCalls() throws Exception {
        JexlFeatures f = new JexlFeatures().methodCall(false);
        String[] scripts = new String[]{"x.y(z)", "x['a'].m(b)", "x()['a'](b)", "x.y['a'](b)"};
        this.checkFeature(f, scripts);
        String[] scriptsOk = new String[]{"x('y')", "x('a')[1]", "x()['a']['b']"};
        this.assertOk(f, scriptsOk);
    }

    @Test
    public void testStructuredLiterals() throws Exception {
        JexlFeatures f = new JexlFeatures().structuredLiteral(false);
        String[] scripts = new String[]{"{1, 2, 3}", "[1, 2, 3]", "{ 1 :'one', 2 : 'two', 3 : 'three' }", "(1 .. 5)"};
        this.checkFeature(f, scripts);
        this.assertOk(f, scripts);
    }

    @Test
    public void testAnnotations() throws Exception {
        JexlFeatures f = new JexlFeatures().annotation(false);
        String[] scripts = new String[]{"@synchronized(2) { return 42; }", "@two var x = 3;"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testPragma() throws Exception {
        JexlFeatures f = new JexlFeatures().pragma(false);
        String[] scripts = new String[]{"#pragma foo 42", "#pragma foo 'bar'\n@two var x = 3;"};
        this.checkFeature(f, scripts);
    }

    @Test
    public void testMixedFeatures() throws Exception {
        JexlFeatures f = new JexlFeatures().newInstance(false).localVar(false).lambda(false).loops(false).sideEffectGlobal(false);
        String[] scripts = new String[]{"return new(clazz);", "()->{ return 0 };", "var x = 0;", "(x, y)->{ return 0 };", "for(var i : {0 .. 10}) { bar(i); }", "x += 1", "x.y += 1"};
        this.checkFeature(f, scripts);
    }
}

