/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3;

import java.io.File;
import java.math.BigDecimal;
import java.math.MathContext;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlEvalContext;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.ObjectContext;
import org.apache.commons.jexl3.internal.Engine;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Issues100Test
extends JexlTestCase {
    static final String TESTA = "src/test/scripts/testA.jexl";

    public Issues100Test() {
        super("Issues100Test", null);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Logger.getLogger(JexlEngine.class.getName()).setLevel(Level.SEVERE);
    }

    @Test
    public void test100() throws Exception {
        JexlEngine jexl = new JexlBuilder().cache(4).create();
        MapContext ctxt = new MapContext();
        int[] foo = new int[]{42};
        ctxt.set("foo", (Object)foo);
        for (int l = 0; l < 2; ++l) {
            Object value = jexl.createExpression("foo[0]").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)42, (Object)value);
            value = jexl.createExpression("foo[0] = 43").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("foo.0").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)43, (Object)value);
            value = jexl.createExpression("foo.0 = 42").evaluate((JexlContext)ctxt);
            Assert.assertEquals((Object)42, (Object)value);
        }
    }

    @Test
    public void test105() throws Exception {
        MapContext context = new MapContext();
        JexlExpression selectExp = new Engine().createExpression("[a.propA]");
        context.set("a", (Object)new A105("a1", "p1"));
        Object[] r = (Object[])selectExp.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"p1", (Object)r[0]);
        context.set("a", (Object)new A105("a2", "p2"));
        r = (Object[])selectExp.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"p2", (Object)r[0]);
    }

    @Test
    public void test106() throws Exception {
        JexlEvalContext context = new JexlEvalContext();
        JexlOptions options = context.getEngineOptions();
        options.setStrict(true);
        options.setStrictArithmetic(true);
        context.set("a", new BigDecimal(1));
        context.set("b", new BigDecimal(3));
        Engine jexl = new Engine();
        try {
            Object value = jexl.createExpression("a / b").evaluate((JexlContext)context);
            Assert.assertNotNull((Object)value);
        }
        catch (JexlException xjexl) {
            Assert.fail((String)"should not occur");
        }
        options.setMathContext(MathContext.UNLIMITED);
        options.setMathScale(2);
        try {
            jexl.createExpression("a / b").evaluate((JexlContext)context);
            Assert.fail((String)"should fail");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    @Test
    public void test107() throws Exception {
        String[] exprs = new String[]{"'Q4'.toLowerCase()", "q4", "(Q4).toLowerCase()", "q4", "(4).toString()", "4", "(1 + 3).toString()", "4", "({ 'q' : 'Q4'}).get('q').toLowerCase()", "q4", "{ 'q' : 'Q4'}.get('q').toLowerCase()", "q4", "({ 'q' : 'Q4'})['q'].toLowerCase()", "q4", "(['Q4'])[0].toLowerCase()", "q4"};
        MapContext context = new MapContext();
        context.set("Q4", (Object)"Q4");
        Engine jexl = new Engine();
        for (int e = 0; e < exprs.length; e += 2) {
            JexlExpression expr = jexl.createExpression(exprs[e]);
            String expected = exprs[e + 1];
            Object value = expr.evaluate((JexlContext)context);
            Assert.assertEquals((Object)expected, (Object)value);
            expr = jexl.createExpression(expr.getParsedText());
            value = expr.evaluate((JexlContext)context);
            Assert.assertEquals((Object)expected, (Object)value);
        }
    }

    @Test
    public void test108() throws Exception {
        Engine jexl = new Engine();
        JexlScript expr = jexl.createScript("size([])");
        Object value = expr.execute(null);
        Assert.assertEquals((Object)0, (Object)value);
        expr = jexl.createScript(expr.getParsedText());
        value = expr.execute(null);
        Assert.assertEquals((Object)0, (Object)value);
        expr = jexl.createScript("if (true) { [] } else { {:} }");
        value = expr.execute(null);
        Assert.assertTrue((boolean)value.getClass().isArray());
        expr = jexl.createScript(expr.getParsedText());
        value = expr.execute(null);
        Assert.assertTrue((boolean)value.getClass().isArray());
        expr = jexl.createScript("size({:})");
        value = expr.execute(null);
        Assert.assertEquals((Object)0, (Object)value);
        expr = jexl.createScript(expr.getParsedText());
        value = expr.execute(null);
        Assert.assertEquals((Object)0, (Object)value);
        expr = jexl.createScript("if (false) { [] } else { {:} }");
        value = expr.execute(null);
        Assert.assertTrue((boolean)(value instanceof Map));
        expr = jexl.createScript(expr.getParsedText());
        value = expr.execute(null);
        Assert.assertTrue((boolean)(value instanceof Map));
    }

    @Test
    public void test109() throws Exception {
        Engine jexl = new Engine();
        MapContext context = new MapContext();
        context.set("foo.bar", (Object)40);
        Object value = jexl.createExpression("foo.bar + 2").evaluate((JexlContext)context);
        Assert.assertEquals((Object)42, (Object)value);
    }

    @Test
    public void test110() throws Exception {
        Engine jexl = new Engine();
        String[] names = new String[]{"foo"};
        MapContext context = new MapContext();
        Object value = jexl.createScript("foo + 2", names).execute((JexlContext)context, new Object[]{40});
        Assert.assertEquals((Object)42, (Object)value);
        context.set("frak.foo", (Object)-40);
        value = jexl.createScript("frak.foo - 2", names).execute((JexlContext)context, new Object[]{40});
        Assert.assertEquals((Object)-42, (Object)value);
    }

    @Test
    public void testRichContext() throws Exception {
        A105 a105 = new A105("foo", "bar");
        Engine jexl = new Engine();
        RichContext context = new RichContext((JexlEngine)jexl, a105);
        Object value = jexl.createScript("uppercase(nameA + propA)").execute((JexlContext)context);
        Assert.assertEquals((Object)"FOOBAR", (Object)value);
    }

    @Test
    public void test111() throws Exception {
        Engine jexl = new Engine();
        MapContext context = new MapContext();
        String strExpr = "((x>0)?\"FirstValue=\"+(y-x):\"SecondValue=\"+x)";
        JexlExpression expr = jexl.createExpression("((x>0)?\"FirstValue=\"+(y-x):\"SecondValue=\"+x)");
        context.set("x", (Object)1);
        context.set("y", (Object)10);
        Object value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"FirstValue=9", (Object)value);
        context.set("x", (Object)1.0);
        context.set("y", (Object)10.0);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)1);
        context.set("y", (Object)10.0);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)1.0);
        context.set("y", (Object)10);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"FirstValue=9.0", (Object)value);
        context.set("x", (Object)-10);
        context.set("y", (Object)1);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"SecondValue=-10", (Object)value);
        context.set("x", (Object)-10.0);
        context.set("y", (Object)1.0);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"SecondValue=-10.0", (Object)value);
        context.set("x", (Object)-10);
        context.set("y", (Object)1.0);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"SecondValue=-10", (Object)value);
        context.set("x", (Object)-10.0);
        context.set("y", (Object)1);
        value = expr.evaluate((JexlContext)context);
        Assert.assertEquals((Object)"SecondValue=-10.0", (Object)value);
    }

    @Test
    public void testScaleIssue() throws Exception {
        Engine jexlX = new Engine();
        String expStr1 = "result == salary/month * work.percent/100.00";
        JexlExpression exp1 = jexlX.createExpression("result == salary/month * work.percent/100.00");
        JexlEvalContext ctx = new JexlEvalContext();
        JexlOptions options = ctx.getEngineOptions();
        ctx.set("result", new BigDecimal("9958.33"));
        ctx.set("salary", new BigDecimal("119500.00"));
        ctx.set("month", new BigDecimal("12.00"));
        ctx.set("work.percent", new BigDecimal("100.00"));
        Assert.assertFalse((boolean)((Boolean)exp1.evaluate((JexlContext)ctx)));
        options.setMathScale(2);
        Assert.assertTrue((boolean)((Boolean)exp1.evaluate((JexlContext)ctx)));
    }

    @Test
    public void test112() throws Exception {
        Engine jexl = new Engine();
        Object result = jexl.createScript(Integer.toString(Integer.MAX_VALUE)).execute(null);
        Assert.assertEquals((Object)Integer.MAX_VALUE, (Object)result);
        result = jexl.createScript(Integer.toString(-2147483647)).execute(null);
        Assert.assertEquals((Object)-2147483647, (Object)result);
        result = jexl.createScript(Integer.toString(Integer.MIN_VALUE)).execute(null);
        Assert.assertEquals((Object)Integer.MIN_VALUE, (Object)result);
    }

    @Test
    public void test117() throws Exception {
        Engine jexl = new Engine();
        JexlExpression e = jexl.createExpression("TIMESTAMP > 20100102000000");
        MapContext ctx = new MapContext();
        ctx.set("TIMESTAMP", (Object)new Long("20100103000000"));
        Object result = e.evaluate((JexlContext)ctx);
        Assert.assertTrue((boolean)((Boolean)result));
    }

    @Test
    public void test125() throws Exception {
        Engine jexl = new Engine();
        JexlExpression e = jexl.createExpression("method()");
        Foo125Context jc = new Foo125Context((JexlEngine)jexl, new Foo125());
        Assert.assertEquals((Object)"OK", (Object)e.evaluate((JexlContext)jc));
    }

    @Test
    public void test130a() throws Exception {
        String myName = "Test.Name";
        String myValue = "Test.Value";
        Engine myJexlEngine = new Engine();
        MapContext myMapContext = new MapContext();
        myMapContext.set("Test.Name", (Object)myValue);
        Object myObjectWithTernaryConditional = myJexlEngine.createScript("Test.Name?:null").execute((JexlContext)myMapContext);
        Assert.assertEquals((Object)myValue, (Object)myObjectWithTernaryConditional);
    }

    @Test
    public void test130b() throws Exception {
        String myName = "Test.Name";
        Object myValue = new Object(){

            public String toString() {
                return "Test.Value";
            }
        };
        Engine myJexlEngine = new Engine();
        MapContext myMapContext = new MapContext();
        myMapContext.set("Test.Name", myValue);
        Object myObjectWithTernaryConditional = myJexlEngine.createScript("Test.Name?:null").execute((JexlContext)myMapContext);
        Assert.assertEquals((Object)myValue, (Object)myObjectWithTernaryConditional);
    }

    @Test
    public void test135() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        HashMap<Integer, Integer> foo = new HashMap<Integer, Integer>();
        foo.put(3, 42);
        jc.set("state", foo);
        JexlScript script = jexl.createScript("var y = state[3]; y");
        Object result = script.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)42, (Object)result);
        jc.set("a", (Object)3);
        script = jexl.createScript("var y = state[a]; y");
        result = script.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)42, (Object)result);
        jc.set("a", (Object)2);
        script = jexl.createScript("var y = state[a + 1]; y");
        result = script.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)42, (Object)result);
        jc.set("a", (Object)2);
        jc.set("b", (Object)1);
        script = jexl.createScript("var y = state[a + b]; y");
        result = script.execute((JexlContext)jc, new Object[]{foo});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("var y = state[3]; y", new String[]{"state"});
        result = script.execute(null, new Object[]{foo, 3});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("var y = state[a]; y", new String[]{"state", "a"});
        result = script.execute(null, new Object[]{foo, 3});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("var y = state[a + 1]; y", new String[]{"state", "a"});
        result = script.execute(null, new Object[]{foo, 2});
        Assert.assertEquals((Object)42, (Object)result);
        script = jexl.createScript("var y = state[a + b]; y", new String[]{"state", "a", "b"});
        result = script.execute(null, new Object[]{foo, 2, 1});
        Assert.assertEquals((Object)42, (Object)result);
    }

    @Test
    public void test136() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var x = $TAB[idx]; return x;", new String[]{"idx"});
        jc.set("fn01", (Object)script);
        script = jexl.createScript("$TAB = { 1:11, 2:22, 3:33}; IDX=2;");
        script.execute((JexlContext)jc);
        JexlExpression expr = jexl.createExpression("fn01(IDX)");
        Object result = expr.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"EXPR01 result", (Object)22, (Object)result);
    }

    @Test
    public void test143() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var total = 10; total = (total - ((x < 3)? y : z)) / (total / 10); total", new String[]{"x", "y", "z"});
        Object result = script.execute((JexlContext)jc, new Object[]{2, 2, 1});
        Assert.assertEquals((Object)8, (Object)result);
        script = jexl.createScript("var total = 10; total = (total - ((x < 3)? y : 1)) / (total / 10); total", new String[]{"x", "y", "z"});
        result = script.execute((JexlContext)jc, new Object[]{2, 2, 1});
        Assert.assertEquals((Object)8, (Object)result);
    }

    @Test
    public void test144() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        JexlScript script = jexl.createScript("var total = 10; total('tt')");
        try {
            Object result = script.execute((JexlContext)jc);
            Assert.fail((String)"total() is not solvable");
        }
        catch (JexlException.Method ambiguous) {
            Assert.assertEquals((Object)"total", (Object)ambiguous.getMethod());
        }
    }

    @Test
    public void test144a() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        jc.set("quuxClass", Quux144.class);
        JexlExpression create = jexl.createExpression("quux = new(quuxClass)");
        JexlExpression assignArray = jexl.createExpression("quux.arr = [ 'hello', 'world' ]");
        JexlExpression checkArray = jexl.createExpression("quux.arr");
        Quux144 quux = (Quux144)create.evaluate((JexlContext)jc);
        Assert.assertNotNull((String)"quux is null", (Object)quux);
        Object o = assignArray.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"Result is not a string array", String[].class, o.getClass());
        o = checkArray.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"The array elements are equal", Arrays.asList("hello", "world"), Arrays.asList((String[])o));
        assignArray = jexl.createExpression("quux.arr = null");
        o = assignArray.evaluate((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
        o = checkArray.evaluate((JexlContext)jc);
        Assert.assertNull((String)"Result is not null", (Object)o);
        assignArray = jexl.createExpression("quux.arr = [ ]");
        o = assignArray.evaluate((JexlContext)jc);
        Assert.assertNotNull((String)"Result is null", (Object)o);
        o = checkArray.evaluate((JexlContext)jc);
        Assert.assertEquals((String)"The array elements are not equal", Collections.emptyList(), Arrays.asList((String[])o));
        Assert.assertEquals((String)"The array size is not zero", (long)0L, (long)((String[])o).length);
        try {
            assignArray = jexl.createExpression("quux.arr2 = [ ]");
            o = assignArray.evaluate((JexlContext)jc);
            Assert.fail((String)"The arr2 property shouldn't be set due to its ambiguity (overloaded setters with different types).");
        }
        catch (JexlException.Property property) {
            // empty catch block
        }
        Assert.assertNull((String)"The arr2 property value should remain as null, not an empty array.", (Object)quux.arr2);
    }

    @Test
    public void test147b() throws Exception {
        String[] scripts = new String[]{"var x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x.one", "x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x.one", "x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x['one']", "var x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x['one']"};
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        for (String s : scripts) {
            Object o = jexl.createScript(s).execute((JexlContext)jc);
            Assert.assertEquals((Object)1, (Object)o);
        }
    }

    @Test
    public void test147c() throws Exception {
        String[] scripts = new String[]{"var x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x.one", "x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x.one", "x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x['one']", "var x = new ('java.util.HashMap'); x.one = 1; x.two = 2; x['one']"};
        Engine jexl = new Engine();
        for (String s : scripts) {
            MapContext jc = new MapContext();
            Object o = jexl.createScript(s).execute((JexlContext)jc);
            Assert.assertEquals((Object)1, (Object)o);
        }
    }

    @Test
    public void test5115a() throws Exception {
        String str = "{\n  var x = \"A comment\";\n  var y = \"A comment\";\n}";
        Engine jexl = new Engine();
        JexlScript s = jexl.createScript("{\n  var x = \"A comment\";\n  var y = \"A comment\";\n}");
    }

    @Test
    public void test5115b() throws Exception {
        String str = "{\n  var x = \"A comment\";\n}";
        Engine jexl = new Engine();
        JexlScript s = jexl.createScript("{\n  var x = \"A comment\";\n}");
    }

    @Test
    public void test5115c() throws Exception {
        URL testUrl = new File(TESTA).toURI().toURL();
        Engine jexl = new Engine();
        JexlScript s = jexl.createScript(testUrl);
    }

    @Test
    public void test148a() throws Exception {
        Engine jexl = new Engine();
        MapContext jc = new MapContext();
        jc.set("u", (Object)new Utils());
        String src = "u.asList(['foo', 'bar'])";
        JexlScript e = jexl.createScript(src);
        Object o = e.execute((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof List));
        Assert.assertEquals(Arrays.asList("foo", "bar"), (Object)o);
        src = "u.asList([1, 2])";
        e = jexl.createScript(src);
        o = e.execute((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof List));
        Assert.assertEquals(Arrays.asList(1, 2), (Object)o);
    }

    @Test
    public void test155() throws Exception {
        Engine jexlEngine = new Engine();
        JexlExpression jexlExpresssion = jexlEngine.createExpression("first.second.name");
        MapContext jc = new MapContext();
        jc.set("first.second.name", (Object)"RIGHT");
        jc.set("name", (Object)"WRONG");
        Object value = jexlExpresssion.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)"RIGHT", (Object)value.toString());
    }

    @Test
    public void testQuestion42() throws Exception {
        JexlEngine jexl = new JexlBuilder().arithmetic((JexlArithmetic)new Arithmetic42()).create();
        Question42 jc = new Question42();
        String str0 = "(functionA('z') | functionB('b')) &  (functionC('c') |  functionD('d') ) ";
        JexlExpression expr0 = jexl.createExpression("(functionA('z') | functionB('b')) &  (functionC('c') |  functionD('d') ) ");
        Object value0 = expr0.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)"BCD", (Object)value0);
        String str1 = "(functionA('z') & functionB('b')) |  (functionC('c') &  functionD('d') ) ";
        JexlExpression expr1 = jexl.createExpression("(functionA('z') & functionB('b')) |  (functionC('c') &  functionD('d') ) ");
        Object value1 = expr1.evaluate((JexlContext)jc);
        Assert.assertEquals((Object)"CD", (Object)value1);
    }

    @Test
    public void test179() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().create();
        String src = "x = new ('java.util.HashSet'); x.add(1); x";
        JexlScript e = jexl.createScript("x = new ('java.util.HashSet'); x.add(1); x");
        Object o = e.execute((JexlContext)jc);
        Assert.assertTrue((boolean)(o instanceof Set));
        Assert.assertTrue((boolean)((Set)o).contains(1));
    }

    @Test
    public void test192() throws Exception {
        MapContext jc = new MapContext();
        jc.set("x.y.z", C192.class);
        JexlEngine jexl = new JexlBuilder().create();
        JexlExpression js0 = jexl.createExpression("x.y.z.callme(t)");
        jc.set("t", null);
        Assert.assertNull((Object)js0.evaluate((JexlContext)jc));
        jc.set("t", (Object)10);
        Assert.assertEquals((Object)42, (Object)js0.evaluate((JexlContext)jc));
        jc.set("t", (Object)-10);
        Assert.assertEquals((Object)-42, (Object)js0.evaluate((JexlContext)jc));
        jc.set("t", null);
        Assert.assertNull((Object)js0.evaluate((JexlContext)jc));
        js0 = jexl.createExpression("x.y.z.kickme().callme(t)");
        jc.set("t", null);
        Assert.assertNull((Object)js0.evaluate((JexlContext)jc));
        jc.set("t", (Object)10);
        Assert.assertEquals((Object)42, (Object)js0.evaluate((JexlContext)jc));
        jc.set("t", (Object)-10);
        Assert.assertEquals((Object)-42, (Object)js0.evaluate((JexlContext)jc));
        jc.set("t", null);
        Assert.assertNull((Object)js0.evaluate((JexlContext)jc));
    }

    @Test
    public void test199() throws Exception {
        MapContext jc = new MapContext();
        JexlEngine jexl = new JexlBuilder().arithmetic(new JexlArithmetic(false)).create();
        JexlScript e = jexl.createScript("(x, y)->{ x + y }");
        Object r = e.execute((JexlContext)jc, new Object[]{true, "EURT"});
        Assert.assertEquals((Object)"trueEURT", (Object)r);
        r = e.execute((JexlContext)jc, new Object[]{"ELSAF", false});
        Assert.assertEquals((Object)"ELSAFfalse", (Object)r);
    }

    public static class C192 {
        public static Integer callme(Integer n) {
            if (n == null) {
                return null;
            }
            return n >= 0 ? 42 : -42;
        }

        public static Object kickme() {
            return C192.class;
        }
    }

    public static class Arithmetic42
    extends JexlArithmetic {
        public Arithmetic42() {
            super(false);
        }

        public Object and(String lhs, String rhs) {
            if (rhs.isEmpty()) {
                return "";
            }
            if (lhs.isEmpty()) {
                return "";
            }
            return lhs + rhs;
        }

        public Object or(String lhs, String rhs) {
            if (rhs.isEmpty()) {
                return lhs;
            }
            if (lhs.isEmpty()) {
                return rhs;
            }
            return lhs + rhs;
        }
    }

    public static class Question42
    extends MapContext {
        public String functionA(String arg) {
            return "a".equals(arg) ? "A" : "";
        }

        public String functionB(String arg) {
            return "b".equals(arg) ? "B" : "";
        }

        public String functionC(String arg) {
            return "c".equals(arg) ? "C" : "";
        }

        public String functionD(String arg) {
            return "d".equals(arg) ? "D" : "";
        }
    }

    public static class Utils {
        public <T> List<T> asList(T[] array) {
            return Arrays.asList(array);
        }

        public List<Integer> asList(int[] array) {
            ArrayList<Integer> l = new ArrayList<Integer>(array.length);
            for (int i : array) {
                l.add(i);
            }
            return l;
        }
    }

    public static class Quux144 {
        String[] arr;
        String[] arr2;

        public String[] getArr() {
            return this.arr;
        }

        public String[] getArr2() {
            return this.arr2;
        }

        public void setArr(String[] arr) {
            this.arr = arr;
        }

        public void setArr2(String[] arr2) {
            this.arr2 = arr2;
        }

        public void setArr2(Integer[] arr2) {
        }
    }

    public static class Foo125Context
    extends ObjectContext<Foo125> {
        public Foo125Context(JexlEngine engine, Foo125 wrapped) {
            super(engine, (Object)wrapped);
        }
    }

    public static class Foo125 {
        public String method() {
            return "OK";
        }

        public String total(String tt) {
            return "total " + tt;
        }
    }

    public static class RichContext
    extends ObjectContext<A105> {
        RichContext(JexlEngine jexl, A105 a105) {
            super(jexl, (Object)a105);
        }
    }

    public static class A105 {
        String nameA;
        String propA;

        public A105(String nameA, String propA) {
            this.nameA = nameA;
            this.propA = propA;
        }

        public String toString() {
            return "A [nameA=" + this.nameA + ", propA=" + this.propA + "]";
        }

        public String getNameA() {
            return this.nameA;
        }

        public String getPropA() {
            return this.propA;
        }

        public String uppercase(String str) {
            return str.toUpperCase();
        }
    }
}

