/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.Foo;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlTestCase;
import org.apache.commons.jexl2.MapContext;
import org.apache.commons.jexl2.parser.Parser;

public class JexlTest
extends JexlTestCase {
    protected static final String METHOD_STRING = "Method string";
    protected static final String GET_METHOD_STRING = "GetMethod string";

    public JexlTest(String testName) {
        super(testName);
    }

    public void testProperty() throws Exception {
        Expression e = this.JEXL.createExpression("foo.bar");
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        Object o = e.evaluate((JexlContext)jc);
        JexlTest.assertTrue((String)"o not instanceof String", (boolean)(o instanceof String));
        JexlTest.assertEquals((String)"o incorrect", (Object)GET_METHOD_STRING, (Object)o);
    }

    public void testBoolean() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        jc.set("a", (Object)Boolean.TRUE);
        jc.set("b", (Object)Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==b)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==true)", "Boolean : true");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(a==false)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "foo.convertBoolean(true==false)", "Boolean : false");
        this.assertExpression((JexlContext)jc, "true eq false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "true ne false", Boolean.TRUE);
    }

    public void testStringLit() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        this.assertExpression((JexlContext)jc, "foo.get(\"woogie\")", "Repeat : woogie");
    }

    public void testExpression() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Foo());
        jc.set("a", (Object)Boolean.TRUE);
        jc.set("b", (Object)Boolean.FALSE);
        jc.set("num", (Object)new Integer(5));
        jc.set("now", (Object)Calendar.getInstance().getTime());
        GregorianCalendar gc = new GregorianCalendar(5000, 11, 20);
        jc.set("now2", (Object)gc.getTime());
        jc.set("bdec", (Object)new BigDecimal("7"));
        jc.set("bint", (Object)new BigInteger("7"));
        this.assertExpression((JexlContext)jc, "a == b", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "a==true", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "a==false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "true==false", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 < 3", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < 5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < num", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num < 2.5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "now2 < now", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'6' <= '5'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num <= 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num <= 2.5", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "now2 <= now", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'6' >= '5'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num >= null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num >= 2.5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "now2 >= now", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'6' > '5'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num > 4", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num > num", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num > null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "num > 2.5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "now2 > now", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "\"foo\" + \"bar\" == \"foobar\"", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bdec > num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bdec >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint > num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint == bdec", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bint >= num", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num <= bint", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "num < bint", Boolean.TRUE);
    }

    public void testEmpty() throws Exception {
        MapContext jc = new MapContext();
        jc.set("string", (Object)"");
        jc.set("array", (Object)new Object[0]);
        jc.set("map", new HashMap());
        jc.set("list", new ArrayList());
        jc.set("set", new HashMap().keySet());
        jc.set("longstring", (Object)"thingthing");
        this.assertExpression((JexlContext)jc, "empty nullthing", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty string", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty array", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty map", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty set", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty list", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "empty longstring", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "not empty longstring", Boolean.TRUE);
    }

    public void testSize() throws Exception {
        MapContext jc = new MapContext();
        jc.set("s", (Object)"five!");
        jc.set("array", (Object)new Object[5]);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("1", new Integer(1));
        map.put("2", new Integer(2));
        map.put("3", new Integer(3));
        map.put("4", new Integer(4));
        map.put("5", new Integer(5));
        jc.set("map", map);
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        list.add("2");
        list.add("3");
        list.add("4");
        list.add("5");
        jc.set("list", list);
        HashSet<String> set = new HashSet<String>();
        set.addAll(list);
        set.add("1");
        jc.set("set", set);
        BitSet bitset = new BitSet(5);
        jc.set("bitset", (Object)bitset);
        this.assertExpression((JexlContext)jc, "size(s)", new Integer(5));
        this.assertExpression((JexlContext)jc, "size(array)", new Integer(5));
        this.assertExpression((JexlContext)jc, "size(list)", new Integer(5));
        this.assertExpression((JexlContext)jc, "size(map)", new Integer(5));
        this.assertExpression((JexlContext)jc, "size(set)", new Integer(5));
        this.assertExpression((JexlContext)jc, "size(bitset)", new Integer(64));
        this.assertExpression((JexlContext)jc, "list.size()", new Integer(5));
        this.assertExpression((JexlContext)jc, "map.size()", new Integer(5));
        this.assertExpression((JexlContext)jc, "set.size()", new Integer(5));
        this.assertExpression((JexlContext)jc, "bitset.size()", new Integer(64));
        this.assertExpression((JexlContext)jc, "list.get(size(list) - 1)", "5");
        this.assertExpression((JexlContext)jc, "list[size(list) - 1]", "5");
        this.assertExpression((JexlContext)jc, "list.get(list.size() - 1)", "5");
    }

    public void testSizeAsProperty() throws Exception {
        MapContext jc = new MapContext();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("size", "cheese");
        jc.set("map", map);
        jc.set("foo", (Object)new Foo());
        this.assertExpression((JexlContext)jc, "map['size']", "cheese");
        this.assertExpression((JexlContext)jc, "foo.getSize()", new Integer(22));
    }

    public void testNew() throws Exception {
        MapContext jc = new MapContext();
        jc.set("double", Double.class);
        jc.set("foo", (Object)"org.apache.commons.jexl2.Foo");
        Expression expr = this.JEXL.createExpression("new(double, 1)");
        Object value = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)new Double(1.0), (Object)value);
        expr = this.JEXL.createExpression("new('java.lang.Float', 100)");
        value = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)new Float(100.0), (Object)value);
        expr = this.JEXL.createExpression("new(foo).quux");
        value = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)"Repeat : quux", (Object)value);
    }

    public void testCalculations() throws Exception {
        MapContext jc = new MapContext();
        jc.set("stringy", (Object)"thingy");
        this.assertExpression((JexlContext)jc, "stringy + 2", "thingy2");
        jc.set("imanull", null);
        this.assertExpression((JexlContext)jc, "imanull + 2", new Integer(2));
        this.assertExpression((JexlContext)jc, "imanull + imanull", new Integer(0));
        jc.set("n", (Object)new Integer(0));
        this.assertExpression((JexlContext)jc, "n != null && n != 0", Boolean.FALSE);
    }

    public void testConditions() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)new Integer(2));
        jc.set("aFloat", (Object)new Float(1.0f));
        jc.set("aDouble", (Object)new Double(2.0));
        jc.set("aChar", (Object)new Character('A'));
        jc.set("aBool", (Object)Boolean.TRUE);
        StringBuilder buffer = new StringBuilder("abc");
        ArrayList list = new ArrayList();
        LinkedList list2 = new LinkedList();
        jc.set("aBuffer", (Object)buffer);
        jc.set("aList", list);
        jc.set("bList", list2);
        this.assertExpression((JexlContext)jc, "foo == 2", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 == 3", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "3 == foo", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "3 != foo", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo != 2", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aFloat eq aDouble", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aFloat ne aDouble", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aFloat == aDouble", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aFloat != aDouble", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == aChar", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo != aChar", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aBool == 'true'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aBool == 'false'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aBool != 'false'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aBool == notThere", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aBool != notThere", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aBuffer == 'abc'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aBuffer != 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "aList == bList", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "aList != bList", Boolean.FALSE);
    }

    public void testNotConditions() throws Exception {
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        jc.set("x", (Object)Boolean.TRUE);
        jc.set("foo", (Object)foo);
        jc.set("bar", (Object)"true");
        this.assertExpression((JexlContext)jc, "!x", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "x", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!bar", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!foo.isSimple()", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.isSimple()", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!foo.simple", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.simple", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.getCheeseList().size() == 3", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.cheeseList.size() == 3", Boolean.TRUE);
        jc.set("string", (Object)"");
        this.assertExpression((JexlContext)jc, "not empty string", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "not(empty string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "not empty(string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "! empty string", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!(empty string)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!empty(string)", Boolean.FALSE);
    }

    public void testNotConditionsWithDots() throws Exception {
        MapContext jc = new MapContext();
        jc.set("x.a", (Object)Boolean.TRUE);
        jc.set("x.b", (Object)Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "x.a", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "!x.a", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "!x.b", Boolean.TRUE);
    }

    public void testComparisons() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"the quick and lazy fox");
        this.assertExpression((JexlContext)jc, "foo.indexOf('quick') > 0", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.indexOf('bar') >= 0", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo.indexOf('bar') < 0", Boolean.TRUE);
    }

    public void testNull() throws Exception {
        MapContext jc = new MapContext();
        jc.set("bar", (Object)new Integer(2));
        this.assertExpression((JexlContext)jc, "empty foo", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bar == null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == null", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bar != null", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo != null", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "empty(bar)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "empty(foo)", Boolean.TRUE);
    }

    public void testStringQuoting() throws Exception {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "'\"Hello\"'", "\"Hello\"");
        this.assertExpression((JexlContext)jc, "\"I'm testing\"", "I'm testing");
    }

    public void testBlankStrings() throws Exception {
        MapContext jc = new MapContext();
        jc.set("bar", (Object)"");
        this.assertExpression((JexlContext)jc, "foo == ''", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "bar == ''", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "barnotexist == ''", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "empty bar", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "bar.length() == 0", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "size(bar) == 0", Boolean.TRUE);
    }

    public void testLogicExpressions() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"abc");
        jc.set("bar", (Object)"def");
        this.assertExpression((JexlContext)jc, "foo == 'abc' || bar == 'abc'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' or bar == 'abc'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' && bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' and bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'def' || bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'def' or bar == 'abc'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' && bar == 'def'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'abc' and bar == 'def'", Boolean.TRUE);
    }

    public void testVariableNames() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo_bar", (Object)"123");
        this.assertExpression((JexlContext)jc, "foo_bar", "123");
    }

    public void testMapDot() throws Exception {
        HashMap<String, String> foo = new HashMap<String, String>();
        foo.put("bar", "123");
        MapContext jc = new MapContext();
        jc.set("foo", foo);
        this.assertExpression((JexlContext)jc, "foo.bar", "123");
    }

    public void testStringLiterals() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"bar");
        this.assertExpression((JexlContext)jc, "foo == \"bar\"", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo == 'bar'", Boolean.TRUE);
    }

    public void testIntProperty() throws Exception {
        Foo foo = new Foo();
        JexlTest.assertEquals((int)4, (int)foo.square(2));
        JexlTest.assertEquals((int)4, (int)foo.square(-2));
        MapContext jc = new MapContext();
        jc.set("foo", (Object)foo);
        this.assertExpression((JexlContext)jc, "foo.count", new Integer(5));
        this.assertExpression((JexlContext)jc, "foo.square(2)", new Integer(4));
        this.assertExpression((JexlContext)jc, "foo.square(-2)", new Integer(4));
    }

    public void testNegativeIntComparison() throws Exception {
        MapContext jc = new MapContext();
        Foo foo = new Foo();
        jc.set("foo", (Object)foo);
        this.assertExpression((JexlContext)jc, "foo.count != -1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.count == 5", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "foo.count == -1", Boolean.FALSE);
    }

    public void testCharAtBug() throws Exception {
        MapContext jc = new MapContext();
        jc.set("foo", (Object)"abcdef");
        this.assertExpression((JexlContext)jc, "foo.substring(2,4)", "cd");
        this.assertExpression((JexlContext)jc, "foo.charAt(2)", new Character('c'));
        this.assertExpression((JexlContext)jc, "foo.charAt(-2)", null);
    }

    public void testEmptyDottedVariableName() throws Exception {
        MapContext jc = new MapContext();
        jc.set("this.is.a.test", (Object)"");
        this.assertExpression((JexlContext)jc, "empty(this.is.a.test)", Boolean.TRUE);
    }

    public void testEmptySubListOfMap() throws Exception {
        MapContext jc = new MapContext();
        HashMap m = new HashMap();
        m.put("aList", new ArrayList());
        jc.set("aMap", m);
        this.assertExpression((JexlContext)jc, "empty( aMap.aList )", Boolean.TRUE);
    }

    public void testCoercionWithComparisionOperators() throws Exception {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "'2' > 1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' >= 1", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' >= 2", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "'2' < 1", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'2' <= 1", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'2' <= 2", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 > '1'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 >= '1'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 >= '2'", Boolean.TRUE);
        this.assertExpression((JexlContext)jc, "2 < '1'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 <= '1'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "2 <= '2'", Boolean.TRUE);
    }

    public void testBooleanShortCircuitAnd() throws Exception {
        Foo tester = new Foo();
        MapContext jc = new MapContext();
        jc.set("first", (Object)Boolean.FALSE);
        jc.set("foo", (Object)tester);
        Expression expr = this.JEXL.createExpression("first and foo.trueAndModify");
        expr.evaluate((JexlContext)jc);
        JexlTest.assertTrue((String)"Short circuit failure: rhs evaluated when lhs FALSE", (!tester.getModified() ? 1 : 0) != 0);
        tester = new Foo();
        jc.set("first", (Object)Boolean.TRUE);
        jc.set("foo", (Object)tester);
        expr.evaluate((JexlContext)jc);
        JexlTest.assertTrue((String)"Short circuit failure: rhs not evaluated when lhs TRUE", (boolean)tester.getModified());
    }

    public void testBooleanShortCircuitOr() throws Exception {
        Foo tester = new Foo();
        MapContext jc = new MapContext();
        jc.set("first", (Object)Boolean.FALSE);
        jc.set("foo", (Object)tester);
        Expression expr = this.JEXL.createExpression("first or foo.trueAndModify");
        expr.evaluate((JexlContext)jc);
        JexlTest.assertTrue((String)"Short circuit failure: rhs not evaluated when lhs FALSE", (boolean)tester.getModified());
        tester = new Foo();
        jc.set("first", (Object)Boolean.TRUE);
        jc.set("foo", (Object)tester);
        expr.evaluate((JexlContext)jc);
        JexlTest.assertTrue((String)"Short circuit failure: rhs evaluated when lhs TRUE", (!tester.getModified() ? 1 : 0) != 0);
    }

    public void testStringConcatenation() throws Exception {
        MapContext jc = new MapContext();
        jc.set("first", (Object)"Hello");
        jc.set("second", (Object)"World");
        this.assertExpression((JexlContext)jc, "first + ' ' + second", "Hello World");
    }

    public void testToString() throws Exception {
        String code = "abcd";
        Expression expr = this.JEXL.createExpression(code);
        JexlTest.assertEquals((String)"Bad expression value", (String)code, (String)expr.toString());
    }

    public void testBadParse() throws Exception {
        try {
            this.assertExpression((JexlContext)new MapContext(), "empty()", null);
            JexlTest.fail((String)"Bad expression didn't throw ParseException");
        }
        catch (JexlException jexlException) {
            // empty catch block
        }
    }

    public void testComment() throws Exception {
        this.assertExpression((JexlContext)new MapContext(), "## double or nothing\n 1 + 1", Integer.valueOf("2"));
    }

    public void testAssignment() throws Exception {
        MapContext jc = new MapContext();
        jc.set("aString", (Object)"Hello");
        Foo foo = new Foo();
        jc.set("foo", (Object)foo);
        Parser parser = new Parser((Reader)new StringReader(";"));
        parser.parse((Reader)new StringReader("aString = 'World';"), null);
        this.assertExpression((JexlContext)jc, "hello = 'world'", "world");
        JexlTest.assertEquals((String)"hello variable not changed", (Object)"world", (Object)jc.get("hello"));
        this.assertExpression((JexlContext)jc, "result = 1 + 1", new Integer(2));
        JexlTest.assertEquals((String)"result variable not changed", (Object)new Integer(2), (Object)jc.get("result"));
    }

    public void testAntPropertiesWithMethods() throws Exception {
        MapContext jc = new MapContext();
        String value = "Stinky Cheese";
        jc.set("maven.bob.food", (Object)value);
        this.assertExpression((JexlContext)jc, "maven.bob.food.length()", new Integer(value.length()));
        this.assertExpression((JexlContext)jc, "empty(maven.bob.food)", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "size(maven.bob.food)", new Integer(value.length()));
        this.assertExpression((JexlContext)jc, "maven.bob.food + ' is good'", value + " is good");
    }

    public void testUnicodeSupport() throws Exception {
        MapContext jc = new MapContext();
        this.assertExpression((JexlContext)jc, "myvar == 'U\u00c5\u00bcytkownik'", Boolean.FALSE);
        this.assertExpression((JexlContext)jc, "'c:\\some\\windows\\path'", "c:\\some\\windows\\path");
        this.assertExpression((JexlContext)jc, "'foo\\u0020bar'", "foo bar");
        this.assertExpression((JexlContext)jc, "'foo\\u0020\\u0020bar'", "foo  bar");
        this.assertExpression((JexlContext)jc, "'\\u0020foobar\\u0020'", " foobar ");
    }

    public void testDuck() throws Exception {
        JexlEngine jexl = this.JEXL;
        MapContext jc = new MapContext();
        jc.set("duck", (Object)new Duck());
        Expression expr = jexl.createExpression("duck.zero");
        Object result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)0, (Object)result);
        expr = jexl.createExpression("duck.one");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)1, (Object)result);
        expr = jexl.createExpression("duck.user = 20");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)20, (Object)result);
        expr = jexl.createExpression("duck.user");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)20, (Object)result);
        expr = jexl.createExpression("duck.user = 'zero'");
        result = expr.evaluate((JexlContext)jc);
        expr = jexl.createExpression("duck.user");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)0, (Object)result);
    }

    public void testArray() throws Exception {
        int[] array = new int[]{100, 101, 102};
        JexlEngine jexl = this.JEXL;
        MapContext jc = new MapContext();
        jc.set("array", (Object)array);
        Expression expr = jexl.createExpression("array.1");
        Object result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)101, (Object)result);
        expr = jexl.createExpression("array[1] = 1010");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)1010, (Object)result);
        expr = jexl.createExpression("array.0");
        result = expr.evaluate((JexlContext)jc);
        JexlTest.assertEquals((String)expr.toString(), (Object)100, (Object)result);
    }

    protected void assertExpression(JexlContext jc, String expression, Object expected) throws Exception {
        Expression e = this.JEXL.createExpression(expression);
        Object actual = e.evaluate(jc);
        JexlTest.assertEquals((String)expression, (Object)expected, (Object)actual);
    }

    public static final class Duck {
        int user = 10;

        public Integer get(String val) {
            if ("zero".equals(val)) {
                return 0;
            }
            if ("one".equals(val)) {
                return 1;
            }
            if ("user".equals(val)) {
                return this.user;
            }
            return -1;
        }

        public void set(String val, Object value) {
            if ("user".equals(val)) {
                this.user = "zero".equals(value) ? 0 : ("one".equals(value) ? 1 : (value instanceof Integer ? (Integer)value : -1));
            }
        }
    }
}

