/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.engine.control;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.MockAuxiliaryCache;
import org.apache.commons.jcs3.engine.CacheElement;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICacheType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;
import org.apache.commons.jcs3.engine.control.CompositeCache;
import org.apache.commons.jcs3.engine.memory.MockMemoryCache;

public class CompositeCacheUnitTest
extends TestCase {
    public void testShutdownMemoryFlush() throws IOException {
        String cacheName = "testCacheName";
        String mockMemoryCacheClassName = "org.apache.commons.jcs3.engine.memory.MockMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.MockMemoryCache");
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{diskMock}));
        int numToInsert = 10;
        for (int i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("testCacheName", (Object)String.valueOf(i), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        cache.dispose();
        MockMemoryCache memoryCache = (MockMemoryCache)cache.getMemoryCache();
        CompositeCacheUnitTest.assertEquals((String)"Wrong number freed.", (int)10, (int)memoryCache.lastNumberOfFreedElements);
    }

    public void testShutdownMemoryFlush_noDisk() throws IOException {
        String cacheName = "testCacheName";
        String mockMemoryCacheClassName = "org.apache.commons.jcs3.engine.memory.MockMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.MockMemoryCache");
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.REMOTE_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{diskMock}));
        int numToInsert = 10;
        for (int i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("testCacheName", (Object)String.valueOf(i), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        cache.dispose();
        MockMemoryCache memoryCache = (MockMemoryCache)cache.getMemoryCache();
        CompositeCacheUnitTest.assertEquals((String)"Wrong number freed.", (int)0, (int)memoryCache.lastNumberOfFreedElements);
    }

    public void testGetMatching_Normal() throws IOException {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String cacheName = "testGetMatching_Normal";
        String memoryCacheClassName = "org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache");
        cattr.setMaxObjects(1000);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{diskMock}));
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < 10; ++i) {
            CacheElement element = new CacheElement("testGetMatching_Normal", (Object)("MyPrefix1" + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < 50; ++i) {
            CacheElement element = new CacheElement("testGetMatching_Normal", (Object)("MyPrefix2" + String.valueOf(i)), (Object)i);
            cache.update((ICacheElement)element, false);
        }
        Map result1 = cache.getMatching("MyPrefix1\\S+");
        Map result2 = cache.getMatching("MyPrefix2\\S+");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number returned 1:", (int)10, (int)result1.size());
        CompositeCacheUnitTest.assertEquals((String)"Wrong number returned 2:", (int)50, (int)result2.size());
    }

    public void testGetMatching_NotOnDisk() throws IOException {
        boolean maxMemorySize = false;
        String cacheName = "testGetMatching_NotOnDisk";
        String memoryCacheClassName = "org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName("testGetMatching_NotOnDisk");
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache");
        cattr.setMaxObjects(0);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.DISK_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{diskMock}));
        cache.getMatching("junk");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number of calls", (int)1, (int)diskMock.getMatchingCallCount);
    }

    public void testGetMatching_NotOnRemote() throws IOException {
        boolean maxMemorySize = false;
        String cacheName = "testGetMatching_NotOnDisk";
        String memoryCacheClassName = "org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setCacheName("testGetMatching_NotOnDisk");
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache");
        cattr.setMaxObjects(0);
        ElementAttributes attr = new ElementAttributes();
        CompositeCache cache = new CompositeCache((ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        MockAuxiliaryCache diskMock = new MockAuxiliaryCache();
        diskMock.cacheType = ICacheType.CacheType.REMOTE_CACHE;
        cache.setAuxCaches(Arrays.asList(new AuxiliaryCache[]{diskMock}));
        cache.getMatching("junk");
        CompositeCacheUnitTest.assertEquals((String)"Wrong number of calls", (int)1, (int)diskMock.getMatchingCallCount);
    }
}

