/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.palette;

import java.awt.image.BufferedImage;
import java.util.LinkedList;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.palette.ColorSpaceSubset;
import org.apache.commons.imaging.palette.Dithering;
import org.apache.commons.imaging.palette.Palette;
import org.apache.commons.imaging.palette.QuantizedPalette;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DitheringTest {
    @Test
    public void testApplyFloydSteinbergDitheringWithNonNullOne() throws ImagingException {
        BufferedImage bufferedImage = new BufferedImage(8, 8, 8);
        bufferedImage.setRGB(2, 2, 2);
        LinkedList<ColorSpaceSubset> linkedList = new LinkedList<ColorSpaceSubset>();
        ColorSpaceSubset colorSpaceSubset = new ColorSpaceSubset(-234, -352);
        colorSpaceSubset.rgb = 8;
        linkedList.add(colorSpaceSubset);
        QuantizedPalette quantizedPalette = new QuantizedPalette(linkedList, 8);
        Dithering.applyFloydSteinbergDithering((BufferedImage)bufferedImage, (Palette)quantizedPalette);
        Assertions.assertEquals((int)-16777208, (int)bufferedImage.getRGB(0, 0));
        Assertions.assertEquals((int)-16777208, (int)bufferedImage.getRGB(1, 1));
        Assertions.assertEquals((int)-16777208, (int)bufferedImage.getRGB(2, 1));
        Assertions.assertEquals((int)-16777208, (int)bufferedImage.getRGB(2, 2));
    }

    @Test
    public void testApplyFloydSteinbergDitheringWithNonNullTwo() throws ImagingException {
        BufferedImage bufferedImage = new BufferedImage(3, 3, 3);
        bufferedImage.setRGB(1, 2, 4);
        LinkedList<ColorSpaceSubset> linkedList = new LinkedList<ColorSpaceSubset>();
        ColorSpaceSubset colorSpaceSubset = new ColorSpaceSubset(-234, -352);
        linkedList.add(colorSpaceSubset);
        QuantizedPalette quantizedPalette = new QuantizedPalette(linkedList, 3);
        Dithering.applyFloydSteinbergDithering((BufferedImage)bufferedImage, (Palette)quantizedPalette);
        Assertions.assertEquals((int)-1, (int)bufferedImage.getRGB(0, 0));
        Assertions.assertEquals((int)-1, (int)bufferedImage.getRGB(1, 1));
        Assertions.assertEquals((int)-1, (int)bufferedImage.getRGB(2, 1));
        Assertions.assertEquals((int)-1, (int)bufferedImage.getRGB(2, 2));
    }
}

