/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.webp;

import java.io.File;
import java.io.IOException;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.webp.AbstractWebPTest;
import org.apache.commons.imaging.formats.webp.WebPImageParser;
import org.apache.commons.imaging.formats.webp.chunks.WebPChunkIccp;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class WebPReadTest
extends AbstractWebPTest {
    @Test
    public void testBufferedImageNotSupported() throws IOException {
        File emptyWebP = new File(WebPReadTest.class.getResource("/images/webp/empty/empty-100x100.webp").getFile());
        WebPImageParser parser = new WebPImageParser();
        ImagingException exception = (ImagingException)Assertions.assertThrows(ImagingException.class, () -> parser.getBufferedImage(ByteSource.file((File)emptyWebP), parser.getDefaultParameters()));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Reading WebP files is currently not supported"));
    }

    @Test
    public void testParser() {
        WebPImageParser parser = new WebPImageParser();
        Assertions.assertEquals((Object)"WebP-Custom", (Object)parser.getName());
        Assertions.assertEquals((Object)"webp", (Object)parser.getDefaultExtension());
    }

    @ParameterizedTest
    @MethodSource(value={"images"})
    public void testRead(File imageFile) throws Exception {
        Debug.debug((String)"start");
        Debug.debug((String)"imageFile", (Object)imageFile);
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        Assertions.assertFalse((boolean)(metadata instanceof File));
        ImageInfo imageInfo = Imaging.getImageInfo((File)imageFile);
        Assertions.assertNotNull((Object)imageInfo);
        Debug.debug((String)"ICC profile", (Object)Imaging.getIccProfileBytes((File)imageFile));
    }

    @Test
    public void testWebPChunkInvalidSizeBytes() {
        ImagingException exception = (ImagingException)Assertions.assertThrows(ImagingException.class, () -> new WebPChunkIccp(0, 10, new byte[0]));
        Assertions.assertEquals((Object)"Chunk size must match bytes length", (Object)exception.getMessage());
    }
}

