/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImagingParameters;
import org.apache.commons.imaging.formats.jpeg.exif.AbstractExifTest;
import org.apache.commons.imaging.formats.tiff.TiffField;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class AbstractSpecificExifTagTest
extends AbstractExifTest {
    public static Stream<File> data() throws Exception {
        return AbstractSpecificExifTagTest.getImagesWithExifData().stream();
    }

    protected abstract void checkField(File var1, TiffField var2) throws IOException, ImagingException, ImagingException;

    private void checkImage(File imageFile) throws IOException, ImagingException, ImagingException {
        JpegImagingParameters params = new JpegImagingParameters();
        ImageMetadata metadata = Imaging.getMetadata((File)imageFile);
        if (null == metadata) {
            return;
        }
        JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
        TiffImageMetadata exif = jpegMetadata.getExif();
        if (null == exif) {
            return;
        }
        List fields = exif.getAllFields();
        for (TiffField field : fields) {
            this.checkField(imageFile, field);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testAllImages(File imageFile) throws Exception {
        if (imageFile.getParentFile().getName().toLowerCase().equals("@broken")) {
            return;
        }
        this.checkImage(imageFile);
    }
}

