/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg.exif;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.imaging.AbstractImagingTest;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegImageParser;

public abstract class AbstractExifTest
extends AbstractImagingTest {
    private static final AbstractImagingTest.ImageFilter HAS_EXIF_IMAGE_FILTER = AbstractExifTest::hasExifData;
    private static final AbstractImagingTest.ImageFilter JPEG_IMAGE_FILTER = file -> file.getName().toLowerCase().endsWith(".jpg");

    protected static List<File> getImagesWithExifData() throws IOException, ImagingException {
        return AbstractExifTest.getTestImages(HAS_EXIF_IMAGE_FILTER);
    }

    protected static List<File> getJpegImages() throws IOException, ImagingException {
        return AbstractExifTest.getTestImages(JPEG_IMAGE_FILTER);
    }

    protected static boolean hasExifData(File file) {
        if (!file.getName().toLowerCase().endsWith(".jpg")) {
            return false;
        }
        try {
            ByteSource byteSource = ByteSource.file((File)file);
            return new JpegImageParser().hasExifSegment(byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected static boolean hasExifData(String fileName, byte[] bytes) {
        try {
            ByteSource byteSource = ByteSource.array((byte[])bytes, (String)fileName);
            return new JpegImageParser().hasExifSegment(byteSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    protected File getImageWithExifData() throws IOException, ImagingException {
        return this.getTestImage(HAS_EXIF_IMAGE_FILTER);
    }
}

