/* $Id: AnnotationRuleProvider.java 992060 2010-09-02 19:09:47Z simonetripodi $
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.digester.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;

import org.apache.commons.digester.Rule;

/**
 * An object capable of providing instances of {@link Rule}.
 *
 * @since 2.1
 */
public interface AnnotationRuleProvider<A extends Annotation, E extends AnnotatedElement, R extends Rule> {

    /**
     * Initializes the provider.
     *
     * @param annotation the annotation instance.
     * @param element the annotated element reference.
     */
    void init(A annotation, E element);

    /**
     * Provides an instance of {@link Rule}.
     *
     * Must never return null.
     *
     * @return an instance of {@link Rule}.
     */
    R get();

}
