/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.bzip2;

import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.compress.compressors.bzip2.BlockSort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class BlockSortTest {
    private static final byte[] FIXTURE = new byte[]{0, 1, -4, -3, -1, -2, 3, 2, -128};
    private static final byte[] FIXTURE_BWT = new byte[]{-128, 0, 3, -2, 2, 1, -4, -1, -3};
    private static final int[] FIXTURE_SORTED = new int[]{0, 1, 7, 6, 8, 2, 3, 5, 4};
    private static final byte[] FIXTURE2 = new byte[]{67, 111, 109, 109, 111, 110, 115, 32, 67, 111, 109, 112, 114, 101, 115, 115};
    private static final byte[] FIXTURE2_BWT = new byte[]{115, 115, 32, 114, 111, 109, 111, 111, 67, 67, 109, 109, 112, 110, 115, 101};

    BlockSortTest() {
    }

    private void assertFixture2Sorted(BZip2CompressorOutputStream.Data data) {
        this.assertFixtureSorted(data, FIXTURE2, FIXTURE2_BWT);
    }

    private void assertFixtureSorted(BZip2CompressorOutputStream.Data data) {
        this.assertFixtureSorted(data, FIXTURE, FIXTURE_BWT);
    }

    private void assertFixtureSorted(BZip2CompressorOutputStream.Data data, byte[] fixture, byte[] fixtureBwt) {
        Assertions.assertEquals((byte)fixture[fixture.length - 1], (byte)data.block[0]);
        for (int i = 0; i < fixture.length; ++i) {
            Assertions.assertEquals((byte)fixtureBwt[i], (byte)data.block[data.fmap[i]]);
        }
    }

    private DS setUpFixture() {
        return this.setUpFixture(FIXTURE);
    }

    private DS setUpFixture(byte[] fixture) {
        BZip2CompressorOutputStream.Data data = new BZip2CompressorOutputStream.Data(1);
        System.arraycopy(fixture, 0, data.block, 1, fixture.length);
        return new DS(data, new BlockSort(data));
    }

    private DS setUpFixture2() {
        return this.setUpFixture(FIXTURE2);
    }

    @Test
    void testFallbackSort() {
        BZip2CompressorOutputStream.Data data = new BZip2CompressorOutputStream.Data(1);
        BlockSort s = new BlockSort(data);
        int[] fmap = new int[FIXTURE.length];
        s.fallbackSort(fmap, FIXTURE, FIXTURE.length);
        Assertions.assertArrayEquals((int[])FIXTURE_SORTED, (int[])fmap);
    }

    @Test
    void testSortFixture() {
        DS ds = this.setUpFixture();
        ds.s.blockSort(ds.data, FIXTURE.length - 1);
        this.assertFixtureSorted(ds.data);
        Assertions.assertEquals((int)0, (int)((DS)ds).data.origPtr);
    }

    @Test
    void testSortFixture2() {
        DS ds = this.setUpFixture2();
        ds.s.blockSort(ds.data, FIXTURE2.length - 1);
        this.assertFixture2Sorted(ds.data);
        Assertions.assertEquals((int)1, (int)((DS)ds).data.origPtr);
    }

    @Test
    void testSortFixture2FallbackSort() {
        DS ds = this.setUpFixture2();
        ds.s.fallbackSort(ds.data, FIXTURE2.length - 1);
        this.assertFixture2Sorted(ds.data);
    }

    @Test
    void testSortFixture2MainSort() {
        DS ds = this.setUpFixture2();
        ds.s.mainSort(ds.data, FIXTURE2.length - 1);
        this.assertFixture2Sorted(ds.data);
    }

    @Test
    void testSortFixtureFallbackSort() {
        DS ds = this.setUpFixture();
        ds.s.fallbackSort(ds.data, FIXTURE.length - 1);
        this.assertFixtureSorted(ds.data);
    }

    @Test
    void testSortFixtureMainSort() {
        DS ds = this.setUpFixture();
        ds.s.mainSort(ds.data, FIXTURE.length - 1);
        this.assertFixtureSorted(ds.data);
    }

    private static final class DS {
        private final BZip2CompressorOutputStream.Data data;
        private final BlockSort s;

        DS(BZip2CompressorOutputStream.Data data, BlockSort s) {
            this.data = data;
            this.s = s;
        }
    }
}

