/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.FalsePredicate;
import org.apache.commons.collections4.functors.NotNullPredicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.iterators.AbstractIteratorTest;
import org.apache.commons.collections4.iterators.ArrayIterator;
import org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.commons.lang3.ArrayUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FilterIteratorTest<E>
extends AbstractIteratorTest<E> {
    private static final List<Integer> collectionInts = Arrays.asList(1, 2, 3, 4, 5, 6);
    private String[] array;
    private List<E> list;
    private FilterIterator<E> iterator;

    private void initIterator() {
        this.iterator = this.makeObject();
    }

    protected FilterIterator<E> makeBlockAllFilter(Iterator<E> i) {
        Predicate pred = x -> false;
        return new FilterIterator(i, pred);
    }

    @Override
    public FilterIterator<E> makeEmptyIterator() {
        return this.makeBlockAllFilter((Iterator<E>)new ArrayIterator((Object)this.array));
    }

    @Override
    public FilterIterator<E> makeObject() {
        this.list = new ArrayList<Object>(Arrays.asList((Object[])this.array));
        return this.makePassThroughFilter(this.list.iterator());
    }

    protected FilterIterator<E> makePassThroughFilter(Iterator<E> i) {
        Predicate pred = x -> true;
        return new FilterIterator(i, pred);
    }

    @BeforeEach
    public void setUp() {
        this.array = new String[]{"a", "b", "c"};
        this.initIterator();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.iterator = null;
    }

    @Test
    public void testAddTo() {
        ArrayList<E> expected = new ArrayList<E>(this.list);
        expected.addAll(this.list);
        FilterIterator filterIterator = new FilterIterator(this.list.iterator());
        List actual = (List)filterIterator.addTo(new ArrayList<E>(this.list));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testAddToCollection() {
        ArrayList<E> expected = new ArrayList<E>(this.list);
        expected.addAll(this.list);
        FilterIterator filterIterator = new FilterIterator(this.list.iterator());
        List actual = (List)filterIterator.toCollection(() -> new ArrayList<E>(this.list));
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testAddToEmpty() {
        FilterIterator<E> filterIterator = this.makeEmptyIterator();
        List actual = (List)filterIterator.addTo(new ArrayList<E>(this.list));
        Assertions.assertEquals(this.list, (Object)actual);
    }

    @Test
    public void testAddToEmptyToEmpty() {
        FilterIterator<E> filterIterator = this.makeEmptyIterator();
        List actual = (List)filterIterator.addTo(new ArrayList());
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void testConstructorPredicateFilterInts() {
        List<Integer> expected = Arrays.asList(2, 4, 6);
        Predicate predicate = i -> i % 2 == 0;
        FilterIterator filter = new FilterIterator(collectionInts.iterator(), predicate);
        ArrayList actual = new ArrayList();
        filter.forEachRemaining(actual::add);
        Assertions.assertEquals(expected, actual);
    }

    @Test
    public void testForEachRemainingAcceptAllCtor() {
        List expected = IteratorUtils.toList(this.makeObject());
        FilterIterator it = new FilterIterator(this.makeObject(), TruePredicate.truePredicate());
        ArrayList actual = new ArrayList();
        it.forEachRemaining(actual::add);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testForEachRemainingDefaultCtor() {
        List expected = IteratorUtils.toList(this.makeObject());
        FilterIterator it = new FilterIterator();
        it.setIterator(expected.iterator());
        ArrayList actual = new ArrayList();
        it.forEachRemaining(actual::add);
        Assertions.assertEquals((Object)expected, actual);
    }

    @Test
    public void testForEachRemainingRejectAllCtor() {
        List expected = IteratorUtils.toList(this.makeObject());
        FilterIterator it = new FilterIterator(this.makeObject(), FalsePredicate.falsePredicate());
        ArrayList actual = new ArrayList();
        it.forEachRemaining(actual::add);
        Assertions.assertTrue((boolean)actual.isEmpty());
    }

    @Test
    public void testRemoveNext() {
        FilterIterator<E> iter = this.makeObject();
        Object i = iter.removeNext();
        Assertions.assertFalse((boolean)this.list.contains(i));
        ArrayList actual = new ArrayList();
        iter.forEachRemaining(actual::add);
        Assertions.assertEquals(this.list, actual);
    }

    @Test
    public void testRemoveNextEmpty() {
        FilterIterator<E> empty = this.makeEmptyIterator();
        Assertions.assertThrows(NoSuchElementException.class, () -> empty.removeNext());
    }

    @Test
    public void testRepeatedHasNext() {
        for (int i = 0; i <= this.array.length; ++i) {
            Assertions.assertTrue((boolean)this.iterator.hasNext());
        }
    }

    @Test
    public void testRepeatedNext() {
        for (String element : this.array) {
            this.iterator.next();
        }
        this.verifyNoMoreElements();
    }

    @Test
    public void testReturnValues() {
        this.verifyElementsInPredicate(ArrayUtils.EMPTY_STRING_ARRAY);
        this.verifyElementsInPredicate(new String[]{"a"});
        this.verifyElementsInPredicate(new String[]{"b"});
        this.verifyElementsInPredicate(new String[]{"c"});
        this.verifyElementsInPredicate(new String[]{"a", "b"});
        this.verifyElementsInPredicate(new String[]{"a", "c"});
        this.verifyElementsInPredicate(new String[]{"b", "c"});
        this.verifyElementsInPredicate(new String[]{"a", "b", "c"});
    }

    @Test
    public void testSetIterator() {
        Iterator<Object> iter1 = Collections.singleton(new Object()).iterator();
        Iterator iter2 = Collections.emptyList().iterator();
        FilterIterator filterIterator = new FilterIterator(iter1);
        filterIterator.setPredicate(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)filterIterator.hasNext());
        filterIterator.setIterator(iter2);
        Assertions.assertFalse((boolean)filterIterator.hasNext());
    }

    @Test
    public void testSetPredicate() {
        Iterator<Object> iter = Collections.singleton(null).iterator();
        FilterIterator filterIterator = new FilterIterator(iter);
        filterIterator.setPredicate(TruePredicate.truePredicate());
        Assertions.assertTrue((boolean)filterIterator.hasNext());
        filterIterator.setPredicate(NotNullPredicate.notNullPredicate());
        Assertions.assertFalse((boolean)filterIterator.hasNext());
    }

    @Test
    public void testToCollectionAsDeque() {
        ArrayDeque<E> expected = new ArrayDeque<E>(this.list);
        FilterIterator filterIterator = new FilterIterator(this.list.iterator());
        Deque actual = (Deque)filterIterator.toCollection(ArrayDeque::new);
        Assertions.assertArrayEquals((Object[])expected.toArray(), (Object[])actual.toArray());
    }

    @Test
    public void testToList() {
        ArrayList<E> expected = new ArrayList<E>(this.list);
        FilterIterator filterIterator = new FilterIterator(this.list.iterator());
        List actual = filterIterator.toList();
        Assertions.assertEquals(expected, (Object)actual);
    }

    @Test
    public void testToSet() {
        HashSet<E> expected = new HashSet<E>(this.list);
        FilterIterator filterIterator = new FilterIterator(this.list.iterator());
        Set actual = filterIterator.toSet();
        Assertions.assertEquals(expected, (Object)actual);
    }

    private void verifyElementsInPredicate(String[] elements) {
        Predicate pred = x -> {
            for (String element : elements) {
                if (!element.equals(x)) continue;
                return true;
            }
            return false;
        };
        this.initIterator();
        this.iterator.setPredicate(pred);
        for (int i = 0; i < elements.length; ++i) {
            String s = (String)this.iterator.next();
            Assertions.assertEquals((Object)elements[i], (Object)s);
            Assertions.assertTrue((boolean)(i == elements.length - 1 ? !this.iterator.hasNext() : this.iterator.hasNext()));
        }
        this.verifyNoMoreElements();
        this.initIterator();
        this.iterator.setPredicate(pred);
        if (this.iterator.hasNext()) {
            Object last = this.iterator.next();
            this.iterator.remove();
            Assertions.assertFalse((boolean)this.list.contains(last), (String)"Base of FilterIterator still contains removed element.");
        }
    }

    private void verifyNoMoreElements() {
        Assertions.assertFalse((boolean)this.iterator.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> this.iterator.next());
    }
}

