/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;

class HelpFormatterTest {
    private static final String EOL = System.lineSeparator();

    HelpFormatterTest() {
    }

    static Stream<Arguments> deprecatedOptionsProvider() {
        ArrayList<Arguments> lst = new ArrayList<Arguments>();
        Option option = Option.builder((String)"a").longOpt("aaa").desc("dddd dddd dddd").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("now").setDescription("Why why why").get()).get();
        HelpFormatter hf = HelpFormatter.builder().get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "[Deprecated] dddd dddd dddd"}));
        hf = HelpFormatter.builder().setShowDeprecated(false).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "dddd dddd dddd"}));
        hf = HelpFormatter.builder().setShowDeprecated(true).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "[Deprecated] dddd dddd dddd"}));
        hf = HelpFormatter.builder().setShowDeprecated(o -> String.format("%s [%s]", HelpFormatter.getDescription((Option)o), o.getDeprecated())).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "dddd dddd dddd [Deprecated for removal since now: Why why why]"}));
        option = Option.builder((String)"a").longOpt("aaa").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("now").setDescription("Why why why").get()).get();
        hf = HelpFormatter.builder().get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "[Deprecated]"}));
        hf = HelpFormatter.builder().setShowDeprecated(false).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, ""}));
        hf = HelpFormatter.builder().setShowDeprecated(true).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "[Deprecated]"}));
        hf = HelpFormatter.builder().setShowDeprecated(o -> String.format("%s [%s]", HelpFormatter.getDescription((Option)o), o.getDeprecated())).get();
        lst.add(Arguments.of((Object[])new Object[]{hf, option, "[Deprecated for removal since now: Why why why]"}));
        return lst.stream();
    }

    @Test
    void testAccessors() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setArgName("argname");
        Assertions.assertEquals((Object)"argname", (Object)formatter.getArgName(), (String)"arg name");
        formatter.setDescPadding(3);
        Assertions.assertEquals((int)3, (int)formatter.getDescPadding(), (String)"desc padding");
        formatter.setLeftPadding(7);
        Assertions.assertEquals((int)7, (int)formatter.getLeftPadding(), (String)"left padding");
        formatter.setLongOptPrefix("~~");
        Assertions.assertEquals((Object)"~~", (Object)formatter.getLongOptPrefix(), (String)"long opt prefix");
        formatter.setNewLine("\n");
        Assertions.assertEquals((Object)"\n", (Object)formatter.getNewLine(), (String)"new line");
        formatter.setOptPrefix("~");
        Assertions.assertEquals((Object)"~", (Object)formatter.getOptPrefix(), (String)"opt prefix");
        formatter.setSyntaxPrefix("-> ");
        Assertions.assertEquals((Object)"-> ", (Object)formatter.getSyntaxPrefix(), (String)"syntax prefix");
        formatter.setWidth(80);
        Assertions.assertEquals((int)80, (int)formatter.getWidth(), (String)"width");
    }

    @Test
    void testAutomaticUsage() {
        HelpFormatter hf = new HelpFormatter();
        String expected = "usage: app [-a]";
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        Assertions.assertEquals((Object)expected, (Object)out.toString().trim(), (String)"simple auto usage");
        out.reset();
        expected = "usage: app [-a] [-b]";
        options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa").addOption("b", false, "bbb");
        hf.printUsage(pw, 60, "app", options);
        pw.flush();
        Assertions.assertEquals((Object)expected, (Object)out.toString().trim(), (String)"simple auto usage");
        out.reset();
    }

    @Test
    void testDefaultArgName() {
        Option option = Option.builder((String)"f").hasArg().required(true).get();
        Options options = new Options();
        options.addOption(option);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.setArgName("argument");
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assertions.assertEquals((Object)("usage: app -f <argument>" + EOL), (Object)out.toString());
    }

    @ParameterizedTest
    @ValueSource(ints={-100, -1, 0})
    void testDeprecatedFindWrapPosZeroWidth(int width) {
        int pos = new HelpFormatter().findWrapPos("Hello World", width, 0);
        Assertions.assertEquals((int)width, (int)pos);
    }

    @ParameterizedTest
    @ValueSource(ints={-100, -1, 0})
    void testDeprecatedPrintOptionsZeroWidth(int width) {
        Options options = new Options();
        options.addOption("h", "help", false, "Show help");
        StringWriter out = new StringWriter();
        PrintWriter pw = new PrintWriter(out);
        new HelpFormatter().printOptions(pw, width, options, 1, 3);
        String result = out.toString();
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testFindWrapPos() {
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        Assertions.assertEquals((int)7, (int)hf.findWrapPos(text, 8, 0), (String)"wrap position");
        Assertions.assertEquals((int)-1, (int)hf.findWrapPos(text, 8, 8), (String)"wrap position 2");
        text = "aaaa aa";
        Assertions.assertEquals((int)3, (int)hf.findWrapPos(text, 3, 0), (String)"wrap position 3");
        text = "aaaaaa aaaaaa";
        Assertions.assertEquals((int)6, (int)hf.findWrapPos(text, 6, 0), (String)"wrap position 4");
        Assertions.assertEquals((int)-1, (int)hf.findWrapPos(text, 6, 7), (String)"wrap position 4");
        text = "aaaaaa\n aaaaaa";
        Assertions.assertEquals((int)7, (int)hf.findWrapPos(text, 6, 0), (String)"wrap position 5");
        text = "aaaaaa\t aaaaaa";
        Assertions.assertEquals((int)7, (int)hf.findWrapPos(text, 6, 0), (String)"wrap position 6");
    }

    @Test
    void testHeaderStartingWithLineSeparator0() {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        String header = EOL + "Header";
        String footer = "Footer";
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", header, options, 2, 2, "Footer", true);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + EOL + "Header" + EOL + EOL + "Footer" + EOL), (Object)out.toString());
    }

    @Test
    void testHeaderStartingWithLineSeparator1() {
        Options options = new Options();
        String header = EOL + "Header";
        String footer = "Footer";
        HelpFormatter.Builder builder = HelpFormatter.builder();
        StringWriter out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp(new PrintWriter(out), 80, "foobar", header, options, 2, 2, "Footer", true);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + "" + EOL + "Header" + EOL + "" + EOL + "Footer" + EOL), (Object)out.toString());
        out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp("foobar", header, options, "Footer");
        Assertions.assertEquals((Object)("usage: foobar" + EOL + EOL + "Header" + EOL + EOL + "Footer" + EOL), (Object)out.toString());
        out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp(80, "foobar", header, options, "Footer");
        Assertions.assertEquals((Object)("usage: foobar" + EOL + EOL + "Header" + EOL + EOL + "Footer" + EOL), (Object)out.toString());
        out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp("foobar", header, options, "Footer", false);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + EOL + "Header" + EOL + EOL + "Footer" + EOL), (Object)out.toString());
        out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp("foobar", header, options, "Footer", true);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + EOL + "Header" + EOL + EOL + "Footer" + EOL), (Object)out.toString());
        out = new StringWriter();
        builder.setPrintWriter(new PrintWriter(out)).get().printHelp("foobar", options, false);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + "" + EOL), (Object)out.toString());
    }

    @Test
    void testHelpWithLongOptSeparator() {
        Options options = new Options();
        options.addOption("f", true, "the file");
        options.addOption(Option.builder((String)"s").longOpt("size").desc("the size").hasArg().argName("SIZE").get());
        options.addOption(Option.builder().longOpt("age").desc("the age").hasArg().get());
        HelpFormatter formatter = new HelpFormatter();
        Assertions.assertEquals((Object)" ", (Object)formatter.getLongOptSeparator());
        formatter.setLongOptSeparator("=");
        Assertions.assertEquals((Object)"=", (Object)formatter.getLongOptSeparator());
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "create", "header", options, 2, 2, "footer");
        Assertions.assertEquals((Object)("usage: create" + EOL + "header" + EOL + "     --age=<arg>    the age" + EOL + "  -f <arg>          the file" + EOL + "  -s,--size=<SIZE>  the size" + EOL + "footer" + EOL), (Object)out.toString());
    }

    @Test
    void testIndentedHeaderAndFooter() {
        Options options = new Options();
        HelpFormatter formatter = new HelpFormatter();
        String header = "  Header1\n  Header2";
        String footer = "  Footer1\n  Footer2";
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", "  Header1\n  Header2", options, 2, 2, "  Footer1\n  Footer2", true);
        Assertions.assertEquals((Object)("usage: foobar" + EOL + "  Header1" + EOL + "  Header2" + EOL + "" + EOL + "  Footer1" + EOL + "  Footer2" + EOL), (Object)out.toString());
    }

    @Test
    void testOptionWithoutShortFormat() {
        Options options = new Options();
        options.addOption(new Option("a", "aaa", false, "aaaaaaa"));
        options.addOption(new Option(null, "bbb", false, "bbbbbbb"));
        options.addOption(new Option("c", null, false, "ccccccc"));
        HelpFormatter formatter = new HelpFormatter();
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "foobar", "", options, 2, 2, "", true);
        Assertions.assertEquals((Object)("usage: foobar [-a] [--bbb] [-c]" + EOL + "  -a,--aaa  aaaaaaa" + EOL + "     --bbb  bbbbbbb" + EOL + "  -c        ccccccc" + EOL), (Object)out.toString());
    }

    @Test
    void testOptionWithoutShortFormat2() {
        Option help = new Option("h", "help", false, "print this message");
        Option version = new Option("v", "version", false, "print version information");
        Option newRun = new Option("n", "new", false, "Create NLT cache entries only for new items");
        Option trackerRun = new Option("t", "tracker", false, "Create NLT cache entries only for tracker items");
        Option timeLimit = Option.builder((String)"l").longOpt("limit").hasArg().valueSeparator().desc("Set time limit for execution, in mintues").get();
        Option age = Option.builder((String)"a").longOpt("age").hasArg().valueSeparator().desc("Age (in days) of cache item before being recomputed").get();
        Option server = Option.builder((String)"s").longOpt("server").hasArg().valueSeparator().desc("The NLT server address").get();
        Option numResults = Option.builder((String)"r").longOpt("results").hasArg().valueSeparator().desc("Number of results per item").get();
        Option configFile = Option.builder().longOpt("config").hasArg().valueSeparator().desc("Use the specified configuration file").get();
        Options mOptions = new Options();
        mOptions.addOption(help);
        mOptions.addOption(version);
        mOptions.addOption(newRun);
        mOptions.addOption(trackerRun);
        mOptions.addOption(timeLimit);
        mOptions.addOption(age);
        mOptions.addOption(server);
        mOptions.addOption(numResults);
        mOptions.addOption(configFile);
        HelpFormatter formatter = new HelpFormatter();
        String eol = System.lineSeparator();
        StringWriter out = new StringWriter();
        formatter.printHelp(new PrintWriter(out), 80, "commandline", "header", mOptions, 2, 2, "footer", true);
        Assertions.assertEquals((Object)("usage: commandline [-a <arg>] [--config <arg>] [-h] [-l <arg>] [-n] [-r <arg>]" + eol + "       [-s <arg>] [-t] [-v]" + eol + "header" + eol + "  -a,--age <arg>      Age (in days) of cache item before being recomputed" + eol + "     --config <arg>   Use the specified configuration file" + eol + "  -h,--help           print this message" + eol + "  -l,--limit <arg>    Set time limit for execution, in mintues" + eol + "  -n,--new            Create NLT cache entries only for new items" + eol + "  -r,--results <arg>  Number of results per item" + eol + "  -s,--server <arg>   The NLT server address" + eol + "  -t,--tracker        Create NLT cache entries only for tracker items" + eol + "  -v,--version        print version information" + eol + "footer" + eol), (Object)out.toString());
    }

    @ParameterizedTest
    @MethodSource(value={"deprecatedOptionsProvider"})
    void testPrintDeprecatedOptions(HelpFormatter hf, Option option, String expectedTxt) {
        StringBuffer sb = new StringBuffer();
        boolean leftPad = true;
        int descPad = 3;
        String lpad = hf.createPadding(1);
        String dpad = hf.createPadding(3);
        StringBuilder expected = new StringBuilder().append(lpad).append("-a,--aaa");
        Options options = new Options().addOption(option);
        if (expectedTxt.length() > 0) {
            expected.append(dpad).append(expectedTxt);
        }
        hf.renderOptions(sb, 160, options, 1, 3);
        Assertions.assertEquals((Object)expected.toString(), (Object)sb.toString());
    }

    @Test
    void testPrintHelpNewlineFooter() {
        HelpFormatter formatter = new HelpFormatter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options();
        options.addOption("a", "b");
        formatter.printHelp(pw, 80, "test" + EOL, "header" + EOL, options, 0, 0, EOL);
        String expected = "usage: test" + EOL + "header" + EOL + "-ab" + EOL + EOL;
        pw.flush();
        Assertions.assertEquals((Object)expected, (Object)out.toString(), (String)"footer newline");
    }

    @Test
    void testPrintHelpNewlineHeader() {
        HelpFormatter formatter = new HelpFormatter();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(out);
        Options options = new Options();
        options.addOption("a", "b");
        formatter.printHelp(pw, 80, "test" + EOL, EOL, options, 0, 0, "footer" + EOL);
        String expected = "usage: test" + EOL + EOL + "-ab" + EOL + "footer" + EOL;
        pw.flush();
        Assertions.assertEquals((Object)expected, (Object)out.toString(), (String)"header newline");
    }

    @Test
    void testPrintHelpWithEmptySyntax() {
        HelpFormatter formatter = new HelpFormatter();
        Assertions.assertThrows(IllegalArgumentException.class, () -> formatter.printHelp(null, new Options()), (String)"null command line syntax should be rejected");
        Assertions.assertThrows(IllegalArgumentException.class, () -> formatter.printHelp(null, new Options(), true), (String)"null command line syntax should be rejected");
        Assertions.assertThrows(IllegalArgumentException.class, () -> formatter.printHelp(null, new Options(), false), (String)"null command line syntax should be rejected");
        Assertions.assertThrows(IllegalArgumentException.class, () -> formatter.printHelp("", new Options(), true), (String)"null command line syntax should be rejected");
        Assertions.assertThrows(IllegalArgumentException.class, () -> formatter.printHelp("", new Options(), false), (String)"null command line syntax should be rejected");
    }

    @Test
    void testPrintHelpWithSince() {
        Object[] expected = new String[]{"usage: Command syntax", "Header", "Options            Since   Description", "  -n,--no-since    -          Description for n", "  -W,--with-since  1.19.0     Descripton for W", "footer"};
        Options options = new Options().addOption(Option.builder((String)"W").longOpt("with-since").since("1.19.0").desc("Descripton for W").get()).addOption(Option.builder((String)"n").longOpt("no-since").desc("Description for n").get());
        HelpFormatter formatter = HelpFormatter.builder().setShowSince(true).get();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(baos));){
            formatter.printHelp(pw, 80, "Command syntax", "Header", options, 2, 5, "footer", false);
        }
        Assertions.assertArrayEquals((Object[])expected, (Object[])baos.toString().split(System.lineSeparator()));
    }

    @Test
    void testPrintOptionGroupUsage() {
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(Option.builder((String)"a").get());
        optionGroup.addOption(Option.builder((String)"b").get());
        optionGroup.addOption(Option.builder((String)"c").get());
        Options options = new Options();
        options.addOptionGroup(optionGroup);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assertions.assertEquals((Object)("usage: app [-a | -b | -c]" + EOL), (Object)out.toString());
    }

    @Test
    void testPrintOptions() {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        boolean leftPad = true;
        int descPad = 3;
        String lpad = hf.createPadding(1);
        String dpad = hf.createPadding(3);
        Options options = new Options().addOption("a", false, "aaaa aaaa aaaa aaaa aaaa");
        String expected = lpad + "-a" + dpad + "aaaa aaaa aaaa aaaa aaaa";
        hf.renderOptions(sb, 60, options, 1, 3);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"simple non-wrapped option");
        int nextLineTabStop = 4 + "-a".length();
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa" + EOL + hf.createPadding(nextLineTabStop) + "aaaa aaaa";
        sb.setLength(0);
        hf.renderOptions(sb, nextLineTabStop + 17, options, 1, 3);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"simple wrapped option");
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 60, options, 1, 3);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"long non-wrapped option");
        nextLineTabStop = 4 + "-a,--aaa".length();
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + EOL + hf.createPadding(nextLineTabStop) + "dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"long wrapped option");
        options = new Options().addOption("a", "aaa", false, "dddd dddd dddd dddd").addOption("b", false, "feeee eeee eeee eeee");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + EOL + hf.createPadding(nextLineTabStop) + "dddd dddd" + EOL + lpad + "-b      " + dpad + "feeee eeee" + EOL + hf.createPadding(nextLineTabStop) + "eeee eeee";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"multiple wrapped options");
    }

    @Test
    void testPrintOptionWithEmptyArgNameUsage() {
        Option option = new Option("f", true, null);
        option.setArgName("");
        option.setRequired(true);
        Options options = new Options();
        options.addOption(option);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assertions.assertEquals((Object)("usage: app -f" + EOL), (Object)out.toString());
    }

    @Test
    void testPrintRequiredOptionGroupUsage() {
        OptionGroup optionGroup = new OptionGroup();
        optionGroup.addOption(Option.builder((String)"a").get());
        optionGroup.addOption(Option.builder((String)"b").get());
        optionGroup.addOption(Option.builder((String)"c").get());
        optionGroup.setRequired(true);
        Options options = new Options();
        options.addOptionGroup(optionGroup);
        StringWriter out = new StringWriter();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(new PrintWriter(out), 80, "app", options);
        Assertions.assertEquals((Object)("usage: app -a | -b | -c" + EOL), (Object)out.toString());
    }

    @Test
    void testPrintSortedUsage() {
        Options opts = new Options();
        opts.addOption(new Option("a", "first"));
        opts.addOption(new Option("b", "second"));
        opts.addOption(new Option("c", "third"));
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator((opt1, opt2) -> opt2.getKey().compareToIgnoreCase(opt1.getKey()));
        StringWriter out = new StringWriter();
        helpFormatter.printUsage(new PrintWriter(out), 80, "app", opts);
        Assertions.assertEquals((Object)("usage: app [-c] [-b] [-a]" + EOL), (Object)out.toString());
    }

    @Test
    void testPrintSortedUsageWithNullComparator() {
        Options opts = new Options();
        opts.addOption(new Option("c", "first"));
        opts.addOption(new Option("b", "second"));
        opts.addOption(new Option("a", "third"));
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setOptionComparator(null);
        StringWriter out = new StringWriter();
        helpFormatter.printUsage(new PrintWriter(out), 80, "app", opts);
        Assertions.assertEquals((Object)("usage: app [-c] [-b] [-a]" + EOL), (Object)out.toString());
    }

    @Test
    void testPrintUsage() {
        Option optionA = new Option("a", "first");
        Option optionB = new Option("b", "second");
        Option optionC = new Option("c", "third");
        Options opts = new Options();
        opts.addOption(optionA);
        opts.addOption(optionB);
        opts.addOption(optionC);
        HelpFormatter helpFormatter = new HelpFormatter();
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (PrintWriter printWriter = new PrintWriter(bytesOut);){
            helpFormatter.printUsage(printWriter, 80, "app", opts);
        }
        Assertions.assertEquals((Object)("usage: app [-a] [-b] [-c]" + EOL), (Object)bytesOut.toString());
    }

    @Test
    void testRenderSince() throws IOException {
        Object[] expected = new String[]{"Options            Since   Description", "  -n,--no-since    -          Description for n", "  -W,--with-since  1.19.0     Descripton for W"};
        Options options = new Options().addOption(Option.builder((String)"W").longOpt("with-since").since("1.19.0").desc("Descripton for W").get()).addOption(Option.builder((String)"n").longOpt("no-since").desc("Description for n").get());
        HelpFormatter formatter = HelpFormatter.builder().setShowSince(true).get();
        StringBuffer sb = new StringBuffer();
        formatter.renderOptions(sb, 50, options, 2, 5);
        Assertions.assertArrayEquals((Object[])expected, (Object[])sb.toString().split(System.lineSeparator()));
        HelpFormatter spy = (HelpFormatter)Mockito.spy((Object)formatter);
        Mockito.when((Object)((StringBuffer)spy.appendOptions((Appendable)sb, 50, options, 2, 5))).thenThrow(IOException.class);
        Assertions.assertThrows(UncheckedIOException.class, () -> spy.renderOptions(sb, 50, options, 2, 5));
    }

    @Test
    void testRenderWrappedTextMultiLine() {
        int width = 16;
        boolean padding = false;
        String expected = "aaaa aaaa aaaa" + EOL + "aaaaaa" + EOL + "aaaaa";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 16, 0, expected);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"multi line text");
    }

    @Test
    void testRenderWrappedTextMultiLinePadded() {
        int width = 16;
        int padding = 4;
        String text = "aaaa aaaa aaaa" + EOL + "aaaaaa" + EOL + "aaaaa";
        String expected = "aaaa aaaa aaaa" + EOL + "    aaaaaa" + EOL + "    aaaaa";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 16, 4, text);
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"multi-line padded text");
    }

    @Test
    void testRenderWrappedTextSingleLine() throws IOException {
        int width = 12;
        boolean padding = false;
        String text = "This is a test.";
        String expected = "This is a" + EOL + "test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 12, 0, "This is a test.");
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"single line text");
        HelpFormatter spy = (HelpFormatter)Mockito.spy((Object)new HelpFormatter());
        Mockito.when((Object)((StringBuffer)spy.appendWrappedText((Appendable)sb, 12, 0, "This is a test."))).thenThrow(IOException.class);
        Assertions.assertThrows(UncheckedIOException.class, () -> spy.renderWrappedText(sb, 12, 0, "This is a test."));
    }

    @Test
    void testRenderWrappedTextSingleLinePadded() {
        int width = 12;
        int padding = 4;
        String text = "This is a test.";
        String expected = "This is a" + EOL + "    test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 12, 4, "This is a test.");
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"single line padded text");
    }

    @Test
    void testRenderWrappedTextSingleLinePadded2() {
        int width = 53;
        int padding = 24;
        String text = "  -p,--period <PERIOD>  PERIOD is time duration of form DATE[-DATE] where DATE has form YYYY[MM[DD]]";
        String expected = "  -p,--period <PERIOD>  PERIOD is time duration of" + EOL + "                        form DATE[-DATE] where DATE" + EOL + "                        has form YYYY[MM[DD]]";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 53, 24, "  -p,--period <PERIOD>  PERIOD is time duration of form DATE[-DATE] where DATE has form YYYY[MM[DD]]");
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"single line padded text 2");
    }

    @Test
    void testRenderWrappedTextWordCut() {
        int width = 7;
        boolean padding = false;
        String text = "Thisisatest.";
        String expected = "Thisisa" + EOL + "test.";
        StringBuffer sb = new StringBuffer();
        new HelpFormatter().renderWrappedText(sb, 7, 0, "Thisisatest.");
        Assertions.assertEquals((Object)expected, (Object)sb.toString(), (String)"cut and wrap");
    }

    @Test
    void testRtrim() {
        HelpFormatter formatter = new HelpFormatter();
        Assertions.assertNull((Object)formatter.rtrim(null));
        Assertions.assertEquals((Object)"", (Object)formatter.rtrim(""));
        Assertions.assertEquals((Object)"  foo", (Object)formatter.rtrim("  foo  "));
    }

    @Test
    void testUsageWithLongOptSeparator() {
        Options options = new Options();
        options.addOption("f", true, "the file");
        options.addOption(Option.builder((String)"s").longOpt("size").desc("the size").hasArg().argName("SIZE").get());
        options.addOption(Option.builder().longOpt("age").desc("the age").hasArg().get());
        HelpFormatter formatter = new HelpFormatter();
        formatter.setLongOptSeparator("=");
        StringWriter out = new StringWriter();
        formatter.printUsage(new PrintWriter(out), 80, "create", options);
        Assertions.assertEquals((Object)"usage: create [--age=<arg>] [-f <arg>] [-s <SIZE>]", (Object)out.toString().trim());
    }
}

