/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli;

import java.util.HashSet;
import java.util.stream.Stream;
import org.apache.commons.cli.AbstractParserTestCase;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.ArgumentsSource;

class DefaultParserTest
extends AbstractParserTestCase {
    DefaultParserTest() {
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.parser = new DefaultParser();
    }

    @Test
    void testBuilder() {
        DefaultParser.Builder builder = DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).setAllowPartialMatching(false).setDeprecatedHandler(null);
        this.parser = builder.build();
        Assertions.assertEquals(DefaultParser.class, (Object)this.parser.getClass());
        this.parser = builder.get();
        Assertions.assertEquals(DefaultParser.class, (Object)this.parser.getClass());
    }

    @Test
    void testDeprecated() throws ParseException {
        HashSet handler = new HashSet();
        this.parser = DefaultParser.builder().setDeprecatedHandler(handler::add).build();
        Option opt1 = Option.builder().option("d1").deprecated().get();
        Option opt2 = Option.builder().option("d2").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("1.0").setDescription("Do this instead.").get()).get();
        Option opt3 = Option.builder().option("a").get();
        CommandLine cl = this.parser.parse(new Options().addOption(opt1).addOption(opt2).addOption(opt3), new String[]{"-d1", "-d2", "-a"});
        Assertions.assertTrue((boolean)cl.hasOption(opt1.getOpt()));
        Assertions.assertTrue((boolean)cl.hasOption(opt2.getOpt()));
        Assertions.assertTrue((boolean)cl.hasOption(opt3.getOpt()));
        Assertions.assertTrue((boolean)handler.contains(opt1));
        Assertions.assertTrue((boolean)handler.contains(opt2));
        Assertions.assertFalse((boolean)handler.contains(opt3));
    }

    @Test
    void testLegacyStopAtNonOption() throws ParseException {
        Option a = Option.builder().option("a").longOpt("first-letter").get();
        Option b = Option.builder().option("b").longOpt("second-letter").get();
        Option c = Option.builder().option("c").longOpt("third-letter").get();
        Options options = new Options();
        options.addOption(a);
        options.addOption(b);
        options.addOption(c);
        String[] args = new String[]{"-a", "-b", "-c", "-d", "arg1", "arg2"};
        DefaultParser parser = new DefaultParser();
        CommandLine commandLine = parser.parse(options, args, null, true);
        Assertions.assertEquals((int)3, (int)commandLine.getOptions().length);
        Assertions.assertEquals((int)3, (int)commandLine.getArgs().length);
        Assertions.assertTrue((boolean)commandLine.getArgList().contains("-d"));
        Assertions.assertTrue((boolean)commandLine.getArgList().contains("arg1"));
        Assertions.assertTrue((boolean)commandLine.getArgList().contains("arg2"));
        UnrecognizedOptionException e = (UnrecognizedOptionException)Assertions.assertThrows(UnrecognizedOptionException.class, () -> parser.parse(options, args, null, false));
        Assertions.assertTrue((boolean)e.getMessage().contains("-d"));
    }

    @Override
    @Test
    @Disabled(value="Test case handled in the parameterized tests as \"DEFAULT behavior\"")
    void testLongOptionWithEqualsQuoteHandling() throws Exception {
    }

    @ParameterizedTest(name="{index}. {0}")
    @ArgumentsSource(value=ExternalArgumentsProvider.class)
    void testParameterized(String testName, CommandLineParser parser, String[] args, String expected, String option, String message) throws Exception {
        CommandLine cl = parser.parse(this.options, args);
        Assertions.assertEquals((Object)expected, (Object)cl.getOptionValue(option), (String)message);
    }

    @Test
    void testParseIgnoreHappyPath() throws ParseException {
        Option a = Option.builder().option("a").longOpt("first-letter").get();
        Option b = Option.builder().option("b").longOpt("second-letter").get();
        Option c = Option.builder().option("c").longOpt("third-letter").get();
        Option d = Option.builder().option("d").longOpt("fourth-letter").get();
        Options baseOptions = new Options();
        baseOptions.addOption(a);
        baseOptions.addOption(b);
        Options specificOptions = new Options();
        specificOptions.addOption(a);
        specificOptions.addOption(b);
        specificOptions.addOption(c);
        specificOptions.addOption(d);
        String[] args = new String[]{"-a", "-b", "-c", "-d", "arg1", "arg2"};
        DefaultParser parser = new DefaultParser();
        CommandLine baseCommandLine = parser.parse(baseOptions, null, DefaultParser.NonOptionAction.IGNORE, args);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getOptions().length);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getArgs().length);
        Assertions.assertTrue((boolean)baseCommandLine.hasOption("a"));
        Assertions.assertTrue((boolean)baseCommandLine.hasOption("b"));
        Assertions.assertFalse((boolean)baseCommandLine.hasOption("c"));
        Assertions.assertFalse((boolean)baseCommandLine.hasOption("d"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-a"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-b"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-c"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-d"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("arg1"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("arg2"));
        CommandLine specificCommandLine = parser.parse(specificOptions, null, DefaultParser.NonOptionAction.THROW, args);
        Assertions.assertEquals((int)4, (int)specificCommandLine.getOptions().length);
        Assertions.assertEquals((int)2, (int)specificCommandLine.getArgs().length);
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("a"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("b"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("c"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("d"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-a"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-b"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-c"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-d"));
        Assertions.assertTrue((boolean)specificCommandLine.getArgList().contains("arg1"));
        Assertions.assertTrue((boolean)specificCommandLine.getArgList().contains("arg2"));
    }

    @Test
    void testParseIgnoreNonHappyPath() throws ParseException {
        Option a = Option.builder().option("a").longOpt("first-letter").get();
        Option b = Option.builder().option("b").longOpt("second-letter").get();
        Option c = Option.builder().option("c").longOpt("third-letter").get();
        Options baseOptions = new Options();
        baseOptions.addOption(a);
        baseOptions.addOption(b);
        Options specificOptions = new Options();
        specificOptions.addOption(a);
        specificOptions.addOption(b);
        specificOptions.addOption(c);
        String[] args = new String[]{"-a", "-b", "-c", "-d", "arg1", "arg2"};
        DefaultParser parser = new DefaultParser();
        CommandLine baseCommandLine = parser.parse(baseOptions, null, DefaultParser.NonOptionAction.IGNORE, args);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getOptions().length);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getArgs().length);
        UnrecognizedOptionException e = (UnrecognizedOptionException)Assertions.assertThrows(UnrecognizedOptionException.class, () -> parser.parse(specificOptions, null, DefaultParser.NonOptionAction.THROW, args));
        Assertions.assertTrue((boolean)e.getMessage().contains("-d"));
    }

    @Test
    void testParseNullOption() throws ParseException {
        Assertions.assertThrows(NullPointerException.class, () -> new DefaultParser().parse(null, null, DefaultParser.NonOptionAction.IGNORE, new String[]{"-a"}));
    }

    @Test
    void testParseSkipHappyPath() throws ParseException {
        Option a = Option.builder().option("a").longOpt("first-letter").get();
        Option b = Option.builder().option("b").longOpt("second-letter").get();
        Option c = Option.builder().option("c").longOpt("third-letter").get();
        Option d = Option.builder().option("d").longOpt("fourth-letter").get();
        Options baseOptions = new Options();
        baseOptions.addOption(a);
        baseOptions.addOption(b);
        Options specificOptions = new Options();
        specificOptions.addOption(a);
        specificOptions.addOption(b);
        specificOptions.addOption(c);
        specificOptions.addOption(d);
        String[] args = new String[]{"-a", "-b", "-c", "-d", "arg1", "arg2"};
        DefaultParser parser = new DefaultParser();
        CommandLine baseCommandLine = parser.parse(baseOptions, null, DefaultParser.NonOptionAction.SKIP, args);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getOptions().length);
        Assertions.assertEquals((int)4, (int)baseCommandLine.getArgs().length);
        Assertions.assertTrue((boolean)baseCommandLine.hasOption("a"));
        Assertions.assertTrue((boolean)baseCommandLine.hasOption("b"));
        Assertions.assertFalse((boolean)baseCommandLine.hasOption("c"));
        Assertions.assertFalse((boolean)baseCommandLine.hasOption("d"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-a"));
        Assertions.assertFalse((boolean)baseCommandLine.getArgList().contains("-b"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("-c"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("-d"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("arg1"));
        Assertions.assertTrue((boolean)baseCommandLine.getArgList().contains("arg2"));
        CommandLine specificCommandLine = parser.parse(specificOptions, null, DefaultParser.NonOptionAction.THROW, args);
        Assertions.assertEquals((int)4, (int)specificCommandLine.getOptions().length);
        Assertions.assertEquals((int)2, (int)specificCommandLine.getArgs().length);
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("a"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("b"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("c"));
        Assertions.assertTrue((boolean)specificCommandLine.hasOption("d"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-a"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-b"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-c"));
        Assertions.assertFalse((boolean)specificCommandLine.getArgList().contains("-d"));
        Assertions.assertTrue((boolean)specificCommandLine.getArgList().contains("arg1"));
        Assertions.assertTrue((boolean)specificCommandLine.getArgList().contains("arg2"));
    }

    @Test
    void testParseSkipNonHappyPath() throws ParseException {
        Option a = Option.builder().option("a").longOpt("first-letter").get();
        Option b = Option.builder().option("b").longOpt("second-letter").get();
        Option c = Option.builder().option("c").longOpt("third-letter").get();
        Options baseOptions = new Options();
        baseOptions.addOption(a);
        baseOptions.addOption(b);
        Options specificOptions = new Options();
        specificOptions.addOption(a);
        specificOptions.addOption(b);
        specificOptions.addOption(c);
        String[] args = new String[]{"-a", "-b", "-c", "-d", "arg1", "arg2"};
        DefaultParser parser = new DefaultParser();
        CommandLine baseCommandLine = parser.parse(baseOptions, null, DefaultParser.NonOptionAction.SKIP, args);
        Assertions.assertEquals((int)2, (int)baseCommandLine.getOptions().length);
        Assertions.assertEquals((int)4, (int)baseCommandLine.getArgs().length);
        UnrecognizedOptionException e = (UnrecognizedOptionException)Assertions.assertThrows(UnrecognizedOptionException.class, () -> parser.parse(specificOptions, null, DefaultParser.NonOptionAction.THROW, args));
        Assertions.assertTrue((boolean)e.getMessage().contains("-d"));
    }

    @Override
    @Test
    @Disabled(value="Test case handled in the parameterized tests as \"DEFAULT behavior\"")
    void testShortOptionConcatenatedQuoteHandling() throws Exception {
    }

    static class ExternalArgumentsProvider
    implements ArgumentsProvider {
        ExternalArgumentsProvider() {
        }

        public Stream<? extends Arguments> provideArguments(ExtensionContext context) {
            return Stream.of(Arguments.of((Object[])new Object[]{"Long option quote handling DEFAULT behavior", DefaultParser.builder().get(), new String[]{"--bfile", "\"quoted string\""}, "quoted string", "b", "Confirm --bfile=\"arg\" strips quotes"}), Arguments.of((Object[])new Object[]{"Long option with equals quote handling DEFAULT behavior", DefaultParser.builder().get(), new String[]{"--bfile=\"quoted string\""}, "\"quoted string\"", "b", "Confirm --bfile=\"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Short option quote handling DEFAULT behavior", DefaultParser.builder().get(), new String[]{"-b", "\"quoted string\""}, "quoted string", "b", "Confirm -b\"arg\" strips quotes"}), Arguments.of((Object[])new Object[]{"Short option concatenated quote handling DEFAULT behavior", DefaultParser.builder().get(), new String[]{"-b\"quoted string\""}, "\"quoted string\"", "b", "Confirm -b\"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Long option quote handling WITHOUT strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).get(), new String[]{"--bfile", "\"quoted string\""}, "\"quoted string\"", "b", "Confirm --bfile \"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Long option with equals quote handling WITHOUT strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).get(), new String[]{"--bfile=\"quoted string\""}, "\"quoted string\"", "b", "Confirm --bfile=\"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Short option quote handling WITHOUT strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).get(), new String[]{"-b", "\"quoted string\""}, "\"quoted string\"", "b", "Confirm -b\"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Short option concatenated quote handling WITHOUT strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(false)).get(), new String[]{"-b\"quoted string\""}, "\"quoted string\"", "b", "Confirm -b\"arg\" keeps quotes"}), Arguments.of((Object[])new Object[]{"Long option quote handling WITH strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).get(), new String[]{"--bfile", "\"quoted string\""}, "quoted string", "b", "Confirm --bfile \"arg\" strips quotes"}), Arguments.of((Object[])new Object[]{"Long option With Equals Quote Handling WITH Strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).get(), new String[]{"--bfile=\"quoted string\""}, "quoted string", "b", "Confirm --bfile=\"arg\" strips quotes"}), Arguments.of((Object[])new Object[]{"Short option quote handling WITH strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).get(), new String[]{"-b", "\"quoted string\""}, "quoted string", "b", "Confirm -b \"arg\" strips quotes"}), Arguments.of((Object[])new Object[]{"Short option concatenated quote handling WITH strip", DefaultParser.builder().setStripLeadingAndTrailingQuotes(Boolean.valueOf(true)).get(), new String[]{"-b\"quoted string\""}, "quoted string", "b", "Confirm -b\"arg\" strips quotes"}));
        }
    }
}

