/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.metrics.MetricsConfig;
import org.apache.celeborn.common.metrics.MetricsSystem$;
import org.apache.celeborn.common.metrics.sink.JsonServlet;
import org.apache.celeborn.common.metrics.sink.PrometheusServlet;
import org.apache.celeborn.common.metrics.sink.Sink;
import org.apache.celeborn.common.metrics.source.Source;
import org.apache.celeborn.common.util.Utils$;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u00181\u0001mB\u0001\u0002\u0013\u0001\u0003\u0006\u0004%\t!\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005\u0015\"Aa\u000b\u0001B\u0001B\u0003%q\u000bC\u0003\\\u0001\u0011\u0005A\f\u0003\u0004b\u0001\u0001\u0006IA\u0019\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0011\u0019)\b\u0001)A\u0005O\"I\u0011Q\u0001\u0001C\u0002\u0013%\u0011q\u0001\u0005\t\u0003S\u0001\u0001\u0015!\u0003\u0002\n!I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00020!A\u0011q\b\u0001C\u0002\u0013%\u0011\nC\u0004\u0002B\u0001\u0001\u000b\u0011\u0002&\t\u0011\u0005\r\u0003A1A\u0005\n%Cq!!\u0012\u0001A\u0003%!\nC\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J!I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011\f\u0005\t\u0003K\u0002\u0001\u0015)\u0003\u0002L!I\u0011q\r\u0001A\u0002\u0013%\u0011\u0011\u000e\u0005\n\u0003g\u0002\u0001\u0019!C\u0005\u0003kB\u0001\"!\u001f\u0001A\u0003&\u00111\u000e\u0005\n\u0003w\u0002\u0001\u0019!C\u0001\u0003{B\u0011\"!\"\u0001\u0001\u0004%\t!a\"\t\u0011\u0005-\u0005\u0001)Q\u0005\u0003\u007fBq!!$\u0001\t\u0003\ty\tC\u0004\u0002,\u0002!\t!!,\t\u0013\u0005M\u0006!%A\u0005\u0002\u0005U\u0006bBAf\u0001\u0011\u0005\u0011Q\u001a\u0005\b\u0003\u001f\u0004A\u0011AAg\u0011\u001d\t\t\u000e\u0001C\u0005\u0003'Dq!a6\u0001\t\u0003\tI\u000eC\u0004\u0002r\u0002!\t!a=\t\u000f\u0005]\b\u0001\"\u0001\u0002z\"9\u0011Q \u0001\u0005\n\u00055\u0007bBA\u0000\u0001\u0011%\u0011QZ\u0004\b\u0005\u0003\u0001\u0004\u0012\u0001B\u0002\r\u0019y\u0003\u0007#\u0001\u0003\u0006!11,\nC\u0001\u0005\u000fA\u0011B!\u0003&\u0005\u0004%\tAa\u0003\t\u0011\tmQ\u0005)A\u0005\u0005\u001bA\u0011B!\b&\u0005\u0004%\tAa\u0003\t\u0011\t}Q\u0005)A\u0005\u0005\u001bA\u0001B!\t&A\u0003%!1\u0005\u0005\t\u0005S)\u0003\u0015!\u0003\u0003,!9!\u0011G\u0013\u0005\u0002\tM\u0002b\u0002B\u001fK\u0011\u0005!q\b\u0002\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u000b\u0005E\u0012\u0014aB7fiJL7m\u001d\u0006\u0003gQ\naaY8n[>t'BA\u001b7\u0003!\u0019W\r\\3c_Jt'BA\u001c9\u0003\u0019\t\u0007/Y2iK*\t\u0011(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001y\t\u0003\"!\u0010!\u000e\u0003yR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\u0012a!\u00118z%\u00164\u0007CA\"G\u001b\u0005!%BA#3\u0003!Ig\u000e^3s]\u0006d\u0017BA$E\u0005\u001daunZ4j]\u001e\f\u0001\"\u001b8ti\u0006t7-Z\u000b\u0002\u0015B\u00111J\u0015\b\u0003\u0019B\u0003\"!\u0014 \u000e\u00039S!a\u0014\u001e\u0002\rq\u0012xn\u001c;?\u0013\t\tf(\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA)?\u0003%Ign\u001d;b]\u000e,\u0007%\u0001\u0003d_:4\u0007C\u0001-Z\u001b\u0005\u0011\u0014B\u0001.3\u00051\u0019U\r\\3c_Jt7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0019Ql\u00181\u0011\u0005y\u0003Q\"\u0001\u0019\t\u000b!#\u0001\u0019\u0001&\t\u000bY#\u0001\u0019A,\u0002\u001b5,GO]5dg\u000e{gNZ5h!\tq6-\u0003\u0002ea\tiQ*\u001a;sS\u000e\u001c8i\u001c8gS\u001e\fQa]5oWN,\u0012a\u001a\t\u0004Q6|W\"A5\u000b\u0005)\\\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003Yz\n!bY8mY\u0016\u001cG/[8o\u0013\tq\u0017NA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\bC\u00019t\u001b\u0005\t(B\u0001:1\u0003\u0011\u0019\u0018N\\6\n\u0005Q\f(\u0001B*j].\faa]5oWN\u0004\u0003FA\u0004x!\rA\u0018\u0011A\u0007\u0002s*\u0011!p_\u0001\fC:tw\u000e^1uS>t7O\u0003\u00024y*\u0011QP`\u0001\u0007O>|w\r\\3\u000b\u0003}\f1aY8n\u0013\r\t\u0019!\u001f\u0002\u0012-&\u001c\u0018N\u00197f\r>\u0014H+Z:uS:<\u0017aB:pkJ\u001cWm]\u000b\u0003\u0003\u0013\u0001b!a\u0003\u0002\u001a\u0005uQBAA\u0007\u0015\u0011\ty!!\u0005\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002\u0014\u0005U\u0011\u0001B;uS2T!!a\u0006\u0002\t)\fg/Y\u0005\u0005\u00037\tiA\u0001\u000bD_BLxJ\\,sSR,\u0017I\u001d:bs2K7\u000f\u001e\t\u0005\u0003?\t)#\u0004\u0002\u0002\")\u0019\u00111\u0005\u0019\u0002\rM|WO]2f\u0013\u0011\t9#!\t\u0003\rM{WO]2f\u0003!\u0019x.\u001e:dKN\u0004\u0013\u0001\u0003:fO&\u001cHO]=\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003si!!a\r\u000b\u0007E\n)DC\u0002\u00028y\f\u0001bY8eC\"\fG.Z\u0005\u0005\u0003w\t\u0019D\u0001\bNKR\u0014\u0018n\u0019*fO&\u001cHO]=\u0002\u0013I,w-[:uef\u0004\u0013!\u00069s_6,G\u000f[3vgN+'O\u001e7fiB\u000bG\u000f[\u0001\u0017aJ|W.\u001a;iKV\u001c8+\u001a:wY\u0016$\b+\u0019;iA\u0005y!n]8o'\u0016\u0014h\u000f\\3u!\u0006$\b.\u0001\tkg>t7+\u001a:wY\u0016$\b+\u0019;iA\u0005\t\u0002O]8nKRDW-^:TKJ4H.\u001a;\u0016\u0005\u0005-\u0003#B\u001f\u0002N\u0005E\u0013bAA(}\t1q\n\u001d;j_:\u00042\u0001]A*\u0013\r\t)&\u001d\u0002\u0012!J|W.\u001a;iKV\u001c8+\u001a:wY\u0016$\u0018!\u00069s_6,G\u000f[3vgN+'O\u001e7fi~#S-\u001d\u000b\u0005\u00037\n\t\u0007E\u0002>\u0003;J1!a\u0018?\u0005\u0011)f.\u001b;\t\u0013\u0005\r\u0014#!AA\u0002\u0005-\u0013a\u0001=%c\u0005\u0011\u0002O]8nKRDW-^:TKJ4H.\u001a;!\u0003-Q7o\u001c8TKJ4H.\u001a;\u0016\u0005\u0005-\u0004#B\u001f\u0002N\u00055\u0004c\u00019\u0002p%\u0019\u0011\u0011O9\u0003\u0017)\u001bxN\\*feZdW\r^\u0001\u0010UN|gnU3sm2,Go\u0018\u0013fcR!\u00111LA<\u0011%\t\u0019\u0007FA\u0001\u0002\u0004\tY'\u0001\u0007kg>t7+\u001a:wY\u0016$\b%A\u0004sk:t\u0017N\\4\u0016\u0005\u0005}\u0004cA\u001f\u0002\u0002&\u0019\u00111\u0011 \u0003\u000f\t{w\u000e\\3b]\u0006Y!/\u001e8oS:<w\fJ3r)\u0011\tY&!#\t\u0013\u0005\rt#!AA\u0002\u0005}\u0014\u0001\u0003:v]:Lgn\u001a\u0011\u00023\u001d,GoU3sm2,GoQ8oi\u0016DH\u000fS1oI2,'o]\u000b\u0003\u0003#\u0003R!PAJ\u0003/K1!!&?\u0005\u0015\t%O]1z!\u0011\tI*a*\u000e\u0005\u0005m%\u0002BAO\u0003?\u000bqa]3sm2,GO\u0003\u0003\u0002\"\u0006\r\u0016!\u00026fiRL(bAASq\u00059Qm\u00197jaN,\u0017\u0002BAU\u00037\u0013QcU3sm2,GoQ8oi\u0016DH\u000fS1oI2,'/A\u0003ti\u0006\u0014H\u000f\u0006\u0003\u0002\\\u0005=\u0006\"CAY5A\u0005\t\u0019AA@\u0003U\u0011XmZ5ti\u0016\u00148\u000b^1uS\u000e\u001cv.\u001e:dKN\fqb\u001d;beR$C-\u001a4bk2$H%M\u000b\u0003\u0003oSC!a \u0002:.\u0012\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003%)hn\u00195fG.,GMC\u0002\u0002Fz\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI-a0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u0003ti>\u0004HCAA.\u0003\u0019\u0011X\r]8si\u0006\t\"-^5mIJ+w-[:ueft\u0015-\\3\u0015\u0007)\u000b)\u000eC\u0004\u0002$y\u0001\r!!\b\u0002!\u001d,GoU8ve\u000e,7OQ=OC6,G\u0003BAn\u0003[\u0004b!!8\u0002h\u0006ua\u0002BAp\u0003Gt1!TAq\u0013\u0005y\u0014bAAs}\u00059\u0001/Y2lC\u001e,\u0017\u0002BAu\u0003W\u00141aU3r\u0015\r\t)O\u0010\u0005\u0007\u0003_|\u0002\u0019\u0001&\u0002\u0015M|WO]2f\u001d\u0006lW-\u0001\bsK\u001eL7\u000f^3s'>,(oY3\u0015\t\u0005m\u0013Q\u001f\u0005\b\u0003G\u0001\u0003\u0019AA\u000f\u00031\u0011X-\\8wKN{WO]2f)\u0011\tY&a?\t\u000f\u0005\r\u0012\u00051\u0001\u0002\u001e\u0005y!/Z4jgR,'oU8ve\u000e,7/A\u0007sK\u001eL7\u000f^3s'&t7n]\u0001\u000e\u001b\u0016$(/[2t'f\u001cH/Z7\u0011\u0005y+3CA\u0013=)\t\u0011\u0019!\u0001\u0006T\u0013:[uLU#H\u000bb+\"A!\u0004\u0011\t\t=!qC\u0007\u0003\u0005#QAAa\u0005\u0003\u0016\u0005AQ.\u0019;dQ&twMC\u0002\u0002\u0014yJAA!\u0007\u0003\u0012\t)!+Z4fq\u0006Y1+\u0013(L?J+u)\u0012-!\u00031\u0019v*\u0016*D\u000b~\u0013ViR#Y\u00035\u0019v*\u0016*D\u000b~\u0013ViR#YA\u0005\tR*\u0013(J\u001b\u0006cu\fU(M\u0019~+f*\u0013+\u0011\t\u0005-!QE\u0005\u0005\u0005O\tiA\u0001\u0005US6,WK\\5u\u0003Mi\u0015JT%N\u00032{\u0006k\u0014'M?B+%+S(E!\ri$QF\u0005\u0004\u0005_q$aA%oi\u0006I2\r[3dW6Kg.[7bYB{G\u000e\\5oOB+'/[8e)\u0019\tYF!\u000e\u0003:!9!qG\u0017A\u0002\t\r\u0012\u0001\u00039pY2,f.\u001b;\t\u000f\tmR\u00061\u0001\u0003,\u0005Q\u0001o\u001c7m!\u0016\u0014\u0018n\u001c3\u0002'\r\u0014X-\u0019;f\u001b\u0016$(/[2t'f\u001cH/Z7\u0015\u000bu\u0013\tEa\u0011\t\u000b!s\u0003\u0019\u0001&\t\u000bYs\u0003\u0019A,")
public class MetricsSystem
implements Logging {
    private final String instance;
    private final CelebornConf conf;
    private final MetricsConfig metricsConfig;
    @VisibleForTesting
    private final ArrayBuffer<Sink> sinks;
    private final CopyOnWriteArrayList<Source> sources;
    private final MetricRegistry registry;
    private final String prometheusServletPath;
    private final String jsonServletPath;
    private Option<PrometheusServlet> prometheusServlet;
    private Option<JsonServlet> jsonServlet;
    private boolean running;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public static MetricsSystem createMetricsSystem(String string, CelebornConf celebornConf) {
        return MetricsSystem$.MODULE$.createMetricsSystem(string, celebornConf);
    }

    public static void checkMinimalPollingPeriod(TimeUnit timeUnit, int n) {
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(timeUnit, n);
    }

    public static Regex SOURCE_REGEX() {
        return MetricsSystem$.MODULE$.SOURCE_REGEX();
    }

    public static Regex SINK_REGEX() {
        return MetricsSystem$.MODULE$.SINK_REGEX();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        MetricsSystem metricsSystem = this;
        synchronized (metricsSystem) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String instance() {
        return this.instance;
    }

    public ArrayBuffer<Sink> sinks() {
        return this.sinks;
    }

    private CopyOnWriteArrayList<Source> sources() {
        return this.sources;
    }

    private MetricRegistry registry() {
        return this.registry;
    }

    private String prometheusServletPath() {
        return this.prometheusServletPath;
    }

    private String jsonServletPath() {
        return this.jsonServletPath;
    }

    private Option<PrometheusServlet> prometheusServlet() {
        return this.prometheusServlet;
    }

    private void prometheusServlet_$eq(Option<PrometheusServlet> x$1) {
        this.prometheusServlet = x$1;
    }

    private Option<JsonServlet> jsonServlet() {
        return this.jsonServlet;
    }

    private void jsonServlet_$eq(Option<JsonServlet> x$1) {
        this.jsonServlet = x$1;
    }

    public boolean running() {
        return this.running;
    }

    public void running_$eq(boolean x$1) {
        this.running = x$1;
    }

    public ServletContextHandler[] getServletContextHandlers() {
        Predef$.MODULE$.require(this.running(), (Function0 & Serializable & scala.Serializable)() -> "Can only call getServletHandlers on a running MetricsSystem");
        return (ServletContextHandler[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.prometheusServlet().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.jsonServlet().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHandlers($this.conf)).getOrElse((Function0 & Serializable & scala.Serializable)() -> (ServletContextHandler[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ServletContextHandler.class))))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ServletContextHandler.class)));
    }

    public void start(boolean registerStaticSources) {
        Predef$.MODULE$.require(!this.running(), (Function0 & Serializable & scala.Serializable)() -> "Attempting to start a MetricsSystem that is already running");
        this.running_$eq(true);
        if (registerStaticSources) {
            this.registerSources();
        }
        this.registerSinks();
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.start();
            return BoxedUnit.UNIT;
        });
    }

    public boolean start$default$1() {
        return true;
    }

    public void stop() {
        if (this.running()) {
            this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.stop();
                return BoxedUnit.UNIT;
            });
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping a MetricsSystem that is not running");
        }
        this.running_$eq(false);
    }

    public void report() {
        this.sinks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.report();
            return BoxedUnit.UNIT;
        });
    }

    private String buildRegistryName(Source source) {
        return MetricRegistry.name((String)source.sourceName(), (String[])new String[0]);
    }

    public Seq<Source> getSourcesByName(String sourceName) {
        return ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)MetricsSystem.$anonfun$getSourcesByName$1(sourceName, x$6)))).toSeq();
    }

    public void registerSource(Source source) {
        this.sources().add(source);
        try {
            String regName = this.buildRegistryName(source);
            this.registry().register(regName, (Metric)source.metricRegistry());
        }
        catch (IllegalArgumentException e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Metrics already registered", e);
        }
    }

    public void removeSource(Source source) {
        this.sources().remove(source);
        String regName = this.buildRegistryName(source);
        this.registry().removeMatching(new MetricFilter(null, regName){
            private final String regName$1;

            public boolean matches(String name, Metric metric) {
                return name.startsWith(this.regName$1);
            }
            {
                this.regName$1 = regName$1;
            }
        });
    }

    private void registerSources() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap sourceConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SOURCE_REGEX());
        sourceConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            MetricsSystem.$anonfun$registerSources$1(this, kv);
            return BoxedUnit.UNIT;
        });
    }

    private void registerSinks() {
        Properties instConfig = this.metricsConfig.getInstance(this.instance());
        HashMap sinkConfigs = this.metricsConfig.subProperties(instConfig, MetricsSystem$.MODULE$.SINK_REGEX());
        sinkConfigs.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String classPath = ((Properties)kv._2()).getProperty("class");
            if (classPath != null) {
                ArrayBuffer arrayBuffer;
                try {
                    Object object = kv._1();
                    String string = "prometheusServlet";
                    if (!(object != null ? !object.equals(string) : string != null)) {
                        Constructor servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, Seq.class, String.class);
                        this.prometheusServlet_$eq((Option<PrometheusServlet>)new Some((Object)((PrometheusServlet)servlet.newInstance(kv._2(), this.registry(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).toSeq(), this.prometheusServletPath()))));
                        arrayBuffer = BoxedUnit.UNIT;
                    } else {
                        Object object2 = kv._1();
                        String string2 = "jsonServlet";
                        if (!(object2 != null ? !object2.equals(string2) : string2 != null)) {
                            Constructor servlet = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class, Seq.class, String.class, Boolean.TYPE);
                            this.jsonServlet_$eq((Option<JsonServlet>)new Some((Object)((JsonServlet)servlet.newInstance(kv._2(), this.registry(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).toSeq(), this.jsonServletPath(), BoxesRunTime.boxToBoolean((boolean)$this.conf.metricsJsonPrettyEnabled())))));
                            arrayBuffer = BoxedUnit.UNIT;
                        } else {
                            Object object3 = kv._1();
                            String string3 = "loggerSink";
                            if (!(object3 != null ? !object3.equals(string3) : string3 != null)) {
                                Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Seq.class, CelebornConf.class).newInstance(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.sources()).asScala()).toSeq(), $this.conf);
                                arrayBuffer = this.sinks().$plus$eq((Object)((Sink)sink));
                            } else {
                                Object sink = Utils$.MODULE$.classForName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(kv._2(), this.registry());
                                arrayBuffer = this.sinks().$plus$eq((Object)((Sink)sink));
                            }
                        }
                    }
                }
                catch (Exception e) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Sink class ").append(classPath).append(" cannot be instantiated").toString());
                    throw e;
                }
                return arrayBuffer;
            }
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$getSourcesByName$1(String sourceName$1, Source x$6) {
        String string = x$6.sourceName();
        String string2 = sourceName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$registerSources$1(MetricsSystem $this, Tuple2 kv) {
        String classPath = ((Properties)kv._2()).getProperty("class");
        try {
            Object source = Utils$.MODULE$.classForName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            $this.registerSource((Source)source);
        }
        catch (Exception e) {
            $this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Source class ").append(classPath).append(" cannot be instantiated").toString(), e);
        }
    }

    public MetricsSystem(String instance, CelebornConf conf) {
        this.instance = instance;
        this.conf = conf;
        Logging.$init$((Logging)this);
        this.metricsConfig = new MetricsConfig(conf);
        this.sinks = new ArrayBuffer();
        this.sources = new CopyOnWriteArrayList();
        this.registry = new MetricRegistry();
        this.prometheusServletPath = (String)conf.get(CelebornConf$.MODULE$.METRICS_PROMETHEUS_PATH());
        this.jsonServletPath = (String)conf.get(CelebornConf$.MODULE$.METRICS_JSON_PATH());
        this.prometheusServlet = None$.MODULE$;
        this.jsonServlet = None$.MODULE$;
        this.running = false;
        this.metricsConfig.initialize();
    }
}

