/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.shortcircuit;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.client.impl.DfsClientConf;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.shaded.com.google.common.cache.Cache;
import org.apache.hadoop.shaded.com.google.common.cache.CacheBuilder;
import org.apache.hadoop.shaded.org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.PerformanceAdvisory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainSocketFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DomainSocketFactory.class);
    private final long pathExpireSeconds;
    private final Cache<String, PathState> pathMap;

    public DomainSocketFactory(DfsClientConf.ShortCircuitConf conf) {
        String feature = conf.isShortCircuitLocalReads() && !conf.isUseLegacyBlockReaderLocal() ? "The short-circuit local reads feature" : (conf.isDomainSocketDataTraffic() ? "UNIX domain socket data traffic" : null);
        if (feature == null) {
            PerformanceAdvisory.LOG.debug("Both short-circuit local reads and UNIX domain socket are disabled.");
        } else {
            if (conf.getDomainSocketPath().isEmpty()) {
                throw new HadoopIllegalArgumentException(feature + " is enabled but " + "dfs.domain.socket.path" + " is not set.");
            }
            if (DomainSocket.getLoadingFailureReason() != null) {
                LOG.warn(feature + " cannot be used because " + DomainSocket.getLoadingFailureReason());
            } else {
                LOG.debug(feature + " is enabled.");
            }
        }
        this.pathExpireSeconds = conf.getDomainSocketDisableIntervalSeconds();
        this.pathMap = CacheBuilder.newBuilder().expireAfterWrite(this.pathExpireSeconds, TimeUnit.SECONDS).build();
    }

    public PathInfo getPathInfo(InetSocketAddress addr, DfsClientConf.ShortCircuitConf conf) throws IOException {
        if (conf.getDomainSocketPath().isEmpty()) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!(conf.isDomainSocketDataTraffic() || conf.isShortCircuitLocalReads() && !conf.isUseLegacyBlockReaderLocal())) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (DomainSocket.getLoadingFailureReason() != null) {
            return PathInfo.NOT_CONFIGURED;
        }
        if (!DFSUtilClient.isLocalAddress(addr)) {
            return PathInfo.NOT_CONFIGURED;
        }
        String escapedPath = DomainSocket.getEffectivePath(conf.getDomainSocketPath(), addr.getPort());
        PathState status = (PathState)((Object)this.pathMap.getIfPresent((Object)escapedPath));
        if (status == null) {
            return new PathInfo(escapedPath, PathState.VALID);
        }
        return new PathInfo(escapedPath, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DomainSocket createSocket(PathInfo info, int socketTimeout) {
        Preconditions.checkArgument((info.getPathState() != PathState.UNUSABLE ? 1 : 0) != 0);
        boolean success = false;
        DomainSocket sock = null;
        try {
            sock = DomainSocket.connect(info.getPath());
            sock.setAttribute(4, socketTimeout);
            success = true;
        }
        catch (IOException e) {
            LOG.warn("error creating DomainSocket", (Throwable)e);
        }
        finally {
            if (!success) {
                if (sock != null) {
                    IOUtils.closeQuietly((Closeable)sock);
                }
                this.pathMap.put((Object)info.getPath(), (Object)PathState.UNUSABLE);
                sock = null;
            }
        }
        return sock;
    }

    public void disableShortCircuitForPath(String path) {
        this.pathMap.put((Object)path, (Object)PathState.SHORT_CIRCUIT_DISABLED);
    }

    public void disableDomainSocketPath(String path) {
        this.pathMap.put((Object)path, (Object)PathState.UNUSABLE);
    }

    @VisibleForTesting
    public void clearPathMap() {
        this.pathMap.invalidateAll();
    }

    public long getPathExpireSeconds() {
        return this.pathExpireSeconds;
    }

    public static class PathInfo {
        private static final PathInfo NOT_CONFIGURED = new PathInfo("", PathState.UNUSABLE);
        private final String path;
        private final PathState state;

        PathInfo(String path, PathState state) {
            this.path = path;
            this.state = state;
        }

        public String getPath() {
            return this.path;
        }

        public PathState getPathState() {
            return this.state;
        }

        public String toString() {
            return "PathInfo{path=" + this.path + ", state=" + (Object)((Object)this.state) + "}";
        }
    }

    public static enum PathState {
        UNUSABLE(false, false),
        SHORT_CIRCUIT_DISABLED(true, false),
        VALID(true, true);

        private final boolean usableForDataTransfer;
        private final boolean usableForShortCircuit;

        private PathState(boolean usableForDataTransfer, boolean usableForShortCircuit) {
            this.usableForDataTransfer = usableForDataTransfer;
            this.usableForShortCircuit = usableForShortCircuit;
        }

        public boolean getUsableForDataTransfer() {
            return this.usableForDataTransfer;
        }

        public boolean getUsableForShortCircuit() {
            return this.usableForShortCircuit;
        }
    }
}

