/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.curator.framework;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.shaded.org.apache.curator.RetryPolicy;
import org.apache.hadoop.shaded.org.apache.curator.ensemble.EnsembleProvider;
import org.apache.hadoop.shaded.org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.hadoop.shaded.org.apache.curator.framework.AuthInfo;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.CuratorTempFramework;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.ACLProvider;
import org.apache.hadoop.shaded.org.apache.curator.framework.api.CompressionProvider;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.CuratorTempFrameworkImpl;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.DefaultACLProvider;
import org.apache.hadoop.shaded.org.apache.curator.framework.imps.GzipCompressionProvider;
import org.apache.hadoop.shaded.org.apache.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.hadoop.shaded.org.apache.curator.utils.DefaultZookeeperFactory;
import org.apache.hadoop.shaded.org.apache.curator.utils.ZookeeperFactory;

public class CuratorFrameworkFactory {
    private static final int DEFAULT_SESSION_TIMEOUT_MS = Integer.getInteger("curator-default-session-timeout", 60000);
    private static final int DEFAULT_CONNECTION_TIMEOUT_MS = Integer.getInteger("curator-default-connection-timeout", 15000);
    private static final byte[] LOCAL_ADDRESS = CuratorFrameworkFactory.getLocalAddress();
    private static final CompressionProvider DEFAULT_COMPRESSION_PROVIDER = new GzipCompressionProvider();
    private static final DefaultZookeeperFactory DEFAULT_ZOOKEEPER_FACTORY = new DefaultZookeeperFactory();
    private static final DefaultACLProvider DEFAULT_ACL_PROVIDER = new DefaultACLProvider();
    private static final long DEFAULT_INACTIVE_THRESHOLD_MS = (int)TimeUnit.MINUTES.toMillis(3L);
    private static final int DEFAULT_CLOSE_WAIT_MS = (int)TimeUnit.SECONDS.toMillis(1L);

    public static Builder builder() {
        return new Builder();
    }

    public static CuratorFramework newClient(String connectString, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.newClient(connectString, DEFAULT_SESSION_TIMEOUT_MS, DEFAULT_CONNECTION_TIMEOUT_MS, retryPolicy);
    }

    public static CuratorFramework newClient(String connectString, int sessionTimeoutMs, int connectionTimeoutMs, RetryPolicy retryPolicy) {
        return CuratorFrameworkFactory.builder().connectString(connectString).sessionTimeoutMs(sessionTimeoutMs).connectionTimeoutMs(connectionTimeoutMs).retryPolicy(retryPolicy).build();
    }

    public static byte[] getLocalAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress().getBytes();
        }
        catch (UnknownHostException unknownHostException) {
            return new byte[0];
        }
    }

    private CuratorFrameworkFactory() {
    }

    static /* synthetic */ int access$100() {
        return DEFAULT_SESSION_TIMEOUT_MS;
    }

    static /* synthetic */ int access$200() {
        return DEFAULT_CONNECTION_TIMEOUT_MS;
    }

    static /* synthetic */ int access$300() {
        return DEFAULT_CLOSE_WAIT_MS;
    }

    static /* synthetic */ byte[] access$400() {
        return LOCAL_ADDRESS;
    }

    static /* synthetic */ CompressionProvider access$500() {
        return DEFAULT_COMPRESSION_PROVIDER;
    }

    static /* synthetic */ DefaultZookeeperFactory access$600() {
        return DEFAULT_ZOOKEEPER_FACTORY;
    }

    static /* synthetic */ DefaultACLProvider access$700() {
        return DEFAULT_ACL_PROVIDER;
    }

    public static class Builder {
        private EnsembleProvider ensembleProvider;
        private int sessionTimeoutMs = CuratorFrameworkFactory.access$100();
        private int connectionTimeoutMs = CuratorFrameworkFactory.access$200();
        private int maxCloseWaitMs = CuratorFrameworkFactory.access$300();
        private RetryPolicy retryPolicy;
        private ThreadFactory threadFactory = null;
        private String namespace;
        private List<AuthInfo> authInfos = null;
        private byte[] defaultData = CuratorFrameworkFactory.access$400();
        private CompressionProvider compressionProvider = CuratorFrameworkFactory.access$500();
        private ZookeeperFactory zookeeperFactory = CuratorFrameworkFactory.access$600();
        private ACLProvider aclProvider = CuratorFrameworkFactory.access$700();
        private boolean canBeReadOnly = false;
        private boolean useContainerParentsIfAvailable = true;

        public CuratorFramework build() {
            return new CuratorFrameworkImpl(this);
        }

        public CuratorTempFramework buildTemp() {
            return this.buildTemp(DEFAULT_INACTIVE_THRESHOLD_MS, TimeUnit.MILLISECONDS);
        }

        public CuratorTempFramework buildTemp(long inactiveThreshold, TimeUnit unit) {
            return new CuratorTempFrameworkImpl(this, unit.toMillis(inactiveThreshold));
        }

        public Builder authorization(String scheme, byte[] auth) {
            return this.authorization(ImmutableList.of(new AuthInfo(scheme, auth != null ? Arrays.copyOf(auth, auth.length) : null)));
        }

        public Builder authorization(List<AuthInfo> authInfos) {
            this.authInfos = ImmutableList.copyOf(authInfos);
            return this;
        }

        public Builder connectString(String connectString) {
            this.ensembleProvider = new FixedEnsembleProvider(connectString);
            return this;
        }

        public Builder ensembleProvider(EnsembleProvider ensembleProvider) {
            this.ensembleProvider = ensembleProvider;
            return this;
        }

        public Builder defaultData(byte[] defaultData) {
            this.defaultData = defaultData != null ? Arrays.copyOf(defaultData, defaultData.length) : null;
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public Builder sessionTimeoutMs(int sessionTimeoutMs) {
            this.sessionTimeoutMs = sessionTimeoutMs;
            return this;
        }

        public Builder connectionTimeoutMs(int connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
            return this;
        }

        public Builder maxCloseWaitMs(int maxCloseWaitMs) {
            this.maxCloseWaitMs = maxCloseWaitMs;
            return this;
        }

        public Builder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder compressionProvider(CompressionProvider compressionProvider) {
            this.compressionProvider = compressionProvider;
            return this;
        }

        public Builder zookeeperFactory(ZookeeperFactory zookeeperFactory) {
            this.zookeeperFactory = zookeeperFactory;
            return this;
        }

        public Builder aclProvider(ACLProvider aclProvider) {
            this.aclProvider = aclProvider;
            return this;
        }

        public Builder canBeReadOnly(boolean canBeReadOnly) {
            this.canBeReadOnly = canBeReadOnly;
            return this;
        }

        public Builder dontUseContainerParents() {
            this.useContainerParentsIfAvailable = false;
            return this;
        }

        public ACLProvider getAclProvider() {
            return this.aclProvider;
        }

        public ZookeeperFactory getZookeeperFactory() {
            return this.zookeeperFactory;
        }

        public CompressionProvider getCompressionProvider() {
            return this.compressionProvider;
        }

        public ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        public EnsembleProvider getEnsembleProvider() {
            return this.ensembleProvider;
        }

        public int getSessionTimeoutMs() {
            return this.sessionTimeoutMs;
        }

        public int getConnectionTimeoutMs() {
            return this.connectionTimeoutMs;
        }

        public int getMaxCloseWaitMs() {
            return this.maxCloseWaitMs;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean useContainerParentsIfAvailable() {
            return this.useContainerParentsIfAvailable;
        }

        @Deprecated
        public String getAuthScheme() {
            int qty = this.authInfos != null ? this.authInfos.size() : 0;
            switch (qty) {
                case 0: {
                    return null;
                }
                case 1: {
                    return this.authInfos.get((int)0).scheme;
                }
            }
            throw new IllegalStateException("More than 1 auth has been added");
        }

        @Deprecated
        public byte[] getAuthValue() {
            int qty = this.authInfos != null ? this.authInfos.size() : 0;
            switch (qty) {
                case 0: {
                    return null;
                }
                case 1: {
                    byte[] bytes = this.authInfos.get(0).getAuth();
                    return bytes != null ? Arrays.copyOf(bytes, bytes.length) : null;
                }
            }
            throw new IllegalStateException("More than 1 auth has been added");
        }

        public List<AuthInfo> getAuthInfos() {
            return this.authInfos;
        }

        public byte[] getDefaultData() {
            return this.defaultData;
        }

        public boolean canBeReadOnly() {
            return this.canBeReadOnly;
        }

        private Builder() {
        }
    }
}

