/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.celeborn.plugin.flink.RemoteShuffleOutputGate;
import org.apache.celeborn.plugin.flink.RemoteShuffleResultPartitionDelegation;
import org.apache.celeborn.plugin.flink.buffer.SortBuffer;
import org.apache.celeborn.plugin.flink.utils.BufferUtils;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfData;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.api.StopMode;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionManager;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.util.function.SupplierWithException;

public class RemoteShuffleResultPartition
extends ResultPartition {
    private final RemoteShuffleResultPartitionDelegation delegation;

    public RemoteShuffleResultPartition(String owningTaskName, int partitionIndex, ResultPartitionID partitionId, ResultPartitionType partitionType, int numSubpartitions, int numTargetKeyGroups, int networkBufferSize, ResultPartitionManager partitionManager, @Nullable BufferCompressor bufferCompressor, SupplierWithException<BufferPool, IOException> bufferPoolFactory, RemoteShuffleOutputGate outputGate) {
        super(owningTaskName, partitionIndex, partitionId, partitionType, numSubpartitions, numTargetKeyGroups, partitionManager, bufferCompressor, bufferPoolFactory);
        this.delegation = new RemoteShuffleResultPartitionDelegation(networkBufferSize, outputGate, (bufferWithChannel, isBroadcast) -> this.updateStatistics((SortBuffer.BufferWithChannel)bufferWithChannel, (boolean)isBroadcast), numSubpartitions);
    }

    public void setup() throws IOException {
        super.setup();
        BufferUtils.reserveNumRequiredBuffers(this.bufferPool, 1);
        this.delegation.setup(this.bufferPool, this.bufferCompressor, buffer -> this.canBeCompressed((Buffer)buffer), () -> this.checkInProduceState());
    }

    protected void setupInternal() {
    }

    public void emitRecord(ByteBuffer record, int targetSubpartition) throws IOException {
        this.delegation.emit(record, targetSubpartition, Buffer.DataType.DATA_BUFFER, false);
    }

    public void broadcastRecord(ByteBuffer record) throws IOException {
        this.delegation.broadcast(record, Buffer.DataType.DATA_BUFFER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastEvent(AbstractEvent event, boolean isPriorityEvent) throws IOException {
        Buffer buffer = EventSerializer.toBuffer((AbstractEvent)event, (boolean)isPriorityEvent);
        try {
            ByteBuffer serializedEvent = buffer.getNioBufferReadable();
            this.delegation.broadcast(serializedEvent, buffer.getDataType());
        }
        finally {
            buffer.recycleBuffer();
        }
    }

    public void alignedBarrierTimeout(long l) {
    }

    public void abortCheckpoint(long l, CheckpointException e) {
    }

    public void finish() throws IOException {
        Utils.checkState(!this.isReleased(), "Result partition is already released.");
        this.broadcastEvent((AbstractEvent)EndOfPartitionEvent.INSTANCE, false);
        this.delegation.finish();
        super.finish();
    }

    public synchronized void close() {
        this.delegation.close(() -> super.close());
    }

    protected void releaseInternal() {
    }

    public void flushAll() {
        this.delegation.flushAll();
    }

    public void flush(int subpartitionIndex) {
        this.flushAll();
    }

    public CompletableFuture<?> getAvailableFuture() {
        return AVAILABLE;
    }

    public int getNumberOfQueuedBuffers() {
        return 0;
    }

    public long getSizeOfQueuedBuffersUnsafe() {
        return 0L;
    }

    public int getNumberOfQueuedBuffers(int targetSubpartition) {
        return 0;
    }

    public ResultSubpartitionView createSubpartitionView(int index, BufferAvailabilityListener availabilityListener) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void notifyEndOfData(StopMode mode) throws IOException {
        if (!this.delegation.isEndOfDataNotified()) {
            this.broadcastEvent((AbstractEvent)new EndOfData(mode), false);
            this.delegation.setEndOfDataNotified(true);
        }
    }

    public CompletableFuture<Void> getAllDataProcessedFuture() {
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return "ResultPartition " + this.partitionId.toString() + " [" + this.partitionType + ", " + this.numSubpartitions + " subpartitions, shuffle-descriptor: " + this.delegation.getOutputGate().getShuffleDesc() + "]";
    }

    @VisibleForTesting
    public RemoteShuffleResultPartitionDelegation getDelegation() {
        return this.delegation;
    }

    public void updateStatistics(SortBuffer.BufferWithChannel bufferWithChannel, boolean isBroadcast) {
        this.numBuffersOut.inc(isBroadcast ? (long)this.numSubpartitions : 1L);
        long readableBytes = bufferWithChannel.getBuffer().readableBytes() - 22;
        if (isBroadcast) {
            this.resultPartitionBytes.incAll(readableBytes);
        } else {
            this.resultPartitionBytes.inc(bufferWithChannel.getChannelIndex(), readableBytes);
        }
        this.numBytesOut.inc(isBroadcast ? readableBytes * (long)this.numSubpartitions : readableBytes);
    }
}

