/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.common.util.ThreadUtils;
import org.apache.celeborn.plugin.flink.FlinkResultPartitionInfo;
import org.apache.celeborn.plugin.flink.RemoteShuffleDescriptor;
import org.apache.celeborn.plugin.flink.RemoteShuffleResource;
import org.apache.celeborn.plugin.flink.ResultPartitionAdapter;
import org.apache.celeborn.plugin.flink.ShuffleResourceDescriptor;
import org.apache.celeborn.plugin.flink.ShuffleResourceTracker;
import org.apache.celeborn.plugin.flink.ShuffleTaskInfo;
import org.apache.celeborn.plugin.flink.utils.FlinkUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleMasterContext;
import org.apache.flink.runtime.shuffle.TaskInputsOutputsDescriptor;
import org.apache.flink.util.ExecutorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShuffleMaster
implements ShuffleMaster<RemoteShuffleDescriptor> {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteShuffleMaster.class);
    private final ShuffleMasterContext shuffleMasterContext;
    private Map<JobID, Set<Integer>> jobShuffleIds = JavaUtils.newConcurrentHashMap();
    private String celebornAppId;
    private volatile LifecycleManager lifecycleManager;
    private ShuffleTaskInfo shuffleTaskInfo = new ShuffleTaskInfo();
    private ShuffleResourceTracker shuffleResourceTracker;
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, ThreadUtils.namedThreadFactory("remote-shuffle-master-executor"));
    private final ResultPartitionAdapter resultPartitionDelegation;
    private final long lifecycleManagerTimestamp;

    public RemoteShuffleMaster(ShuffleMasterContext shuffleMasterContext, ResultPartitionAdapter resultPartitionDelegation) {
        this.shuffleMasterContext = shuffleMasterContext;
        this.resultPartitionDelegation = resultPartitionDelegation;
        this.lifecycleManagerTimestamp = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void registerJob(JobShuffleContext context) {
        JobID jobID = context.getJobId();
        if (this.lifecycleManager == null) {
            Class<RemoteShuffleMaster> clazz = RemoteShuffleMaster.class;
            // MONITORENTER : org.apache.celeborn.plugin.flink.RemoteShuffleMaster.class
            if (this.lifecycleManager == null) {
                this.celebornAppId = FlinkUtils.toCelebornAppId(this.lifecycleManagerTimestamp, jobID);
                LOG.info("CelebornAppId: {}", (Object)this.celebornAppId);
                CelebornConf celebornConf = FlinkUtils.toCelebornConf(this.shuffleMasterContext.getConfiguration());
                celebornConf.setIfMissing(CelebornConf.CLIENT_CHECKED_USE_ALLOCATED_WORKERS(), Boolean.valueOf(true));
                this.lifecycleManager = new LifecycleManager(this.celebornAppId, celebornConf);
                if (celebornConf.clientPushReplicateEnabled()) {
                    this.shuffleMasterContext.onFatalError((Throwable)new RuntimeException("Currently replicate shuffle data is unsupported for flink."));
                    // MONITOREXIT : clazz
                    return;
                }
                this.shuffleResourceTracker = new ShuffleResourceTracker(this.executor, this.lifecycleManager);
            }
            // MONITOREXIT : clazz
        }
        Set previousShuffleIds = this.jobShuffleIds.putIfAbsent(jobID, new HashSet());
        LOG.info("Register job: {}.", (Object)jobID);
        this.shuffleResourceTracker.registerJob(context);
        if (previousShuffleIds == null) return;
        throw new RuntimeException("Duplicated registration job: " + jobID);
    }

    public void unregisterJob(JobID jobID) {
        LOG.info("Unregister job: {}.", (Object)jobID);
        Set<Integer> shuffleIds = this.jobShuffleIds.remove(jobID);
        if (shuffleIds != null) {
            this.executor.execute(() -> {
                try {
                    for (Integer shuffleId : shuffleIds) {
                        this.lifecycleManager.unregisterShuffle(shuffleId);
                        this.shuffleTaskInfo.removeExpiredShuffle(shuffleId);
                    }
                    this.shuffleResourceTracker.unRegisterJob(jobID);
                }
                catch (Throwable throwable) {
                    LOG.error("Encounter an error when unregistering job: {}.", (Object)jobID, (Object)throwable);
                }
            });
        }
    }

    public CompletableFuture<RemoteShuffleDescriptor> registerPartitionWithProducer(JobID jobID, PartitionDescriptor partitionDescriptor, ProducerDescriptor producerDescriptor) {
        CompletableFuture<RemoteShuffleDescriptor> completableFuture = CompletableFuture.supplyAsync(() -> {
            Set<Integer> shuffleIds = this.jobShuffleIds.get(jobID);
            if (shuffleIds == null) {
                throw new RuntimeException("Can not find job in lifecycleManager, job: " + jobID);
            }
            FlinkResultPartitionInfo resultPartitionInfo = new FlinkResultPartitionInfo(jobID, partitionDescriptor, producerDescriptor);
            ShuffleResourceDescriptor shuffleResourceDescriptor = this.shuffleTaskInfo.genShuffleResourceDescriptor(resultPartitionInfo.getShuffleId(), resultPartitionInfo.getTaskId(), resultPartitionInfo.getAttemptId());
            Set<Integer> set = shuffleIds;
            synchronized (set) {
                shuffleIds.add(shuffleResourceDescriptor.getShuffleId());
            }
            RemoteShuffleResource remoteShuffleResource = new RemoteShuffleResource(this.lifecycleManager.getHost(), this.lifecycleManager.getPort(), this.lifecycleManagerTimestamp, shuffleResourceDescriptor);
            this.shuffleResourceTracker.addPartitionResource(jobID, shuffleResourceDescriptor.getShuffleId(), shuffleResourceDescriptor.getPartitionId(), resultPartitionInfo.getResultPartitionId());
            return new RemoteShuffleDescriptor(this.celebornAppId, jobID, resultPartitionInfo.getShuffleId(), resultPartitionInfo.getResultPartitionId(), remoteShuffleResource);
        }, this.executor);
        return completableFuture;
    }

    public void releasePartitionExternally(ShuffleDescriptor shuffleDescriptor) {
        this.executor.execute(() -> {
            if (!(shuffleDescriptor instanceof RemoteShuffleDescriptor)) {
                LOG.error("Only RemoteShuffleDescriptor is supported {}.", (Object)shuffleDescriptor.getClass().getName());
                this.shuffleMasterContext.onFatalError((Throwable)new RuntimeException("Illegal shuffle descriptor type."));
                return;
            }
            try {
                RemoteShuffleDescriptor descriptor = (RemoteShuffleDescriptor)shuffleDescriptor;
                RemoteShuffleResource shuffleResource = descriptor.getShuffleResource();
                ShuffleResourceDescriptor resourceDescriptor = shuffleResource.getMapPartitionShuffleDescriptor();
                LOG.debug("release partition resource: {}.", (Object)resourceDescriptor);
                this.lifecycleManager.releasePartition(resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
                this.shuffleResourceTracker.removePartitionResource(descriptor.getJobId(), resourceDescriptor.getShuffleId(), resourceDescriptor.getPartitionId());
            }
            catch (Throwable throwable) {
                LOG.debug("Failed to release data partition {}.", (Object)shuffleDescriptor, (Object)throwable);
            }
        });
    }

    public MemorySize computeShuffleMemorySizeForTask(TaskInputsOutputsDescriptor taskInputsOutputsDescriptor) {
        for (ResultPartitionType partitionType : taskInputsOutputsDescriptor.getPartitionTypes().values()) {
            boolean isBlockingShuffle = this.resultPartitionDelegation.isBlockingResultPartition(partitionType);
            if (isBlockingShuffle) continue;
            throw new RuntimeException("Blocking result partition type expected but found " + partitionType);
        }
        int numResultPartitions = taskInputsOutputsDescriptor.getSubpartitionNums().size();
        CelebornConf conf = FlinkUtils.toCelebornConf(this.shuffleMasterContext.getConfiguration());
        long numBytesPerPartition = conf.clientFlinkMemoryPerResultPartition();
        long numBytesForOutput = numBytesPerPartition * (long)numResultPartitions;
        int numInputGates = taskInputsOutputsDescriptor.getInputChannelNums().size();
        long numBytesPerGate = conf.clientFlinkMemoryPerInputGate();
        long numBytesForInput = numBytesPerGate * (long)numInputGates;
        LOG.debug("Announcing number of bytes {} for output and {} for input.", (Object)numBytesForOutput, (Object)numBytesForInput);
        return new MemorySize(numBytesForInput + numBytesForOutput);
    }

    public void close() throws Exception {
        try {
            this.jobShuffleIds.clear();
            this.lifecycleManager.stop();
        }
        catch (Exception e) {
            LOG.warn("Encounter exception when shutdown: {}", (Object)e.getMessage(), (Object)e);
        }
        ExecutorUtils.gracefulShutdown((long)10L, (TimeUnit)TimeUnit.SECONDS, (ExecutorService[])new ExecutorService[]{this.executor});
    }
}

