/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util;

import javax.swing.text.AttributeSet;
import org.apache.cayenne.modeler.dialog.LogConsole;
import org.apache.commons.logging.Log;

public class ModelerLogger
implements Log {
    Log delegate;
    String name;

    public ModelerLogger(String name, Log delegate) {
        this.name = name;
        this.delegate = delegate;
    }

    public void debug(Object message) {
        this.delegate.debug(message);
        this.log("DEBUG", message, null, LogConsole.DEBUG_STYLE);
    }

    public void debug(Object message, Throwable t) {
        this.delegate.debug(message, t);
        this.log("DEBUG", message, t, LogConsole.DEBUG_STYLE);
    }

    public void error(Object message) {
        this.delegate.error(message);
        this.log("ERROR", message, null, LogConsole.ERROR_STYLE);
    }

    public void error(Object message, Throwable t) {
        this.delegate.error(message, t);
        this.log("ERROR", message, t, LogConsole.ERROR_STYLE);
    }

    public void fatal(Object message) {
        this.delegate.fatal(message);
        this.log("FATAL", message, null, LogConsole.FATAL_STYLE);
    }

    public void fatal(Object message, Throwable t) {
        this.delegate.fatal(message, t);
        this.log("FATAL", message, t, LogConsole.FATAL_STYLE);
    }

    public void info(Object message) {
        this.delegate.info(message);
        this.log("INFO", message, null, LogConsole.INFO_STYLE);
    }

    public void info(Object message, Throwable t) {
        this.delegate.info(message);
        this.log("INFO", message, t, LogConsole.INFO_STYLE);
    }

    public void trace(Object message) {
        this.delegate.trace(message);
        this.log("TRACE", message, null, LogConsole.DEBUG_STYLE);
    }

    public void trace(Object message, Throwable t) {
        this.delegate.trace(message, t);
        this.log("TRACE", message, t, LogConsole.DEBUG_STYLE);
    }

    public void warn(Object message) {
        this.delegate.warn(message);
        this.log("WARN", message, null, LogConsole.WARN_STYLE);
    }

    public void warn(Object message, Throwable t) {
        this.delegate.warn(message, t);
        this.log("WARN", message, t, LogConsole.WARN_STYLE);
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.delegate.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.delegate.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.delegate.isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        return this.delegate.isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        return this.delegate.isWarnEnabled();
    }

    private void log(String level, Object message, Throwable t, AttributeSet style) {
        this.getLogConsole().appendMessage(level, String.valueOf(message), t, style);
    }

    private LogConsole getLogConsole() {
        return LogConsole.getInstance();
    }
}

