/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.action;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.MapLoader;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneAction;
import org.apache.cayenne.modeler.util.FileFilters;
import org.apache.cayenne.project.NamedObjectFactory;
import org.apache.cayenne.util.ResourceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportDataMapAction
extends CayenneAction {
    private static Log logObj = LogFactory.getLog(ImportDataMapAction.class);

    public static String getActionName() {
        return "Import DataMap";
    }

    public ImportDataMapAction(Application application) {
        super(ImportDataMapAction.getActionName(), application);
    }

    public void performAction(ActionEvent e) {
        this.importDataMap();
    }

    protected void importDataMap() {
        File dataMapFile = this.selectDataMap(Application.getFrame());
        if (dataMapFile == null) {
            return;
        }
        try {
            MapLoader mapLoader = new MapLoader(){

                protected ResourceLocator configLocator() {
                    ResourceLocator locator = new ResourceLocator();
                    locator.setSkipAbsolutePath(false);
                    locator.setSkipClasspath(true);
                    locator.setSkipCurrentDirectory(true);
                    locator.setSkipHomeDirectory(true);
                    return locator;
                }
            };
            DataMap newMap = mapLoader.loadDataMap(dataMapFile.getAbsolutePath());
            DataDomain domain = this.getProjectController().getCurrentDataDomain();
            if (newMap.getName() != null) {
                newMap.setName(NamedObjectFactory.createName(DataMap.class, (Object)domain, (String)newMap.getName()));
            } else {
                newMap.setName(NamedObjectFactory.createName(DataMap.class, (Object)domain));
            }
            this.getProjectController().addDataMap(this, newMap);
        }
        catch (Exception ex) {
            logObj.info((Object)"Error importing DataMap.", (Throwable)ex);
            JOptionPane.showMessageDialog(Application.getFrame(), "Error reading DataMap: " + ex.getMessage(), "Can't Open DataMap", 0);
        }
    }

    protected File selectDataMap(Frame f) {
        FSPath lastDir = this.getApplication().getFrameController().getLastDirectory();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        lastDir.updateChooser(chooser);
        chooser.addChoosableFileFilter(FileFilters.getDataMapFilter());
        int status = chooser.showDialog(f, "Select DataMap");
        if (status == 0) {
            File file = chooser.getSelectedFile();
            lastDir.updateFromChooser(chooser);
            return file;
        }
        return null;
    }
}

