/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.ObjectStore;
import org.apache.cayenne.access.PrefetchProcessorJointNode;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.PrefetchProcessorTreeBuilder;
import org.apache.cayenne.query.PrefetchProcessor;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.reflect.ClassDescriptor;

class HierarchicalObjectResolver {
    DataContext context;
    QueryMetadata queryMetadata;
    DataRowStore cache;
    ClassDescriptor descriptor;
    boolean needToSaveDuplicates;

    HierarchicalObjectResolver(DataContext context, QueryMetadata queryMetadata) {
        this.queryMetadata = queryMetadata;
        this.context = context;
        this.cache = context.getObjectStore().getDataRowCache();
    }

    HierarchicalObjectResolver(DataContext context, QueryMetadata metadata, ClassDescriptor descriptor, boolean needToSaveDuplicates) {
        this(context, metadata);
        this.descriptor = descriptor;
        this.needToSaveDuplicates = needToSaveDuplicates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrefetchProcessorNode synchronizedRootResultNodeFromDataRows(PrefetchTreeNode tree, List mainResultRows, Map extraResultsByPath) {
        ObjectStore objectStore = this.context.getObjectStore();
        synchronized (objectStore) {
            DataRowStore dataRowStore = this.cache;
            synchronized (dataRowStore) {
                return this.resolveObjectTree(tree, mainResultRows, extraResultsByPath);
            }
        }
    }

    private PrefetchProcessorNode resolveObjectTree(PrefetchTreeNode tree, List mainResultRows, Map extraResultsByPath) {
        PrefetchProcessorNode decoratedTree = new PrefetchProcessorTreeBuilder(this, mainResultRows, extraResultsByPath).buildTree(tree);
        decoratedTree.traverse(new DisjointProcessor());
        decoratedTree.traverse(new PostProcessor());
        return decoratedTree;
    }

    final class PostProcessor
    implements PrefetchProcessor {
        PostProcessor() {
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            ((PrefetchProcessorNode)node).connectToParents();
            return true;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            if (!processorNode.getObjects().isEmpty()) {
                HierarchicalObjectResolver.this.cache.snapshotsUpdatedForObjects(processorNode.getObjects(), processorNode.getResolvedRows(), HierarchicalObjectResolver.this.queryMetadata.isRefreshingObjects());
            }
            processorNode.connectToParents();
            return true;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }
    }

    final class JointProcessor
    implements PrefetchProcessor {
        DataRow currentFlatRow;
        PrefetchProcessorNode rootNode;

        JointProcessor(PrefetchProcessorJointNode rootNode) {
            this.rootNode = rootNode;
        }

        void setCurrentFlatRow(DataRow currentFlatRow) {
            this.currentFlatRow = currentFlatRow;
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            return node == this.rootNode;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
            Persistent object = null;
            Map<String, Object> id = processorNode.idFromFlatRow(this.currentFlatRow);
            object = processorNode.getResolved(id);
            DataRow row = null;
            if (object == null) {
                row = processorNode.rowFromFlatRow(this.currentFlatRow);
                object = processorNode.getResolver().objectFromDataRow(row);
                if (object == null) {
                    return false;
                }
                processorNode.putResolved(id, object);
                processorNode.addObject(object, row);
            }
            processorNode.getParentAttachmentStrategy().linkToParent(row, object);
            processorNode.setLastResolved(object);
            return processorNode.isJointChildren();
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return ((PrefetchProcessorNode)node).isJointChildren();
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }

        public void finishPrefetch(PrefetchTreeNode node) {
        }
    }

    final class DisjointProcessor
    implements PrefetchProcessor {
        DisjointProcessor() {
        }

        public boolean startDisjointPrefetch(PrefetchTreeNode node) {
            PrefetchProcessorNode processorNode = (PrefetchProcessorNode)node;
            if (processorNode.getDataRows() == null) {
                return false;
            }
            if (processorNode.getDataRows().isEmpty()) {
                return true;
            }
            List<Persistent> objects = processorNode.getResolver().objectsFromDataRows(processorNode.getDataRows());
            processorNode.setObjects(objects);
            return true;
        }

        public boolean startJointPrefetch(PrefetchTreeNode node) {
            if (node.getParent() != null && !node.getParent().isJointPrefetch()) {
                PrefetchProcessorNode parent;
                PrefetchProcessorJointNode processorNode = (PrefetchProcessorJointNode)node;
                JointProcessor subprocessor = new JointProcessor(processorNode);
                for (parent = (PrefetchProcessorNode)processorNode.getParent(); parent != null && parent.isPhantom(); parent = (PrefetchProcessorNode)parent.getParent()) {
                }
                if (parent == null) {
                    return false;
                }
                List parentRows = parent.getDataRows();
                if (parentRows == null || parentRows.size() == 0) {
                    return false;
                }
                List parentObjects = parent.getObjects();
                int size = parentRows.size();
                for (int i = 0; i < size; ++i) {
                    subprocessor.setCurrentFlatRow((DataRow)parentRows.get(i));
                    parent.setLastResolved((Persistent)parentObjects.get(i));
                    processorNode.traverse(subprocessor);
                }
                List objects = processorNode.getObjects();
                HierarchicalObjectResolver.this.cache.snapshotsUpdatedForObjects(objects, processorNode.getResolvedRows(), HierarchicalObjectResolver.this.queryMetadata.isRefreshingObjects());
            }
            return true;
        }

        public boolean startPhantomPrefetch(PrefetchTreeNode node) {
            return true;
        }

        public boolean startUnknownPrefetch(PrefetchTreeNode node) {
            throw new CayenneRuntimeException("Unknown prefetch node: " + node);
        }

        public void finishPrefetch(PrefetchTreeNode node) {
            List objects;
            PrefetchProcessorNode processorNode;
            if (node.isDisjointPrefetch() && !HierarchicalObjectResolver.this.needToSaveDuplicates && (processorNode = (PrefetchProcessorNode)node).isJointChildren() && (objects = processorNode.getObjects()) != null && objects.size() > 1) {
                HashSet seen = new HashSet(objects.size());
                Iterator it = objects.iterator();
                while (it.hasNext()) {
                    if (seen.add(it.next())) continue;
                    it.remove();
                }
            }
        }
    }
}

