/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.map;

import java.io.Serializable;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.Entity;
import org.apache.cayenne.map.MappingNamespace;
import org.apache.cayenne.util.CayenneMapEntry;
import org.apache.cayenne.util.ToStringBuilder;
import org.apache.cayenne.util.XMLSerializable;

public abstract class Relationship<E extends Entity<E, A, R>, A extends Attribute<E, A, R>, R extends Relationship<E, A, R>>
implements CayenneMapEntry,
XMLSerializable,
Serializable {
    protected String name;
    protected E sourceEntity;
    protected String targetEntityName;
    protected boolean toMany;
    protected boolean runtime;

    public Relationship() {
    }

    public Relationship(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public E getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(E sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public abstract E getTargetEntity();

    public void setTargetEntityName(Entity<E, A, R> targetEntity) {
        if (targetEntity != null) {
            this.setTargetEntityName(targetEntity.getName());
        } else {
            this.setTargetEntityName((String)null);
        }
    }

    public String getTargetEntityName() {
        return this.targetEntityName;
    }

    public void setTargetEntityName(String targetEntityName) {
        this.targetEntityName = targetEntityName;
    }

    public boolean isToMany() {
        return this.toMany;
    }

    @Override
    public Object getParent() {
        return this.getSourceEntity();
    }

    @Override
    public void setParent(Object parent) {
        if (parent != null && !(parent instanceof Entity)) {
            throw new IllegalArgumentException("Expected null or Entity, got: " + parent);
        }
        this.setSourceEntity((Entity)parent);
    }

    final MappingNamespace getNonNullNamespace() {
        E entity = this.getSourceEntity();
        if (entity == null) {
            throw new CayenneRuntimeException("Relationship '%s' has no parent Entity.", this.getName());
        }
        return ((Entity)entity).getNonNullNamespace();
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.getName()).append("toMany", this.isToMany()).toString();
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public void setRuntime(boolean synthetic) {
        this.runtime = synthetic;
    }

    public abstract Relationship<E, A, R> getReverseRelationship();

    public abstract boolean isMandatory();
}

