/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.cache.invalidation;

import java.util.Collection;
import java.util.function.Function;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.cache.invalidation.CacheGroupDescriptor;
import org.apache.cayenne.cache.invalidation.CacheGroupsHandler;
import org.apache.cayenne.cache.invalidation.InvalidationHandler;
import org.apache.cayenne.di.Binder;
import org.apache.cayenne.di.ListBuilder;

public class CacheInvalidationModuleExtender {
    private final Binder binder;
    private ListBuilder<InvalidationHandler> invalidationHandlers;

    protected CacheInvalidationModuleExtender(Binder binder) {
        this.binder = binder;
    }

    protected CacheInvalidationModuleExtender initAllExtensions() {
        this.contributeInvalidationHandlers();
        return this;
    }

    public CacheInvalidationModuleExtender noCacheGroupsHandler() {
        this.binder.bind(CacheGroupsHandler.class).toInstance((Object)new CacheGroupsHandler(){

            @Override
            public Function<Persistent, Collection<CacheGroupDescriptor>> canHandle(Class<? extends Persistent> type) {
                return null;
            }
        });
        return this;
    }

    public CacheInvalidationModuleExtender addHandler(Class<? extends InvalidationHandler> handlerType) {
        this.contributeInvalidationHandlers().add(handlerType);
        return this;
    }

    public CacheInvalidationModuleExtender addHandler(InvalidationHandler handlerInstance) {
        this.contributeInvalidationHandlers().add((Object)handlerInstance);
        return this;
    }

    private ListBuilder<InvalidationHandler> contributeInvalidationHandlers() {
        if (this.invalidationHandlers == null) {
            this.invalidationHandlers = this.binder.bindList(InvalidationHandler.class);
        }
        return this.invalidationHandlers;
    }
}

