/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.EmbeddableObject;
import org.apache.cayenne.ObjectContext;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.QueryResponse;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.access.DataDomainQuery;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DataRowStore;
import org.apache.cayenne.access.HierarchicalObjectResolver;
import org.apache.cayenne.access.ListWithPrefetches;
import org.apache.cayenne.access.ObjectResolver;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.PrefetchProcessorNode;
import org.apache.cayenne.access.QueryEngine;
import org.apache.cayenne.access.ResultIteratorConverterDecorator;
import org.apache.cayenne.access.TransactionResultIteratorDecorator;
import org.apache.cayenne.cache.QueryCache;
import org.apache.cayenne.cache.QueryCacheEntryFactory;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.exp.path.CayennePath;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbRelationship;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EntityInheritanceTree;
import org.apache.cayenne.map.LifecycleEvent;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.query.EmbeddableResultSegment;
import org.apache.cayenne.query.EntityResultSegment;
import org.apache.cayenne.query.IteratedQueryDecorator;
import org.apache.cayenne.query.ObjectIdQuery;
import org.apache.cayenne.query.PrefetchSelectQuery;
import org.apache.cayenne.query.PrefetchTreeNode;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.RefreshQuery;
import org.apache.cayenne.query.RelationshipQuery;
import org.apache.cayenne.reflect.ClassDescriptor;
import org.apache.cayenne.reflect.LifecycleCallbackRegistry;
import org.apache.cayenne.tx.BaseTransaction;
import org.apache.cayenne.tx.Transaction;
import org.apache.cayenne.util.GenericResponse;
import org.apache.cayenne.util.ListResponse;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DataDomainQueryAction
implements QueryRouter,
OperationObserver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataDomainQueryAction.class);
    private static final boolean DONE = true;
    private final DataContext context;
    final DataDomain domain;
    final Query query;
    private final QueryMetadata metadata;
    private final AdhocObjectFactory objectFactory;
    private DataRowStore cache;
    private QueryResponse response;
    private GenericResponse fullResponse;
    private Map<CayennePath, List<?>> prefetchResultsByPath;
    private Map<QueryEngine, Collection<Query>> queriesByNode;
    private boolean noObjectConversion;
    private boolean cachedResult;

    DataDomainQueryAction(ObjectContext context, DataDomain domain, Query query) {
        if (context != null && !(context instanceof DataContext)) {
            throw new IllegalArgumentException("DataDomain can only work with DataContext. Unsupported context type: " + context);
        }
        this.domain = domain;
        this.query = query;
        this.metadata = query.getMetaData(domain.getEntityResolver());
        this.context = (DataContext)context;
        this.objectFactory = domain.getObjectFactory();
        if (context != null) {
            this.cache = this.context.getObjectStore().getDataRowCache();
        }
        if (this.cache == null) {
            this.cache = domain.getSharedSnapshotCache();
        }
    }

    QueryResponse execute() {
        if (!(this.interceptIteratedQuery() || this.interceptOIDQuery() || this.interceptRelationshipQuery() || this.interceptRefreshQuery() || this.interceptSharedCache() || this.interceptDataDomainQuery())) {
            this.runQueryInTransaction();
        }
        this.interceptObjectConversion();
        return this.response;
    }

    private boolean interceptIteratedQuery() {
        if (this.query instanceof IteratedQueryDecorator) {
            this.noObjectConversion = ((IteratedQueryDecorator)this.query).isFetchingDataRows();
            this.validateIteratedQuery();
            this.performIteratedQuery();
            return true;
        }
        return false;
    }

    private void validateIteratedQuery() {
        if (this.metadata.getPageSize() > 0) {
            throw new CayenneRuntimeException("Pagination is not supported with iterator", new Object[0]);
        }
        if (this.metadata.getPrefetchTree() != null) {
            for (PrefetchTreeNode prefetchTreeNode : this.metadata.getPrefetchTree().getChildren()) {
                if (prefetchTreeNode.isDisjointPrefetch()) {
                    throw new CayenneRuntimeException("\"Disjoint\" semantic doesn't work with iterator. Use \"Joint\" instead", new Object[0]);
                }
                if (!prefetchTreeNode.isDisjointByIdPrefetch()) continue;
                LOGGER.warn("A separate select query will be created for each iterated item");
            }
        }
    }

    private void performIteratedQuery() {
        Transaction tx = BaseTransaction.getThreadTransaction();
        if (tx != null) {
            this.runIteratedQuery(tx);
        } else {
            tx = this.context.getTransactionFactory().createTransaction();
            BaseTransaction.bindThreadTransaction(tx);
            try {
                this.runIteratedQuery(tx);
            }
            catch (Exception e) {
                throw new CayenneRuntimeException(e);
            }
            finally {
                BaseTransaction.bindThreadTransaction(null);
                if (tx.isRollbackOnly()) {
                    try {
                        tx.rollback();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private boolean interceptDataDomainQuery() {
        if (this.query instanceof DataDomainQuery) {
            this.response = new ListResponse(this.domain);
            return true;
        }
        return false;
    }

    private boolean interceptOIDQuery() {
        if (this.query instanceof ObjectIdQuery) {
            ObjectIdQuery oidQuery = (ObjectIdQuery)this.query;
            ObjectId oid = oidQuery.getObjectId();
            if (oid.isTemporary() && !oid.isReplacementIdAttached()) {
                this.response = new ListResponse();
                return true;
            }
            DataRow row = null;
            if (this.cache != null && !oidQuery.isFetchMandatory()) {
                row = this.polymorphicRowFromCache(oid);
            }
            if (row == null) {
                if (oidQuery.isFetchAllowed()) {
                    this.runQueryInTransaction();
                } else {
                    this.response = new ListResponse();
                }
            } else {
                this.response = new ListResponse(row);
            }
            return true;
        }
        return false;
    }

    private DataRow polymorphicRowFromCache(ObjectId superOid) {
        DataRow row = this.cache.getCachedSnapshot(superOid);
        if (row != null) {
            return row;
        }
        EntityInheritanceTree inheritanceTree = this.domain.getEntityResolver().getInheritanceTree(superOid.getEntityName());
        if (!inheritanceTree.getChildren().isEmpty()) {
            row = this.polymorphicRowFromCache(inheritanceTree, superOid);
        }
        return row;
    }

    private DataRow polymorphicRowFromCache(EntityInheritanceTree superNode, ObjectId superOid) {
        for (EntityInheritanceTree child : superNode.getChildren()) {
            ObjectId id = ObjectId.of(child.getEntity().getName(), superOid);
            DataRow row = this.cache.getCachedSnapshot(id);
            if (row != null) {
                return row;
            }
            row = this.polymorphicRowFromCache(child, superOid);
            if (row == null) continue;
            return row;
        }
        return null;
    }

    private boolean interceptRelationshipQuery() {
        if (this.query instanceof RelationshipQuery) {
            RelationshipQuery relationshipQuery = (RelationshipQuery)this.query;
            if (relationshipQuery.isRefreshing()) {
                return false;
            }
            ObjRelationship relationship = relationshipQuery.getRelationship(this.domain.getEntityResolver());
            if (relationship.isSourceIndependentFromTargetChange()) {
                return false;
            }
            DbRelationship dbRelationship = relationship.getDbRelationships().get(0);
            DbEntity targetEntity = dbRelationship.getTargetEntity();
            if (dbRelationship.getJoins().size() < targetEntity.getPrimaryKeys().size()) {
                return false;
            }
            if (this.cache == null) {
                return false;
            }
            DataRow sourceRow = this.cache.getCachedSnapshot(relationshipQuery.getObjectId());
            if (sourceRow == null) {
                return false;
            }
            ObjectId targetId = sourceRow.createTargetObjectId(relationship.getTargetEntityName(), dbRelationship);
            if (targetId == null) {
                this.response = new GenericResponse(Collections.emptyList());
                return true;
            }
            DataRow targetRow = this.polymorphicRowFromCache(targetId);
            if (targetRow != null) {
                this.response = new GenericResponse(Collections.singletonList(targetRow));
                return true;
            }
            if (this.context != null && relationship.isSourceDefiningTargetPrecenseAndType(this.domain.getEntityResolver())) {
                this.noObjectConversion = true;
                Persistent object = this.context.findOrCreateObject(targetId);
                this.response = new GenericResponse(Collections.singletonList(object));
                return true;
            }
        }
        return false;
    }

    private boolean interceptRefreshQuery() {
        if (this.query instanceof RefreshQuery) {
            RefreshQuery refreshQuery = (RefreshQuery)this.query;
            if (refreshQuery.isRefreshAll()) {
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().clear();
                } else {
                    this.context.getObjectStore().getDataRowCache().clear();
                }
                this.context.getQueryCache().clear();
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            Collection<?> objects = refreshQuery.getObjects();
            if (objects != null && !objects.isEmpty()) {
                ArrayList<ObjectId> ids = new ArrayList<ObjectId>(objects.size());
                for (Persistent object : objects) {
                    ids.add(object.getObjectId());
                }
                if (this.domain.getSharedSnapshotCache() != null) {
                    this.domain.getSharedSnapshotCache().processSnapshotChanges(this.context.getObjectStore(), Collections.emptyMap(), Collections.emptyList(), ids, Collections.emptyList());
                } else {
                    this.context.getObjectStore().getDataRowCache().processSnapshotChanges(this.context.getObjectStore(), Collections.emptyMap(), Collections.emptyList(), ids, Collections.emptyList());
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
            if (refreshQuery.getQuery() != null) {
                Query cachedQuery = refreshQuery.getQuery();
                String cacheKey = cachedQuery.getMetaData(this.context.getEntityResolver()).getCacheKey();
                this.context.getQueryCache().remove(cacheKey);
                this.response = this.domain.onQuery(this.context, cachedQuery);
                return true;
            }
            if (refreshQuery.getGroupKeys() != null && refreshQuery.getGroupKeys().length > 0) {
                String[] groups;
                for (String group : groups = refreshQuery.getGroupKeys()) {
                    this.domain.getQueryCache().removeGroup(group);
                }
                GenericResponse response = new GenericResponse();
                response.addUpdateCount(1);
                this.response = response;
                return true;
            }
        }
        return false;
    }

    private boolean interceptSharedCache() {
        boolean cacheOrCacheRefresh;
        if (this.metadata.getCacheKey() == null) {
            return false;
        }
        boolean cache = QueryCacheStrategy.SHARED_CACHE == this.metadata.getCacheStrategy();
        boolean bl = cacheOrCacheRefresh = cache || QueryCacheStrategy.SHARED_CACHE_REFRESH == this.metadata.getCacheStrategy();
        if (!cacheOrCacheRefresh) {
            return false;
        }
        QueryCache queryCache = this.domain.getQueryCache();
        QueryCacheEntryFactory factory = this.getCacheObjectFactory();
        if (cache) {
            boolean wasResponseNull = this.response == null;
            List cachedResults = queryCache.get(this.metadata, factory);
            if (this.response == null || wasResponseNull) {
                this.response = new ListResponse(cachedResults);
            }
            if (cachedResults instanceof ListWithPrefetches) {
                this.prefetchResultsByPath = ((ListWithPrefetches)cachedResults).getPrefetchResultsByPath();
            }
        } else {
            queryCache.put(this.metadata, factory.createObject());
        }
        this.cachedResult = true;
        return true;
    }

    private QueryCacheEntryFactory getCacheObjectFactory() {
        return () -> {
            this.runQueryInTransaction();
            ListWithPrefetches list = this.response.firstList();
            if (list != null) {
                list = Collections.unmodifiableList(list);
                if (this.prefetchResultsByPath != null) {
                    list = new ListWithPrefetches(list, this.prefetchResultsByPath);
                }
            }
            return list;
        };
    }

    void runQueryInTransaction() {
        this.domain.getTransactionManager().performInTransaction(() -> {
            this.runQuery();
            return null;
        });
    }

    private void runQuery() {
        this.fullResponse = new GenericResponse();
        this.response = this.fullResponse;
        this.queriesByNode = null;
        this.prefetchResultsByPath = this.metadata.getPrefetchTree() != null && !this.metadata.isFetchingDataRows() ? new HashMap() : null;
        this.query.route(this, this.domain.getEntityResolver(), null);
        if (this.queriesByNode != null) {
            for (Map.Entry<QueryEngine, Collection<Query>> entry : this.queriesByNode.entrySet()) {
                QueryEngine nextNode = entry.getKey();
                Collection<Query> nodeQueries = entry.getValue();
                nextNode.performQueries(nodeQueries, this);
            }
        }
    }

    private void runIteratedQuery(Transaction tx) {
        this.runQuery();
        ResultIterator<?> iterator = this.fullResponse.firstIterator();
        if (iterator == null) {
            throw new IllegalStateException("Iterator response expected");
        }
        this.fullResponse.replaceResult(iterator, new TransactionResultIteratorDecorator(iterator, tx));
        this.fullResponse.reset();
    }

    private void interceptObjectConversion() {
        if (this.noObjectConversion()) {
            return;
        }
        ObjectConversionStrategy<?, ?> converter = this.getConverter();
        QueryResponse response = this.response;
        response.reset();
        while (response.next()) {
            if (response.isList()) {
                Object result;
                List<?> mainRows = response.currentList();
                if (mainRows == null || mainRows.isEmpty() || (result = converter.convert(mainRows)) == mainRows) continue;
                this.updateResponse((List)mainRows, (List)result);
                continue;
            }
            if (!response.isIterator()) continue;
            ResultIterator<?> iterator = this.fullResponse.currentIterator();
            this.fullResponse.replaceResult(iterator, new ResultIteratorConverterDecorator(iterator, converter));
        }
        response.reset();
    }

    private boolean noObjectConversion() {
        return this.context == null || this.noObjectConversion || this.metadata.getPageSize() > 0;
    }

    private ObjectConversionStrategy<?, ?> getConverter() {
        List<Object> rsMapping;
        ObjectConversionStrategy converter = this.metadata.isFetchingDataRows() ? new IdentityConversionStrategy() : ((rsMapping = this.metadata.getResultSetMapping()) == null ? new SingleObjectConversionStrategy() : (this.metadata.isSingleResultSetMapping() ? (rsMapping.get(0) instanceof EntityResultSegment ? new SingleObjectConversionStrategy() : (rsMapping.get(0) instanceof EmbeddableResultSegment ? new SingleEmbeddableConversionStrategy() : new SingleScalarConversionStrategy())) : new MixedConversionStrategy()));
        if (this.metadata.getResultMapper() != null) {
            converter = new MapperConversionStrategy(converter);
        }
        return converter;
    }

    @Override
    public void route(QueryEngine engine, Query query, Query substitutedQuery) {
        Collection<Query> queries = null;
        if (this.queriesByNode == null) {
            this.queriesByNode = new HashMap<QueryEngine, Collection<Query>>();
        } else {
            queries = this.queriesByNode.get(engine);
        }
        if (queries == null) {
            queries = new ArrayList<Query>(5);
            this.queriesByNode.put(engine, queries);
        }
        queries.add(query);
    }

    @Override
    public QueryEngine engineForDataMap(DataMap map) {
        if (map == null) {
            throw new NullPointerException("Null DataMap, can't determine DataNode.");
        }
        DataNode node = this.domain.lookupDataNode(map);
        if (node == null) {
            throw new CayenneRuntimeException("No DataNode exists for DataMap %s", map);
        }
        return node;
    }

    @Override
    public QueryEngine engineForName(String name) {
        DataNode node;
        if (name != null) {
            node = this.domain.getDataNode(name);
            if (node == null) {
                throw new CayenneRuntimeException("No DataNode exists for name %s", name);
            }
        } else {
            node = this.domain.getDefaultNode();
            if (node == null) {
                throw new CayenneRuntimeException("No default DataNode exists.", new Object[0]);
            }
        }
        return node;
    }

    @Override
    public void nextCount(Query query, int resultCount) {
        this.fullResponse.addUpdateCount(resultCount);
    }

    @Override
    public void nextBatchCount(Query query, int[] resultCount) {
        this.fullResponse.addBatchUpdateCount(resultCount);
    }

    @Override
    public void nextRows(Query query, List<?> dataRows) {
        if (this.prefetchResultsByPath != null && query instanceof PrefetchSelectQuery) {
            PrefetchSelectQuery prefetchQuery = (PrefetchSelectQuery)query;
            this.prefetchResultsByPath.put(prefetchQuery.getPrefetchPath(), dataRows);
        } else {
            this.fullResponse.addResultList(dataRows);
        }
    }

    @Override
    public void nextRows(Query q, ResultIterator<?> it) {
        if (this.prefetchResultsByPath != null && this.query instanceof PrefetchSelectQuery) {
            PrefetchSelectQuery prefetchQuery = (PrefetchSelectQuery)this.query;
            this.prefetchResultsByPath.put(prefetchQuery.getPrefetchPath(), (List)((Object)it));
        } else {
            this.fullResponse.addResultIterator(it);
        }
    }

    @Override
    public void nextGeneratedRows(Query query, ResultIterator<?> keys, List<ObjectId> idsToUpdate) {
        if (keys != null) {
            try (ResultIterator<?> resultIterator = keys;){
                this.nextRows(query, keys.allRows());
            }
        }
    }

    @Override
    public void nextQueryException(Query query, Exception ex) {
        throw new CayenneRuntimeException("Query exception.", Util.unwindException(ex), new Object[0]);
    }

    @Override
    public void nextGlobalException(Exception e) {
        throw new CayenneRuntimeException("Global exception.", Util.unwindException(e), new Object[0]);
    }

    @Override
    public boolean isIteratedResult() {
        return this.query instanceof IteratedQueryDecorator;
    }

    protected <T, R> void updateResponse(List<T> sourceObjects, List<? extends R> targetObjects) {
        if (this.response instanceof GenericResponse) {
            ((GenericResponse)this.response).replaceResult(sourceObjects, targetObjects);
        } else if (this.response instanceof ListResponse) {
            this.response = new ListResponse(targetObjects);
        } else {
            throw new IllegalStateException("Unknown response object: " + this.response);
        }
    }

    abstract class ObjectConversionStrategy<T, R> {
        ObjectConversionStrategy() {
        }

        abstract List<? extends R> convert(List<T> var1);

        abstract R convert(T var1);

        protected PrefetchProcessorNode toResultsTree(ClassDescriptor descriptor, PrefetchTreeNode prefetchTree, List<DataRow> normalizedRows) {
            if (prefetchTree == null) {
                return new ObjectResolver(DataDomainQueryAction.this.context, descriptor, DataDomainQueryAction.this.metadata.isRefreshingObjects()).synchronizedRootResultNodeFromDataRows(normalizedRows);
            }
            HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(DataDomainQueryAction.this.context, DataDomainQueryAction.this.metadata);
            return resolver.synchronizedRootResultNodeFromDataRows(prefetchTree, normalizedRows, DataDomainQueryAction.this.prefetchResultsByPath);
        }

        protected void performPostLoadCallbacks(PrefetchProcessorNode node, LifecycleCallbackRegistry callbackRegistry) {
            List<Persistent> objects;
            if (node.hasChildren()) {
                for (PrefetchTreeNode child : node.getChildren()) {
                    this.performPostLoadCallbacks((PrefetchProcessorNode)child, callbackRegistry);
                }
            }
            if ((objects = node.getObjects()) != null) {
                callbackRegistry.performCallbacks(LifecycleEvent.POST_LOAD, objects);
            }
        }
    }

    private class IdentityConversionStrategy
    extends ObjectConversionStrategy<Object, Object> {
        private IdentityConversionStrategy() {
        }

        @Override
        List<Object> convert(List<Object> mainRows) {
            return mainRows;
        }

        @Override
        public Object convert(Object object) {
            return object;
        }
    }

    class SingleObjectConversionStrategy
    extends ObjectConversionStrategy<DataRow, Persistent> {
        SingleObjectConversionStrategy() {
        }

        @Override
        public List<Persistent> convert(List<DataRow> mainRows) {
            PrefetchProcessorNode node = this.getPrefetchProcessorNode(mainRows);
            ArrayList objects = node.getObjects();
            LifecycleCallbackRegistry callbackRegistry = DataDomainQueryAction.this.context.getEntityResolver().getCallbackRegistry();
            if (!callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD)) {
                this.performPostLoadCallbacks(node, callbackRegistry);
            }
            return objects != null ? objects : new ArrayList(1);
        }

        @Override
        Persistent convert(DataRow dataRow) {
            PrefetchProcessorNode node = this.getPrefetchProcessorNode(Collections.singletonList(dataRow));
            return node.getObjects().get(0);
        }

        private PrefetchProcessorNode getPrefetchProcessorNode(List<DataRow> mainRows) {
            PrefetchTreeNode prefetchTree = DataDomainQueryAction.this.metadata.getPrefetchTree();
            List<Object> rsMapping = DataDomainQueryAction.this.metadata.getResultSetMapping();
            EntityResultSegment resultSegment = null;
            if (rsMapping != null && !rsMapping.isEmpty()) {
                resultSegment = (EntityResultSegment)rsMapping.get(0);
            }
            ClassDescriptor descriptor = resultSegment == null ? DataDomainQueryAction.this.metadata.getClassDescriptor() : resultSegment.getClassDescriptor();
            return this.toResultsTree(descriptor, prefetchTree, mainRows);
        }
    }

    class SingleEmbeddableConversionStrategy
    extends ObjectConversionStrategy<DataRow, EmbeddableObject> {
        SingleEmbeddableConversionStrategy() {
        }

        @Override
        List<EmbeddableObject> convert(List<DataRow> mainRows) {
            EmbeddableResultSegment resultSegment = (EmbeddableResultSegment)DataDomainQueryAction.this.metadata.getResultSetMapping().get(0);
            Embeddable embeddable = resultSegment.getEmbeddable();
            Class embeddableClass = DataDomainQueryAction.this.objectFactory.getJavaClass(embeddable.getClassName());
            ArrayList<EmbeddableObject> result = new ArrayList<EmbeddableObject>(mainRows.size());
            mainRows.forEach(dataRow -> {
                EmbeddableObject eo;
                try {
                    eo = (EmbeddableObject)embeddableClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new CayenneRuntimeException("Unable to materialize embeddable '%s'", (Throwable)e, embeddable.getClassName());
                }
                dataRow.forEach(eo::writePropertyDirectly);
                result.add(eo);
            });
            return result;
        }

        @Override
        EmbeddableObject convert(DataRow dataRow) {
            return this.convert(Collections.singletonList(dataRow)).get(0);
        }
    }

    class SingleScalarConversionStrategy
    extends ObjectConversionStrategy<Object, Object> {
        SingleScalarConversionStrategy() {
        }

        @Override
        List<Object> convert(List<Object> mainRows) {
            return mainRows;
        }

        @Override
        Object convert(Object o) {
            return o;
        }
    }

    class MixedConversionStrategy
    extends ObjectConversionStrategy<Object[], Object[]> {
        MixedConversionStrategy() {
        }

        @Override
        List<Object[]> convert(List<Object[]> mainRows) {
            if (mainRows.isEmpty()) {
                return mainRows;
            }
            boolean needConversion = this.needConversion();
            List<Object[]> result = this.createResultList(mainRows, needConversion);
            if (needConversion) {
                List<PrefetchProcessorNode> segmentNodes = this.doInPlaceConversion(result);
                LifecycleCallbackRegistry callbackRegistry = DataDomainQueryAction.this.context.getEntityResolver().getCallbackRegistry();
                if (!callbackRegistry.isEmpty(LifecycleEvent.POST_LOAD)) {
                    for (PrefetchProcessorNode node : segmentNodes) {
                        this.performPostLoadCallbacks(node, callbackRegistry);
                    }
                }
            }
            if (!DataDomainQueryAction.this.metadata.isSuppressingDistinct()) {
                HashSet seen = new HashSet(result.size());
                result.removeIf(objects -> !seen.add(Arrays.asList(objects)));
            }
            return result;
        }

        @Override
        Object[] convert(Object[] objectsArray) {
            ArrayList<Object[]> objects = new ArrayList<Object[]>(1);
            objects.add(objectsArray);
            return this.convert((List<Object[]>)objects).get(0);
        }

        private List<Object[]> createResultList(List<Object[]> mainRows, boolean needConversion) {
            if (!DataDomainQueryAction.this.cachedResult) {
                return mainRows;
            }
            if (!needConversion) {
                return new ArrayList<Object[]>(mainRows);
            }
            ArrayList<Object[]> result = new ArrayList<Object[]>(mainRows.size());
            for (Object[] row : mainRows) {
                result.add(Arrays.copyOf(row, DataDomainQueryAction.this.metadata.getResultSetMapping().size()));
            }
            return result;
        }

        protected PrefetchProcessorNode toResultsTree(ClassDescriptor descriptor, PrefetchTreeNode prefetchTree, List<Object[]> rows, int position) {
            ArrayList<DataRow> rowsColumn = new ArrayList<DataRow>(rows.size());
            for (Object[] row : rows) {
                rowsColumn.add((DataRow)row[position]);
            }
            if (prefetchTree != null) {
                PrefetchTreeNode prefetchTreeNode = null;
                for (PrefetchTreeNode prefetch : prefetchTree.getChildren()) {
                    if (!descriptor.getEntity().getName().equals(prefetch.getEntityName())) continue;
                    if (prefetchTreeNode == null) {
                        prefetchTreeNode = new PrefetchTreeNode();
                    }
                    PrefetchTreeNode addPath = prefetchTreeNode.addPath(prefetch.getPath());
                    addPath.setSemantics(prefetch.getSemantics());
                    addPath.setPhantom(false);
                }
                prefetchTree = prefetchTreeNode;
            }
            if (prefetchTree == null) {
                return new ObjectResolver(DataDomainQueryAction.this.context, descriptor, DataDomainQueryAction.this.metadata.isRefreshingObjects()).synchronizedRootResultNodeFromDataRows(rowsColumn);
            }
            HierarchicalObjectResolver resolver = new HierarchicalObjectResolver(DataDomainQueryAction.this.context, DataDomainQueryAction.this.metadata, descriptor, true);
            return resolver.synchronizedRootResultNodeFromDataRows(prefetchTree, rowsColumn, DataDomainQueryAction.this.prefetchResultsByPath);
        }

        private List<PrefetchProcessorNode> doInPlaceConversion(List<Object[]> result) {
            List<Object> resultSetMapping = DataDomainQueryAction.this.metadata.getResultSetMapping();
            int width = resultSetMapping.size();
            int height = result.size();
            ArrayList<PrefetchProcessorNode> segmentNodes = new ArrayList<PrefetchProcessorNode>(width);
            for (int i = 0; i < width; ++i) {
                Object mapping = resultSetMapping.get(i);
                if (mapping instanceof EntityResultSegment) {
                    EntityResultSegment entitySegment = (EntityResultSegment)mapping;
                    PrefetchProcessorNode nextResult = this.toResultsTree(entitySegment.getClassDescriptor(), DataDomainQueryAction.this.metadata.getPrefetchTree(), result, i);
                    segmentNodes.add(nextResult);
                    List<Persistent> objects = nextResult.getObjects();
                    for (int j = 0; j < height; ++j) {
                        Object[] row = result.get(j);
                        row[i] = objects.get(j);
                    }
                    continue;
                }
                if (!(mapping instanceof EmbeddableResultSegment)) continue;
                EmbeddableResultSegment resultSegment = (EmbeddableResultSegment)mapping;
                Embeddable embeddable = resultSegment.getEmbeddable();
                Class embeddableClass = DataDomainQueryAction.this.objectFactory.getJavaClass(embeddable.getClassName());
                try {
                    Constructor declaredConstructor = embeddableClass.getDeclaredConstructor(new Class[0]);
                    for (Object[] row : result) {
                        DataRow dataRow = (DataRow)row[i];
                        EmbeddableObject eo = (EmbeddableObject)declaredConstructor.newInstance(new Object[0]);
                        dataRow.forEach(eo::writePropertyDirectly);
                        row[i] = eo;
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new CayenneRuntimeException("Unable to materialize embeddable '%s'", (Throwable)e, embeddable.getClassName());
                }
            }
            return segmentNodes;
        }

        private boolean needConversion() {
            for (Object mapping : DataDomainQueryAction.this.metadata.getResultSetMapping()) {
                if (!(mapping instanceof EntityResultSegment) && !(mapping instanceof EmbeddableResultSegment)) continue;
                return true;
            }
            return false;
        }
    }

    private class MapperConversionStrategy
    extends ObjectConversionStrategy<Object, Object> {
        private final Function<Object, ?> mapper;
        private final ObjectConversionStrategy<Object, Object> parentStrategy;

        MapperConversionStrategy(ObjectConversionStrategy<?, ?> parentStrategy) {
            this.mapper = DataDomainQueryAction.this.metadata.getResultMapper();
            this.parentStrategy = parentStrategy;
        }

        @Override
        List<Object> convert(List<Object> mainRows) {
            this.parentStrategy.convert((Object)mainRows);
            mainRows.replaceAll(this.mapper::apply);
            return mainRows;
        }

        @Override
        Object convert(Object object) {
            return this.mapper.apply(this.parentStrategy.convert(object));
        }
    }
}

