/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import org.apache.cayenne.access.sqlbuilder.AliasedNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.ColumnNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.DeleteBuilder;
import org.apache.cayenne.access.sqlbuilder.ExistsNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.ExpressionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.FunctionNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.InsertBuilder;
import org.apache.cayenne.access.sqlbuilder.JoinNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.JoinType;
import org.apache.cayenne.access.sqlbuilder.NodeBuilder;
import org.apache.cayenne.access.sqlbuilder.OrderingNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.SelectBuilder;
import org.apache.cayenne.access.sqlbuilder.TableNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.UpdateBuilder;
import org.apache.cayenne.access.sqlbuilder.ValueNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.AliasedNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.FunctionNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.NodeType;
import org.apache.cayenne.access.sqlbuilder.sqltree.SimpleNodeTreeVisitor;
import org.apache.cayenne.access.sqlbuilder.sqltree.TextNode;
import org.apache.cayenne.map.DbEntity;

public final class SQLBuilder {
    public static SelectBuilder select(NodeBuilder ... params) {
        return new SelectBuilder(params);
    }

    public static InsertBuilder insert(String table) {
        return new InsertBuilder(table);
    }

    public static InsertBuilder insert(DbEntity table) {
        return new InsertBuilder(table);
    }

    public static UpdateBuilder update(String table) {
        return new UpdateBuilder(table);
    }

    public static UpdateBuilder update(DbEntity table) {
        return new UpdateBuilder(table);
    }

    public static DeleteBuilder delete(String table) {
        return new DeleteBuilder(table);
    }

    public static DeleteBuilder delete(DbEntity table) {
        return new DeleteBuilder(table);
    }

    public static TableNodeBuilder table(String table) {
        return new TableNodeBuilder(table);
    }

    public static TableNodeBuilder table(DbEntity table) {
        return new TableNodeBuilder(table);
    }

    public static ColumnNodeBuilder column(String column) {
        return new ColumnNodeBuilder(null, column);
    }

    public static JoinNodeBuilder join(NodeBuilder table) {
        return new JoinNodeBuilder(JoinType.INNER, table);
    }

    public static JoinNodeBuilder leftJoin(NodeBuilder table) {
        return new JoinNodeBuilder(JoinType.LEFT, table);
    }

    public static JoinNodeBuilder rightJoin(NodeBuilder table) {
        return new JoinNodeBuilder(JoinType.RIGHT, table);
    }

    public static JoinNodeBuilder innerJoin(NodeBuilder table) {
        return new JoinNodeBuilder(JoinType.INNER, table);
    }

    public static JoinNodeBuilder outerJoin(NodeBuilder table) {
        return new JoinNodeBuilder(JoinType.OUTER, table);
    }

    public static ExpressionNodeBuilder exists(NodeBuilder builder) {
        return new ExpressionNodeBuilder(new ExistsNodeBuilder(builder));
    }

    public static ValueNodeBuilder value(Object value) {
        return new ValueNodeBuilder(value);
    }

    public static ExpressionNodeBuilder exp(NodeBuilder builder) {
        return new ExpressionNodeBuilder(builder);
    }

    public static NodeBuilder node(Node node) {
        return () -> node;
    }

    public static NodeBuilder aliased(NodeBuilder nodeBuilder, String alias) {
        return new AliasedNodeBuilder(nodeBuilder, alias);
    }

    public static NodeBuilder aliased(Node node, String alias) {
        if (SQLBuilder.suppressAlias(node)) {
            return SQLBuilder.node(node);
        }
        if (node instanceof FunctionNode) {
            ((FunctionNode)node).setAlias(alias);
            return SQLBuilder.node(node);
        }
        if (node instanceof ColumnNode) {
            ((ColumnNode)node).setAlias(alias);
            return SQLBuilder.node(node);
        }
        return new AliasedNodeBuilder(SQLBuilder.node(node), alias);
    }

    public static NodeBuilder text(String text) {
        return () -> new TextNode(text);
    }

    public static NodeBuilder all() {
        return SQLBuilder.text(" *");
    }

    public static ExpressionNodeBuilder not(NodeBuilder value) {
        return new ExpressionNodeBuilder(value).not();
    }

    public static FunctionNodeBuilder count(NodeBuilder value) {
        return SQLBuilder.function("COUNT", value);
    }

    public static FunctionNodeBuilder count() {
        return SQLBuilder.function("COUNT", SQLBuilder.column("*"));
    }

    public static FunctionNodeBuilder avg(NodeBuilder value) {
        return SQLBuilder.function("AVG", value);
    }

    public static FunctionNodeBuilder min(NodeBuilder value) {
        return SQLBuilder.function("MIN", value);
    }

    public static FunctionNodeBuilder max(NodeBuilder value) {
        return SQLBuilder.function("MAX", value);
    }

    public static FunctionNodeBuilder function(String function, NodeBuilder ... values) {
        return new FunctionNodeBuilder(function, values);
    }

    public static OrderingNodeBuilder order(NodeBuilder expression) {
        return new OrderingNodeBuilder(expression);
    }

    private SQLBuilder() {
    }

    private static boolean suppressAlias(Node node) {
        return new SuppressAliasChecker().shouldSuppressForNode(node);
    }

    private static class SuppressAliasChecker
    extends SimpleNodeTreeVisitor {
        private boolean suppressAlias;

        private SuppressAliasChecker() {
        }

        public boolean shouldSuppressForNode(Node node) {
            node.visit(this);
            return this.suppressAlias;
        }

        @Override
        public boolean onNodeStart(Node node) {
            if (node.getType() == NodeType.COLUMN && ((ColumnNode)node).getAlias() != null) {
                this.suppressAlias = true;
                return false;
            }
            if (node.getType() == NodeType.FUNCTION && ((FunctionNode)node).getAlias() != null) {
                this.suppressAlias = true;
                return false;
            }
            if (node instanceof AliasedNode) {
                this.suppressAlias = true;
                return false;
            }
            return true;
        }
    }
}

