/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.sql.DataSource;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.modeler.ClassLoadingService;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizardView;
import org.apache.cayenne.modeler.dialog.pref.GeneralPreferences;
import org.apache.cayenne.modeler.dialog.pref.PreferenceDialog;
import org.apache.cayenne.modeler.event.DataSourceModificationEvent;
import org.apache.cayenne.modeler.event.DataSourceModificationListener;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.modeler.pref.DataMapDefaults;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.swing.ObjectBinding;

public class DataSourceWizard
extends CayenneController {
    private DataSourceWizardView view;
    private ObjectBinding dataSourceBinding;
    private Map<String, DBConnectionInfo> dataSources;
    private String dataSourceKey;
    private ProjectController projectController;
    private DBConnectionInfo connectionInfo;
    private boolean canceled;
    private DataSourceModificationListener dataSourceListener;
    private DbAdapter adapter;
    private DataSource dataSource;

    public DataSourceWizard(CayenneController parent, String title) {
        super(parent);
        this.view = this.createView(title);
        this.view.setTitle(title);
        this.connectionInfo = new DBConnectionInfo();
        this.projectController = (ProjectController)parent;
        this.initBindings();
        this.initDataSourceListener();
    }

    private String[] getLabelsForDialog(String viewTitle) {
        switch (viewTitle) {
            case "Configure Connection to Database": {
                return new String[]{"Save", "Cancel"};
            }
        }
        return new String[]{"Continue", "Cancel"};
    }

    private DataSourceWizardView createView(String viewTitle) {
        String[] labels = this.getLabelsForDialog(viewTitle);
        return new DataSourceWizardView(this, labels);
    }

    protected void initBindings() {
        BindingBuilder builder = new BindingBuilder(this.getApplication().getBindingFactory(), this);
        this.dataSourceBinding = builder.bindToComboSelection(this.view.getDataSources(), "dataSourceKey");
        builder.bindToAction(this.view.getCancelButton(), "cancelAction()");
        builder.bindToAction(this.view.getOkButton(), "okAction()");
        builder.bindToAction(this.view.getConfigButton(), "dataSourceConfigAction()");
    }

    private void initDataSourceListener() {
        this.dataSourceListener = new DataSourceModificationListener(){

            @Override
            public void callbackDataSourceRemoved(DataSourceModificationEvent e) {
            }

            @Override
            public void callbackDataSourceAdded(DataSourceModificationEvent e) {
                DataSourceWizard.this.setDataSourceKey(e.getDataSourceName());
                DataSourceWizard.this.refreshDataSources();
            }
        };
        this.getApplication().getFrameController().getProjectController().addDataSourceModificationListener(this.dataSourceListener);
    }

    private void initFavouriteDataSource() {
        Preferences pref = this.getApplication().getPreferencesNode(GeneralPreferences.class, "");
        String favouriteDataSource = pref.get("favouriteDataSource", null);
        if (favouriteDataSource != null && this.dataSources.containsKey(favouriteDataSource)) {
            this.setDataSourceKey(favouriteDataSource);
            this.dataSourceBinding.updateView();
        }
    }

    private void removeDataSourceListener() {
        this.getApplication().getFrameController().getProjectController().removeDataSourceModificationListener(this.dataSourceListener);
    }

    private DBConnectionInfo getConnectionInfoFromPreferences() {
        DBConnectionInfo connectionInfo = new DBConnectionInfo();
        DataMapDefaults dataMapDefaults = this.projectController.getDataMapPreferences(this.projectController.getCurrentDataMap());
        connectionInfo.setDbAdapter(dataMapDefaults.getCurrentPreference().get("dbAdapter", null));
        connectionInfo.setUrl(dataMapDefaults.getCurrentPreference().get("url", null));
        connectionInfo.setUserName(dataMapDefaults.getCurrentPreference().get("userName", null));
        connectionInfo.setPassword(dataMapDefaults.getCurrentPreference().get("password", null));
        connectionInfo.setJdbcDriver(dataMapDefaults.getCurrentPreference().get("jdbcDriver", null));
        return connectionInfo;
    }

    public String getDataSourceKey() {
        return this.dataSourceKey;
    }

    public void setDataSourceKey(String dataSourceKey) {
        this.dataSourceKey = dataSourceKey;
        DBConnectionInfo currentInfo = this.dataSources.get(dataSourceKey);
        if (currentInfo != null) {
            currentInfo.copyTo(this.connectionInfo);
        } else {
            this.connectionInfo = new DBConnectionInfo();
        }
        this.view.getConnectionInfo().setConnectionInfo(this.connectionInfo);
    }

    public boolean startupAction() {
        this.canceled = true;
        this.refreshDataSources();
        this.initFavouriteDataSource();
        DataMapDefaults dataMapDefaults = this.projectController.getDataMapPreferences(this.projectController.getCurrentDataMap());
        if (dataMapDefaults.getCurrentPreference().get("dbAdapter", null) != null) {
            this.getConnectionInfoFromPreferences().copyTo(this.connectionInfo);
        }
        this.view.pack();
        this.view.setDefaultCloseOperation(2);
        this.view.setModal(true);
        this.view.connectionInfo.setConnectionInfo(this.connectionInfo);
        this.makeCloseableOnEscape();
        this.centerView();
        this.view.setVisible(true);
        return !this.canceled;
    }

    public DBConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void okAction() {
        DBConnectionInfo info = this.getConnectionInfo();
        ClassLoadingService classLoader = this.getApplication().getClassLoadingService();
        try {
            try {
                this.adapter = info.makeAdapter(classLoader);
                this.dataSource = info.makeDataSource(classLoader);
            }
            catch (SQLException ignore) {
                this.showNoConnectorDialog("Unable to load driver '" + info.getJdbcDriver() + "'");
                return;
            }
            Connection connection = this.dataSource.getConnection();
            if (connection != null) {
                connection.close();
            }
        }
        catch (Throwable th) {
            this.reportError("Connection Error", th);
            return;
        }
        this.onClose(false);
    }

    public void cancelAction() {
        this.onClose(true);
    }

    protected void onClose(boolean canceled) {
        this.canceled = canceled;
        this.view.dispose();
        this.removeDataSourceListener();
        if (!canceled) {
            Preferences pref = this.getApplication().getPreferencesNode(GeneralPreferences.class, "");
            pref.put("favouriteDataSource", this.getDataSourceKey());
        }
    }

    public void dataSourceConfigAction() {
        PreferenceDialog prefs = new PreferenceDialog(this);
        prefs.showDataSourceEditorAction(this.dataSourceKey);
        this.refreshDataSources();
    }

    public void classPathConfigAction() {
        PreferenceDialog prefs = new PreferenceDialog(this);
        prefs.showClassPathEditorAction();
        this.refreshDataSources();
    }

    @Override
    public Component getView() {
        return this.view;
    }

    private void refreshDataSources() {
        this.dataSources = this.getApplication().getCayenneProjectPreferences().getDetailObject(DBConnectionInfo.class).getChildrenPreferences();
        String _12package = "org.objectstyle.cayenne.";
        for (DBConnectionInfo info : this.dataSources.values()) {
            if (info.getDbAdapter() == null || !info.getDbAdapter().startsWith("org.objectstyle.cayenne.")) continue;
            info.setDbAdapter("org.apache.cayenne." + info.getDbAdapter().substring("org.objectstyle.cayenne.".length()));
        }
        Object[] keys = this.dataSources.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        this.view.getDataSources().setModel(new DefaultComboBoxModel<Object>(keys));
        Object key = null;
        if (!(this.getDataSourceKey() != null && this.dataSources.containsKey(this.getDataSourceKey()) || keys.length <= 0)) {
            key = keys[0];
        }
        this.setDataSourceKey((String)(key != null ? key : this.getDataSourceKey()));
        this.dataSourceBinding.updateView();
    }

    protected void showNoConnectorDialog(String message) {
        Object[] options = new String[]{"Setup driver", "Cancel"};
        int selection = JOptionPane.showOptionDialog(this.getView(), message, "Configuration error", 2, 0, null, options, options[0]);
        if (selection == 0) {
            this.classPathConfigAction();
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DbAdapter getAdapter() {
        return this.adapter;
    }
}

