/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.remote.ClientMessage;
import org.apache.cayenne.remote.RemoteService;
import org.apache.cayenne.remote.RemoteSession;
import org.apache.cayenne.rop.ROPConnector;
import org.apache.cayenne.rop.ROPSerializationService;

public class ProxyRemoteService
implements RemoteService {
    protected ROPSerializationService serializationService;
    protected ROPConnector ropConnector;

    public ProxyRemoteService(@Inject ROPSerializationService serializationService, @Inject ROPConnector ropConnector) {
        this.serializationService = serializationService;
        this.ropConnector = ropConnector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteSession establishSession() throws RemoteException {
        try (InputStream is = this.ropConnector.establishSession();){
            RemoteSession remoteSession = (RemoteSession)this.serializationService.deserialize(is, RemoteSession.class);
            return remoteSession;
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RemoteSession establishSharedSession(String name) throws RemoteException {
        try (InputStream is = this.ropConnector.establishSharedSession(name);){
            RemoteSession remoteSession = (RemoteSession)this.serializationService.deserialize(is, RemoteSession.class);
            return remoteSession;
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object processMessage(ClientMessage message) throws RemoteException, Throwable {
        try (InputStream is = this.ropConnector.sendMessage(this.serializationService.serialize((Object)message));){
            Object object = this.serializationService.deserialize(is, Object.class);
            return object;
        }
        catch (IOException e) {
            throw new RemoteException(e.getMessage(), e);
        }
    }

    public void close() throws RemoteException {
        try {
            this.ropConnector.close();
        }
        catch (IOException e) {
            throw new RemoteException("Exception while closing ROP resources", e);
        }
    }
}

