/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.io.File;
import java.sql.Connection;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.cayenne.configuration.ConfigurationNode;
import org.apache.cayenne.dbsync.naming.NameBuilder;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.DbImportConfiguration;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;
import org.apache.cayenne.dbsync.reverse.dbload.DbLoaderDelegate;
import org.apache.cayenne.dbsync.reverse.filters.FiltersConfigBuilder;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.db.DataSourceWizard;
import org.apache.cayenne.modeler.dialog.db.load.DbLoaderOptionsDialog;
import org.apache.cayenne.modeler.dialog.db.load.LoaderDelegate;
import org.apache.cayenne.modeler.pref.DBConnectionInfo;
import org.apache.cayenne.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbLoaderContext {
    private static Logger LOGGER = LoggerFactory.getLogger(DbLoaderContext.class);
    private DbImportConfiguration config;
    private Connection connection;
    private ProjectController projectController;
    private boolean existingMap;
    private DataMap dataMap;
    private boolean stopping;
    private String loadStatusNote;

    DataMap getDataMap() {
        return this.dataMap;
    }

    boolean isExistingDataMap() {
        return this.existingMap;
    }

    public void setProjectController(ProjectController projectController) {
        this.projectController = projectController;
    }

    ProjectController getProjectController() {
        return this.projectController;
    }

    void setConfig(DbImportConfiguration config) {
        this.config = config;
    }

    DbImportConfiguration getConfig() {
        return this.config;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public boolean isStopping() {
        return this.stopping;
    }

    void setStopping(boolean stopping) {
        this.stopping = stopping;
    }

    String getStatusNote() {
        return this.loadStatusNote;
    }

    void setStatusNote(String loadStatusNote) {
        this.loadStatusNote = loadStatusNote;
    }

    public boolean buildConfig(DataSourceWizard connectionWizard, DbLoaderOptionsDialog dialog) {
        if (dialog == null || connectionWizard == null) {
            return false;
        }
        ReverseEngineering reverseEngineering = new ReverseEngineering();
        reverseEngineering.addCatalog(new Catalog(dialog.getSelectedCatalog()));
        reverseEngineering.addSchema(new Schema(dialog.getSelectedSchema()));
        reverseEngineering.addIncludeTable(new IncludeTable(dialog.getTableIncludePattern()));
        if (dialog.getTableExcludePattern() != null) {
            reverseEngineering.addExcludeTable(new ExcludeTable(dialog.getTableExcludePattern()));
        }
        reverseEngineering.addExcludeTable(new ExcludeTable("auto_pk_support|AUTO_PK_SUPPORT"));
        reverseEngineering.addIncludeProcedure(new IncludeProcedure(dialog.getProcedureNamePattern()));
        FiltersConfigBuilder filtersConfigBuilder = new FiltersConfigBuilder(reverseEngineering);
        DbImportConfiguration config = new DbImportConfiguration(){

            @Override
            public DbLoaderDelegate createLoaderDelegate() {
                return new LoaderDelegate(DbLoaderContext.this);
            }
        };
        DBConnectionInfo connectionInfo = connectionWizard.getConnectionInfo();
        config.setAdapter(connectionWizard.getAdapter().getClass().getName());
        config.setUsername(connectionInfo.getUserName());
        config.setPassword(connectionInfo.getPassword());
        config.setDriver(connectionInfo.getJdbcDriver());
        config.setUrl(connectionInfo.getUrl());
        config.getDbLoaderConfig().setFiltersConfig(filtersConfigBuilder.build());
        config.setMeaningfulPkTables(dialog.getMeaningfulPk());
        config.setNamingStrategy(dialog.getNamingStrategy());
        config.setUsePrimitives(dialog.isUsePrimitives());
        config.setUseJava7Types(dialog.isUseJava7Typed());
        this.setConfig(config);
        this.prepareDataMap();
        return true;
    }

    private void prepareDataMap() {
        this.dataMap = this.getProjectController().getCurrentDataMap();
        boolean bl = this.existingMap = this.dataMap != null;
        if (!this.existingMap) {
            ConfigurationNode root = this.getProjectController().getProject().getRootNode();
            this.dataMap = new DataMap();
            this.dataMap.setName(NameBuilder.builder(this.dataMap, root).name());
        }
        if (this.dataMap.getConfigurationSource() != null) {
            this.getConfig().setTargetDataMap(new File(this.dataMap.getConfigurationSource().getURL().getPath()));
        }
    }

    public void processWarn(Throwable th, String message) {
        LOGGER.warn(message, Util.unwindException(th));
    }

    public void processException(final Throwable th, final String message) {
        LOGGER.info("Exception on reverse engineering", Util.unwindException(th));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(Application.getFrame(), th.getMessage(), message, 0);
            }
        });
    }
}

