package org.apache.cayenne.testdo.relationships.auto;

import java.util.List;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.exp.Property;
import org.apache.cayenne.testdo.relationships.FkOfDifferentType;
import org.apache.cayenne.testdo.relationships.MeaningfulFK;
import org.apache.cayenne.testdo.relationships.ReflexiveAndToOne;

/**
 * Class _RelationshipHelper was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _RelationshipHelper extends CayenneDataObject {

    private static final long serialVersionUID = 1L; 

    public static final String RELATIONSHIP_HELPER_ID_PK_COLUMN = "RELATIONSHIP_HELPER_ID";

    public static final Property<String> NAME = Property.create("name", String.class);
    public static final Property<List<FkOfDifferentType>> FKS_OF_DIFFERENT_TYPE = Property.create("fksOfDifferentType", List.class);
    public static final Property<List<MeaningfulFK>> MEANIGFUL_FKS = Property.create("meanigfulFKs", List.class);
    public static final Property<List<ReflexiveAndToOne>> REFLEXIVE_AND_TO_ONE_ARRAY = Property.create("reflexiveAndToOneArray", List.class);

    public void setName(String name) {
        writeProperty("name", name);
    }
    public String getName() {
        return (String)readProperty("name");
    }

    public void addToFksOfDifferentType(FkOfDifferentType obj) {
        addToManyTarget("fksOfDifferentType", obj, true);
    }
    public void removeFromFksOfDifferentType(FkOfDifferentType obj) {
        removeToManyTarget("fksOfDifferentType", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<FkOfDifferentType> getFksOfDifferentType() {
        return (List<FkOfDifferentType>)readProperty("fksOfDifferentType");
    }


    public void addToMeanigfulFKs(MeaningfulFK obj) {
        addToManyTarget("meanigfulFKs", obj, true);
    }
    public void removeFromMeanigfulFKs(MeaningfulFK obj) {
        removeToManyTarget("meanigfulFKs", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<MeaningfulFK> getMeanigfulFKs() {
        return (List<MeaningfulFK>)readProperty("meanigfulFKs");
    }


    public void addToReflexiveAndToOneArray(ReflexiveAndToOne obj) {
        addToManyTarget("reflexiveAndToOneArray", obj, true);
    }
    public void removeFromReflexiveAndToOneArray(ReflexiveAndToOne obj) {
        removeToManyTarget("reflexiveAndToOneArray", obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<ReflexiveAndToOne> getReflexiveAndToOneArray() {
        return (List<ReflexiveAndToOne>)readProperty("reflexiveAndToOneArray");
    }


}
