/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.response.TimeSkewResponse;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.utils.TimeProvider;

public class TimeSkewInfo {
    private final TimeProvider timeProvider;
    private final ServiceConfiguration configuration;

    @Inject
    public TimeSkewInfo(TimeProvider timeProvider, ServiceConfiguration configuration) {
        this.timeProvider = timeProvider;
        this.configuration = configuration;
    }

    public TimeSkewResponse timeSkewResponse() {
        int allowableTimeSkewInMinutes = (int)this.configuration.allowableTimeSkew().to(TimeUnit.MINUTES);
        return new TimeSkewResponse(this.timeProvider.currentTimeMillis(), allowableTimeSkewInMinutes);
    }
}

