/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.function.Function;
import org.apache.cassandra.sidecar.adapters.base.exception.OperationUnavailableException;
import org.apache.cassandra.sidecar.cluster.CassandraAdapterDelegate;
import org.apache.cassandra.sidecar.cluster.InstancesMetadata;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.exceptions.CassandraUnavailableException;
import org.apache.cassandra.sidecar.exceptions.NoSuchCassandraInstanceException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InstanceMetadataFetcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceMetadataFetcher.class);
    private final InstancesMetadata instancesMetadata;

    @Inject
    public InstanceMetadataFetcher(InstancesMetadata instancesMetadata) {
        this.instancesMetadata = instancesMetadata;
    }

    @NotNull
    public InstanceMetadata instance(@NotNull String host) throws NoSuchCassandraInstanceException {
        return this.instancesMetadata.instanceFromHost(host);
    }

    @NotNull
    public InstanceMetadata instance(int instanceId) throws NoSuchCassandraInstanceException {
        return this.instancesMetadata.instanceFromId(instanceId);
    }

    @NotNull
    public CassandraAdapterDelegate delegate(@NotNull String host) throws NoSuchCassandraInstanceException, CassandraUnavailableException {
        return this.instance(host).delegate();
    }

    @NotNull
    public <T> T callOnFirstAvailableInstance(Function<InstanceMetadata, T> function) throws CassandraUnavailableException {
        for (InstanceMetadata instance : this.allLocalInstances()) {
            try {
                return function.apply(instance);
            }
            catch (OperationUnavailableException | CassandraUnavailableException exception) {
                LOGGER.debug("CassandraAdapterDelegate is not available for instance. instance={}", (Object)instance, (Object)exception);
            }
        }
        throw new CassandraUnavailableException(CassandraUnavailableException.Service.CQL_AND_JMX, "All local Cassandra nodes are exhausted. But none is available");
    }

    public List<InstanceMetadata> allLocalInstances() {
        this.ensureInstancesMetadataConfigured();
        return this.instancesMetadata.instances();
    }

    private void ensureInstancesMetadataConfigured() {
        if (this.instancesMetadata.instances().isEmpty()) {
            throw new IllegalStateException("There are no instances configured!");
        }
    }
}

