/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.AsyncFile;
import io.vertx.core.file.FileSystem;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.web.handler.HttpException;
import java.io.IOException;
import java.util.Objects;
import org.apache.cassandra.sidecar.common.http.SidecarHttpResponseStatus;
import org.apache.cassandra.sidecar.common.request.data.Digest;
import org.apache.cassandra.sidecar.utils.DigestAlgorithm;
import org.apache.cassandra.sidecar.utils.DigestVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AsyncFileDigestVerifier<D extends Digest>
implements DigestVerifier {
    public static final int DEFAULT_READ_BUFFER_SIZE = 524288;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final FileSystem fs;
    protected final D digest;
    private final DigestAlgorithm digestAlgorithm;

    protected AsyncFileDigestVerifier(FileSystem fs, D digest, DigestAlgorithm digestAlgorithm) {
        this.fs = fs;
        this.digest = (Digest)Objects.requireNonNull(digest, "digest is required");
        this.digestAlgorithm = digestAlgorithm;
    }

    @Override
    public Future<String> verify(String filePath) {
        this.logger.debug("Validating {}. expected_digest={}", (Object)this.digest.algorithm(), (Object)this.digest.value());
        return this.fs.open(filePath, new OpenOptions()).compose(this::calculateDigest).compose(computedDigest -> {
            if (!computedDigest.equals(this.digest.value())) {
                this.logger.error("Digest mismatch. computed_digest={}, expected_digest={}, algorithm={}", new Object[]{computedDigest, this.digest.value(), this.digest.algorithm()});
                return Future.failedFuture((Throwable)new HttpException(SidecarHttpResponseStatus.CHECKSUM_MISMATCH.code(), String.format("Digest mismatch. expected_digest=%s, algorithm=%s", this.digest.value(), this.digest.algorithm())));
            }
            return Future.succeededFuture((Object)filePath);
        });
    }

    protected Future<String> calculateDigest(AsyncFile asyncFile) {
        Promise result = Promise.promise();
        this.readFile(asyncFile, (Promise<String>)result, (Handler<Buffer>)((Handler)buf -> {
            byte[] bytes = buf.getBytes();
            this.digestAlgorithm.update(bytes, 0, bytes.length);
        }), (Handler<Void>)((Handler)onReadComplete -> {
            result.complete((Object)this.digestAlgorithm.digest());
            try {
                this.digestAlgorithm.close();
            }
            catch (IOException e) {
                this.logger.warn("Potential memory leak due to failed to close hasher {}", (Object)this.digestAlgorithm.getClass().getSimpleName());
            }
        }));
        return result.future();
    }

    protected void readFile(AsyncFile file, Promise<String> result, Handler<Buffer> onBufferAvailable, Handler<Void> onReadComplete) {
        result.future().onComplete(ignored -> file.end());
        file.pause().setReadBufferSize(524288).handler(onBufferAvailable).endHandler(onReadComplete).exceptionHandler(cause -> {
            this.logger.error("Error while calculating the {} digest", (Object)this.digest.algorithm(), cause);
            result.fail(cause);
        }).resume();
    }
}

