/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.job;

import java.util.UUID;
import org.apache.cassandra.sidecar.common.data.OperationalJobStatus;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.job.OperationalJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeDecommissionJob
extends OperationalJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeDecommissionJob.class);
    private static final String OPERATION = "decommission";
    private final boolean isForce;
    protected StorageOperations storageOperations;

    public NodeDecommissionJob(UUID jobId, StorageOperations storageOps, boolean isForce) {
        super(jobId);
        this.storageOperations = storageOps;
        this.isForce = isForce;
    }

    @Override
    public boolean isRunningOnCassandra() {
        String operationMode = this.storageOperations.operationMode();
        return "LEAVING".equals(operationMode) || "DECOMMISSIONED".equals(operationMode);
    }

    @Override
    public OperationalJobStatus status() {
        String operationMode = this.storageOperations.operationMode();
        if ("LEAVING".equals(operationMode)) {
            return OperationalJobStatus.RUNNING;
        }
        if ("DECOMMISSIONED".equals(operationMode)) {
            return OperationalJobStatus.SUCCEEDED;
        }
        return super.status();
    }

    @Override
    protected void executeInternal() {
        if (this.isRunningOnCassandra()) {
            LOGGER.info("Not executing job as an ongoing or completed decommission operation was found jobId={}", (Object)this.jobId());
            return;
        }
        LOGGER.info("Executing decommission operation. jobId={}", (Object)this.jobId());
        this.storageOperations.decommission(this.isForce);
    }

    @Override
    public String name() {
        return OPERATION;
    }
}

