/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.datastax.driver.core.Metadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.datahub.SchemaReporter;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.modules.ApiModule;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ReportSchemaHandler
extends AbstractHandler<Void>
implements AccessProtected {
    @NotNull
    private final SchemaReporter schemaReporter;

    @Inject
    public ReportSchemaHandler(@NotNull InstanceMetadataFetcher metadata, @NotNull ExecutorPools executor, @NotNull SchemaReporter reporter) {
        super(metadata, executor, null);
        this.schemaReporter = reporter;
    }

    @Override
    @NotNull
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.REPORT_SCHEMA.toAuthorization());
    }

    @Override
    @Nullable
    protected Void extractParamsOrThrow(@NotNull RoutingContext context) {
        return null;
    }

    @Override
    protected void handleInternal(@NotNull RoutingContext context, @NotNull HttpServerRequest http, @NotNull String host, @NotNull SocketAddress address, @Nullable Void request) {
        Metadata metadata = this.metadataFetcher.callOnFirstAvailableInstance(instance -> instance.delegate().metadata());
        this.executorPools.service().runBlocking(() -> this.schemaReporter.processRequested(metadata)).onSuccess(ignored -> context.json(ApiModule.OK_STATUS)).onFailure(throwable -> this.processFailure((Throwable)throwable, context, host, address, request));
    }
}

