/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.datahub;

import com.datastax.driver.core.Metadata;
import com.google.common.collect.ImmutableMap;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.dataplatforminstance.DataPlatformInstanceProperties;
import datahub.event.MetadataChangeProposalWrapper;
import java.util.Map;
import org.apache.cassandra.sidecar.datahub.ClusterToAspectConverter;
import org.apache.cassandra.sidecar.datahub.IdentifiersProvider;
import org.jetbrains.annotations.NotNull;

public class ClusterToDataPlatformInstancePropertiesConverter
extends ClusterToAspectConverter<DataPlatformInstanceProperties> {
    protected static final String ENVIRONMENT = "environment";
    protected static final String APPLICATION = "application";
    protected static final String CLUSTER = "cluster";

    public ClusterToDataPlatformInstancePropertiesConverter(@NotNull IdentifiersProvider identifiers) {
        super(identifiers);
    }

    @Override
    @NotNull
    public MetadataChangeProposalWrapper<DataPlatformInstanceProperties> convert(@NotNull Metadata cluster) {
        String type = "dataPlatformInstance";
        String urn = this.identifiers.urnDataPlatformInstance();
        DataPlatformInstanceProperties aspect = new DataPlatformInstanceProperties().setName(this.identifiers.identifier().toString()).setDescription(null, SetMode.REMOVE_IF_NULL).setCustomProperties(new StringMap((Map)ImmutableMap.of((Object)ENVIRONMENT, (Object)this.identifiers.environment(), (Object)APPLICATION, (Object)this.identifiers.application(), (Object)CLUSTER, (Object)this.identifiers.cluster())));
        return this.wrap(type, urn, aspect);
    }
}

