/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.cassandra.sidecar.common.response.GossipInfoResponse;
import org.jetbrains.annotations.NotNull;

public class GossipInfoParser {
    private static final String IPV4_PATTERN = "(?:[0-9]{1,3}.){3}[0-9]{1,3}";
    private static final String IPV6_PATTERN = "(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}";
    private static final String IP_PATTERN = String.format("((%s)|(%s))", "(?:[0-9]{1,3}.){3}[0-9]{1,3}", "(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}");
    private static final String IP_WITH_PORT_PATTERN = String.format("%s(:[0-9]{1,5})?", IP_PATTERN);
    private static final String GOSSIP_INFO_FIELD_SEPARATOR = ":";
    private static final String GOSSIP_INFO_HOST_HEADER_PATTERN = String.format("(.*)?/%s", IP_WITH_PORT_PATTERN);
    private static final Pattern GOSSIP_INFO_HOST_PATTERN = Pattern.compile(GOSSIP_INFO_HOST_HEADER_PATTERN);
    private static final Splitter GOSSIP_INFO_LINE_SPLITTER = Splitter.on((String)System.lineSeparator()).trimResults().omitEmptyStrings();
    private static final Splitter GOSSIP_INFO_FIELD_SPLITTER = Splitter.on((String)":").limit(3);

    private GossipInfoParser() {
    }

    public static GossipInfoResponse parse(@NotNull String rawGossipInfo) {
        GossipInfoResponse gossipInfoMap = new GossipInfoResponse();
        GossipInfoResponse.GossipInfo gossipInfo = null;
        for (String line : GOSSIP_INFO_LINE_SPLITTER.split((CharSequence)rawGossipInfo)) {
            if (GossipInfoParser.isGossipInfoHostHeader(line)) {
                gossipInfo = (GossipInfoResponse.GossipInfo)gossipInfoMap.computeIfAbsent((Object)line, s -> new GossipInfoResponse.GossipInfo());
                continue;
            }
            assert (gossipInfo != null);
            List splitLine = GOSSIP_INFO_FIELD_SPLITTER.splitToList((CharSequence)line);
            Preconditions.checkState((splitLine.size() == 2 || splitLine.size() == 3 ? 1 : 0) != 0, (String)"A gossip field should be split into two or three parts. %s", (Object[])new Object[]{line});
            String key = (String)splitLine.get(0);
            String value = (String)splitLine.get(splitLine.size() - 1);
            gossipInfo.camelizeKeyAndPut(key, value);
        }
        return gossipInfoMap;
    }

    public static boolean isGossipInfoHostHeader(String line) {
        return GOSSIP_INFO_HOST_PATTERN.matcher(line).matches();
    }
}

