/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.SimpleBuilders;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.rows.SerializationHelper;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.commons.lang3.StringUtils;

public class Mutation
implements IMutation {
    public static final MutationSerializer serializer = new MutationSerializer();
    public static final String FORWARD_TO = "FWD_TO";
    public static final String FORWARD_FROM = "FWD_FRM";
    private final String keyspaceName;
    private final DecoratedKey key;
    private final Map<UUID, PartitionUpdate> modifications;
    public final long createdAt;
    public final AtomicLong viewLockAcquireStart = new AtomicLong(0L);
    private boolean cdcEnabled = false;

    public Mutation(String keyspaceName, DecoratedKey key) {
        this(keyspaceName, key, new HashMap<UUID, PartitionUpdate>());
    }

    public Mutation(String keyspaceName, DecoratedKey key, long createdAt, boolean cdcEnabled) {
        this(keyspaceName, key, new HashMap<UUID, PartitionUpdate>(), createdAt, cdcEnabled);
    }

    public Mutation(PartitionUpdate update) {
        this(update.metadata().ksName, update.partitionKey(), Collections.singletonMap(update.metadata().cfId, update));
    }

    protected Mutation(String keyspaceName, DecoratedKey key, Map<UUID, PartitionUpdate> modifications) {
        this(keyspaceName, key, modifications, System.currentTimeMillis());
    }

    private Mutation(String keyspaceName, DecoratedKey key, Map<UUID, PartitionUpdate> modifications, long createdAt) {
        this(keyspaceName, key, modifications, createdAt, Mutation.cdcEnabled(modifications));
    }

    private Mutation(String keyspaceName, DecoratedKey key, Map<UUID, PartitionUpdate> modifications, long createdAt, boolean cdcEnabled) {
        this.keyspaceName = keyspaceName;
        this.key = key;
        this.modifications = modifications;
        this.cdcEnabled = cdcEnabled;
        this.createdAt = createdAt;
    }

    private static boolean cdcEnabled(Map<UUID, PartitionUpdate> modifications) {
        boolean cdcEnabled = false;
        for (PartitionUpdate pu : modifications.values()) {
            cdcEnabled |= pu.metadata().params.cdc;
        }
        return cdcEnabled;
    }

    public Mutation copy() {
        return new Mutation(this.keyspaceName, this.key, new HashMap<UUID, PartitionUpdate>(this.modifications));
    }

    public Mutation without(Set<UUID> cfIds) {
        if (cfIds.isEmpty()) {
            return this;
        }
        Mutation copy = this.copy();
        copy.modifications.keySet().removeAll(cfIds);
        copy.cdcEnabled = false;
        for (PartitionUpdate pu : this.modifications.values()) {
            copy.cdcEnabled |= pu.metadata().params.cdc;
        }
        return copy;
    }

    public Mutation without(UUID cfId) {
        return this.without(Collections.singleton(cfId));
    }

    @Override
    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.modifications.keySet();
    }

    @Override
    public DecoratedKey key() {
        return this.key;
    }

    @Override
    public Collection<PartitionUpdate> getPartitionUpdates() {
        return this.modifications.values();
    }

    public PartitionUpdate getPartitionUpdate(UUID cfId) {
        return this.modifications.get(cfId);
    }

    public Mutation add(PartitionUpdate update) {
        assert (update != null);
        assert (update.partitionKey().getPartitioner() == this.key.getPartitioner());
        this.cdcEnabled |= update.metadata().params.cdc;
        PartitionUpdate prev = this.modifications.put(update.metadata().cfId, update);
        if (prev != null) {
            throw new IllegalArgumentException("Table " + update.metadata().cfName + " already has modifications in this mutation: " + prev);
        }
        return this;
    }

    public PartitionUpdate get(CFMetaData cfm) {
        return this.modifications.get(cfm.cfId);
    }

    public boolean isEmpty() {
        return this.modifications.isEmpty();
    }

    public static Mutation merge(List<Mutation> mutations) {
        assert (!mutations.isEmpty());
        if (mutations.size() == 1) {
            return mutations.get(0);
        }
        HashSet<UUID> updatedTables = new HashSet<UUID>();
        String ks = null;
        DecoratedKey key = null;
        for (Mutation mutation : mutations) {
            updatedTables.addAll(mutation.modifications.keySet());
            if (ks != null && !ks.equals(mutation.keyspaceName)) {
                throw new IllegalArgumentException();
            }
            if (key != null && !key.equals(mutation.key)) {
                throw new IllegalArgumentException();
            }
            ks = mutation.keyspaceName;
            key = mutation.key;
        }
        ArrayList<PartitionUpdate> updates = new ArrayList<PartitionUpdate>(mutations.size());
        HashMap<UUID, PartitionUpdate> modifications = new HashMap<UUID, PartitionUpdate>(updatedTables.size());
        for (UUID table : updatedTables) {
            for (Mutation mutation : mutations) {
                PartitionUpdate upd = mutation.modifications.get(table);
                if (upd == null) continue;
                updates.add(upd);
            }
            if (updates.isEmpty()) continue;
            modifications.put(table, updates.size() == 1 ? (PartitionUpdate)updates.get(0) : PartitionUpdate.merge(updates));
            updates.clear();
        }
        return new Mutation(ks, key, modifications);
    }

    public CompletableFuture<?> applyFuture() {
        Keyspace ks = Keyspace.open(this.keyspaceName);
        return ks.applyFuture(this, Keyspace.open((String)this.keyspaceName).getMetadata().params.durableWrites, true);
    }

    public void apply(boolean durableWrites, boolean isDroppable) {
        Keyspace.open(this.keyspaceName).apply(this, durableWrites, true, isDroppable);
    }

    public void apply(boolean durableWrites) {
        this.apply(durableWrites, true);
    }

    @Override
    public void apply() {
        this.apply(Keyspace.open((String)this.keyspaceName).getMetadata().params.durableWrites);
    }

    public void applyUnsafe() {
        this.apply(false);
    }

    public MessageOut<Mutation> createMessage() {
        return this.createMessage(MessagingService.Verb.MUTATION);
    }

    public MessageOut<Mutation> createMessage(MessagingService.Verb verb) {
        return new MessageOut<Mutation>(verb, this, serializer);
    }

    @Override
    public long getTimeout() {
        return DatabaseDescriptor.getWriteRpcTimeout();
    }

    public int smallestGCGS() {
        int gcgs = Integer.MAX_VALUE;
        for (PartitionUpdate update : this.getPartitionUpdates()) {
            gcgs = Math.min(gcgs, update.metadata().params.gcGraceSeconds);
        }
        return gcgs;
    }

    public boolean trackedByCDC() {
        return this.cdcEnabled;
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("Mutation(");
        buff.append("keyspace='").append(this.keyspaceName).append('\'');
        buff.append(", key='").append(ByteBufferUtil.bytesToHex(this.key.getKey())).append('\'');
        buff.append(", modifications=[");
        if (shallow) {
            ArrayList<String> cfnames = new ArrayList<String>(this.modifications.size());
            for (UUID cfid : this.modifications.keySet()) {
                CFMetaData cfm = Schema.instance.getCFMetaData(cfid);
                cfnames.add(cfm == null ? "-dropped-" : cfm.cfName);
            }
            buff.append(StringUtils.join(cfnames, (String)", "));
        } else {
            buff.append("\n  ").append(StringUtils.join(this.modifications.values(), (String)"\n  ")).append('\n');
        }
        return buff.append("])").toString();
    }

    public static SimpleBuilder simpleBuilder(String keyspaceName, DecoratedKey partitionKey) {
        return new SimpleBuilders.MutationBuilder(keyspaceName, partitionKey);
    }

    public static class MutationSerializer
    implements IVersionedSerializer<Mutation> {
        @Override
        public void serialize(Mutation mutation, DataOutputPlus out, int version) throws IOException {
            if (version < 7) {
                out.writeUTF(mutation.getKeyspaceName());
            }
            int size = mutation.modifications.size();
            if (version < 10) {
                ByteBufferUtil.writeWithShortLength(mutation.key().getKey(), out);
                out.writeInt(size);
            } else {
                out.writeUnsignedVInt(size);
            }
            assert (size > 0);
            for (Map.Entry entry : mutation.modifications.entrySet()) {
                PartitionUpdate.serializer.serialize((PartitionUpdate)entry.getValue(), out, version);
            }
        }

        public Mutation deserialize(DataInputPlus in, int version, SerializationHelper.Flag flag) throws IOException {
            int size;
            if (version < 7) {
                in.readUTF();
            }
            ByteBuffer key = null;
            if (version < 10) {
                key = ByteBufferUtil.readWithShortLength(in);
                size = in.readInt();
            } else {
                size = (int)in.readUnsignedVInt();
            }
            assert (size > 0);
            PartitionUpdate update = PartitionUpdate.serializer.deserialize(in, version, flag, key);
            if (size == 1) {
                return new Mutation(update);
            }
            HashMap<UUID, PartitionUpdate> modifications = new HashMap<UUID, PartitionUpdate>(size);
            DecoratedKey dk = update.partitionKey();
            modifications.put(update.metadata().cfId, update);
            for (int i = 1; i < size; ++i) {
                update = PartitionUpdate.serializer.deserialize(in, version, flag, dk);
                modifications.put(update.metadata().cfId, update);
            }
            return new Mutation(update.metadata().ksName, dk, modifications);
        }

        @Override
        public Mutation deserialize(DataInputPlus in, int version) throws IOException {
            return this.deserialize(in, version, SerializationHelper.Flag.FROM_REMOTE);
        }

        @Override
        public long serializedSize(Mutation mutation, int version) {
            int size = 0;
            if (version < 7) {
                size += TypeSizes.sizeof(mutation.getKeyspaceName());
            }
            if (version < 10) {
                int keySize = mutation.key().getKey().remaining();
                size += TypeSizes.sizeof((short)keySize) + keySize;
                size += TypeSizes.sizeof(mutation.modifications.size());
            } else {
                size += TypeSizes.sizeofUnsignedVInt(mutation.modifications.size());
            }
            for (Map.Entry entry : mutation.modifications.entrySet()) {
                size = (int)((long)size + PartitionUpdate.serializer.serializedSize((PartitionUpdate)entry.getValue(), version));
            }
            return size;
        }
    }

    public static interface SimpleBuilder {
        public SimpleBuilder timestamp(long var1);

        public SimpleBuilder ttl(int var1);

        public PartitionUpdate.SimpleBuilder update(CFMetaData var1);

        public PartitionUpdate.SimpleBuilder update(String var1);

        public Mutation build();
    }
}

