/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Camel metrics based on the Camel Telemetry spec
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface OpenTelemetryEndpointBuilderFactory {

    /**
     * Builder for endpoint for the OpenTelemetry Metrics component.
     */
    public interface OpenTelemetryEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedOpenTelemetryEndpointBuilder advanced() {
            return (AdvancedOpenTelemetryEndpointBuilder) this;
        }

        /**
         * Action expression when using timer type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param action the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder action(String action) {
            doSetProperty("action", action);
            return this;
        }
        /**
         * metric attributes. This is a multi-value option with prefix:
         * attributes.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the attributes(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder attributes(String key, Object value) {
            doSetMultiValueProperty("attributes", "attributes." + key, value);
            return this;
        }
        /**
         * metric attributes. This is a multi-value option with prefix:
         * attributes.
         * 
         * The option is a: <code>java.util.Map&lt;java.lang.String,
         * java.lang.String&gt;</code> type.
         * The option is multivalued, and you can use the attributes(String,
         * Object) method to add a value (call the method multiple times to set
         * more values).
         * 
         * Group: producer
         * 
         * @param values the values
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder attributes(Map values) {
            doSetMultiValueProperties("attributes", "attributes.", values);
            return this;
        }
        /**
         * Decrement value expression when using counter type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param decrement the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder decrement(String decrement) {
            doSetProperty("decrement", decrement);
            return this;
        }
        /**
         * Increment value expression when using counter type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param increment the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder increment(String increment) {
            doSetProperty("increment", increment);
            return this;
        }
        /**
         * Description of metrics.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param metricsDescription the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder metricsDescription(String metricsDescription) {
            doSetProperty("metricsDescription", metricsDescription);
            return this;
        }
        /**
         * The time unit when using the timer type.
         * 
         * The option is a: <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: producer
         * 
         * @param unit the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder unit(TimeUnit unit) {
            doSetProperty("unit", unit);
            return this;
        }
        /**
         * The time unit when using the timer type.
         * 
         * The option will be converted to a
         * <code>java.util.concurrent.TimeUnit</code> type.
         * 
         * Default: MILLISECONDS
         * Group: producer
         * 
         * @param unit the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder unit(String unit) {
            doSetProperty("unit", unit);
            return this;
        }
        /**
         * Value expression when using histogram type.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param value the value to set
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder value(String value) {
            doSetProperty("value", value);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the OpenTelemetry Metrics component.
     */
    public interface AdvancedOpenTelemetryEndpointBuilder
            extends
                EndpointProducerBuilder {
        default OpenTelemetryEndpointBuilder basic() {
            return (OpenTelemetryEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenTelemetryEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedOpenTelemetryEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface OpenTelemetryBuilders {
        /**
         * OpenTelemetry Metrics (camel-opentelemetry-metrics)
         * Camel metrics based on the Camel Telemetry spec
         * 
         * Category: monitoring
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-opentelemetry-metrics
         * 
         * @return the dsl builder for the headers' name.
         */
        default OpenTelemetryHeaderNameBuilder opentelemetryMetrics() {
            return OpenTelemetryHeaderNameBuilder.INSTANCE;
        }
        /**
         * OpenTelemetry Metrics (camel-opentelemetry-metrics)
         * Camel metrics based on the Camel Telemetry spec
         * 
         * Category: monitoring
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-opentelemetry-metrics
         * 
         * Syntax: <code>opentelemetry-metrics:metricType:metricName</code>
         * 
         * Path parameter: metricType (required)
         * Type of metrics
         * There are 3 enums and the value can be one of: counter, summary,
         * timer
         * 
         * Path parameter: metricName (required)
         * Name of metric
         * 
         * @param path metricType:metricName
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder opentelemetryMetrics(String path) {
            return OpenTelemetryEndpointBuilderFactory.endpointBuilder("opentelemetry-metrics", path);
        }
        /**
         * OpenTelemetry Metrics (camel-opentelemetry-metrics)
         * Camel metrics based on the Camel Telemetry spec
         * 
         * Category: monitoring
         * Since: 4.17
         * Maven coordinates: org.apache.camel:camel-opentelemetry-metrics
         * 
         * Syntax: <code>opentelemetry-metrics:metricType:metricName</code>
         * 
         * Path parameter: metricType (required)
         * Type of metrics
         * There are 3 enums and the value can be one of: counter, summary,
         * timer
         * 
         * Path parameter: metricName (required)
         * Name of metric
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path metricType:metricName
         * @return the dsl builder
         */
        default OpenTelemetryEndpointBuilder opentelemetryMetrics(String componentName, String path) {
            return OpenTelemetryEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the OpenTelemetry Metrics component.
     */
    public static class OpenTelemetryHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final OpenTelemetryHeaderNameBuilder INSTANCE = new OpenTelemetryHeaderNameBuilder();

        /**
         * Override timer action in URI.
         * 
         * The option is a: {@code
         * org.apache.camel.opentelemetry.metrics.OpenTelemetryTimerAction}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsTimerAction}.
         */
        public String metricsTimerAction() {
            return "CamelMetricsTimerAction";
        }
        /**
         * Override histogram value in URI.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsHistogramValue}.
         */
        public String metricsHistogramValue() {
            return "CamelMetricsHistogramValue";
        }
        /**
         * Override decrement value in URI.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsCounterDecrement}.
         */
        public String metricsCounterDecrement() {
            return "CamelMetricsCounterDecrement";
        }
        /**
         * Override increment value in URI.
         * 
         * The option is a: {@code Double} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsCounterIncrement}.
         */
        public String metricsCounterIncrement() {
            return "CamelMetricsCounterIncrement";
        }
        /**
         * Override name value in URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsName}.
         */
        public String metricsName() {
            return "CamelMetricsName";
        }
        /**
         * Override description value in URI.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsDescription}.
         */
        public String metricsDescription() {
            return "CamelMetricsDescription";
        }
        /**
         * To augment meter attributes defined as URI parameters.
         * 
         * The option is a: {@code io.opentelemetry.api.common.Attributes} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code MetricsAttributes}.
         */
        public String metricsAttributes() {
            return "CamelMetricsAttributes";
        }
    }
    static OpenTelemetryEndpointBuilder endpointBuilder(String componentName, String path) {
        class OpenTelemetryEndpointBuilderImpl extends AbstractEndpointBuilder implements OpenTelemetryEndpointBuilder, AdvancedOpenTelemetryEndpointBuilder {
            public OpenTelemetryEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new OpenTelemetryEndpointBuilderImpl(path);
    }
}