/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.config;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.io.Closeable;
import java.util.concurrent.TimeUnit;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.compute.ComputeServiceAdapter;
import org.jclouds.compute.config.ComputeServiceAdapterContextModule;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Volume;
import org.jclouds.compute.domain.internal.ArbitraryCpuRamTemplateBuilderImpl;
import org.jclouds.compute.domain.internal.TemplateBuilderImpl;
import org.jclouds.compute.strategy.CreateNodesInGroupThenAddToSet;
import org.jclouds.domain.Location;
import org.jclouds.functions.IdentityFunction;
import org.jclouds.lifecycle.Closer;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.location.suppliers.implicit.OnlyLocationOrFirstZone;
import org.jclouds.profitbricks.ProfitBricksApi;
import org.jclouds.profitbricks.compute.ProfitBricksComputeServiceAdapter;
import org.jclouds.profitbricks.compute.concurrent.ProvisioningJob;
import org.jclouds.profitbricks.compute.concurrent.ProvisioningManager;
import org.jclouds.profitbricks.compute.function.ProvisionableToImage;
import org.jclouds.profitbricks.compute.function.ServerToNodeMetadata;
import org.jclouds.profitbricks.compute.function.StorageToVolume;
import org.jclouds.profitbricks.compute.strategy.AssignDataCenterToTemplate;
import org.jclouds.profitbricks.domain.Provisionable;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Server;
import org.jclouds.profitbricks.domain.Storage;
import org.jclouds.util.PasswordGenerator;
import org.jclouds.util.Predicates2;

public class ProfitBricksComputeServiceContextModule
extends ComputeServiceAdapterContextModule<Server, Hardware, Provisionable, Location> {
    protected void configure() {
        super.configure();
        this.install(new FactoryModuleBuilder().build(ProvisioningJob.Factory.class));
        this.bind(ImplicitLocationSupplier.class).to(OnlyLocationOrFirstZone.class).in(Scopes.SINGLETON);
        this.bind(CreateNodesInGroupThenAddToSet.class).to(AssignDataCenterToTemplate.class).in(Scopes.SINGLETON);
        this.bind(TemplateBuilderImpl.class).to(ArbitraryCpuRamTemplateBuilderImpl.class);
        this.bind((TypeLiteral)new TypeLiteral<ComputeServiceAdapter<Server, Hardware, Provisionable, Location>>(){}).to(ProfitBricksComputeServiceAdapter.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Server, NodeMetadata>>(){}).to(ServerToNodeMetadata.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Provisionable, Image>>(){}).to(ProvisionableToImage.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Storage, Volume>>(){}).to(StorageToVolume.class);
        this.bind((TypeLiteral)new TypeLiteral<Function<Hardware, Hardware>>(){}).to((Class)Class.class.cast(IdentityFunction.class));
    }

    @Provides
    @Singleton
    protected PasswordGenerator.Config providePasswordGenerator() {
        return new PasswordGenerator().lower().min(2).max(10).exclude("ilowyz".toCharArray()).upper().min(2).max(10).exclude("IOWYZ".toCharArray()).numbers().min(2).max(10).exclude("10".toCharArray()).symbols().count(0);
    }

    @Provides
    @Singleton
    @Named(value="jclouds.profitbricks.predicate.datacenter")
    Predicate<String> provideDataCenterAvailablePredicate(ProfitBricksApi api, ComputeConstants constants) {
        return Predicates2.retry((Predicate)new DataCenterProvisioningStatePredicate(api, ProvisioningState.AVAILABLE), (long)constants.pollTimeout(), (long)constants.pollPeriod(), (long)constants.pollMaxPeriod(), (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-running")
    Predicate<String> provideServerRunningPredicate(ProfitBricksApi api, ComputeConstants constants) {
        return Predicates2.retry((Predicate)new ServerStatusPredicate(api, Server.Status.RUNNING), (long)constants.pollTimeout(), (long)constants.pollPeriod(), (long)constants.pollMaxPeriod(), (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Named(value="jclouds.compute.timeout.node-suspended")
    Predicate<String> provideServerSuspendedPredicate(ProfitBricksApi api, ComputeConstants constants) {
        return Predicates2.retry((Predicate)new ServerStatusPredicate(api, Server.Status.SHUTOFF), (long)constants.pollTimeout(), (long)constants.pollPeriod(), (long)constants.pollMaxPeriod(), (TimeUnit)TimeUnit.SECONDS);
    }

    @Provides
    @Singleton
    ProvisioningManager provideProvisioningManager(Closer closer) {
        ProvisioningManager provisioningManager = new ProvisioningManager();
        closer.addToClose((Closeable)provisioningManager);
        return provisioningManager;
    }

    @Provides
    @Singleton
    @Named(value="jclouds.profitbricks.predicate.snapshot")
    Predicate<String> provideSnapshotAvailablePredicate(ProfitBricksApi api, ComputeConstants constants) {
        return Predicates2.retry((Predicate)new SnapshotProvisioningStatePredicate(api, ProvisioningState.AVAILABLE), (long)constants.pollTimeout(), (long)constants.pollPeriod(), (long)constants.pollMaxPeriod(), (TimeUnit)TimeUnit.SECONDS);
    }

    @Singleton
    public static class ComputeConstants {
        @Inject
        @Named(value="jclouds.profitbricks.timeout.datacenter-available")
        private String pollTimeout;
        @Inject
        @Named(value="jclouds.profitbricks.poll-status.initial-period")
        private String pollPeriod;
        @Inject
        @Named(value="jclouds.profitbricks.poll-status.poll.max-period")
        private String pollMaxPeriod;

        public long pollTimeout() {
            return Long.parseLong(this.pollTimeout);
        }

        public long pollPeriod() {
            return Long.parseLong(this.pollPeriod);
        }

        public long pollMaxPeriod() {
            return Long.parseLong(this.pollMaxPeriod);
        }
    }

    static class SnapshotProvisioningStatePredicate
    implements Predicate<String> {
        private final ProfitBricksApi api;
        private final ProvisioningState expectedState;

        public SnapshotProvisioningStatePredicate(ProfitBricksApi api, ProvisioningState expectedState) {
            this.api = (ProfitBricksApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.expectedState = (ProvisioningState)((Object)Preconditions.checkNotNull((Object)((Object)expectedState), (Object)"expectedState must not be null"));
        }

        public boolean apply(String input) {
            Preconditions.checkNotNull((Object)input, (Object)"snapshot id");
            return this.api.snapshotApi().getSnapshot(input).state() == this.expectedState;
        }
    }

    static class ServerStatusPredicate
    implements Predicate<String> {
        private final ProfitBricksApi api;
        private final Server.Status expectedStatus;

        public ServerStatusPredicate(ProfitBricksApi api, Server.Status expectedStatus) {
            this.api = (ProfitBricksApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.expectedStatus = (Server.Status)((Object)Preconditions.checkNotNull((Object)((Object)expectedStatus), (Object)"expectedStatus must not be null"));
        }

        public boolean apply(String input) {
            Preconditions.checkNotNull((Object)input, (Object)"server id");
            return this.api.serverApi().getServer(input).status() == this.expectedStatus;
        }
    }

    static class DataCenterProvisioningStatePredicate
    implements Predicate<String> {
        private final ProfitBricksApi api;
        private final ProvisioningState expectedState;

        public DataCenterProvisioningStatePredicate(ProfitBricksApi api, ProvisioningState expectedState) {
            this.api = (ProfitBricksApi)Preconditions.checkNotNull((Object)api, (Object)"api must not be null");
            this.expectedState = (ProvisioningState)((Object)Preconditions.checkNotNull((Object)((Object)expectedState), (Object)"expectedState must not be null"));
        }

        public boolean apply(String input) {
            Preconditions.checkNotNull((Object)input, (Object)"datacenter id");
            return this.api.dataCenterApi().getDataCenterState(input) == this.expectedState;
        }
    }
}

