/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.Provider;
import org.jclouds.location.Region;

public final class RegionToEndpointOrProviderIfNull
implements Function<Object, URI> {
    private final Supplier<URI> defaultUri;
    private final String defaultProvider;
    private final Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier;

    @Inject
    RegionToEndpointOrProviderIfNull(@Provider String defaultProvider, @Provider Supplier<URI> defaultUri, @Region Supplier<Map<String, Supplier<URI>>> regionToEndpointSupplier) {
        this.defaultProvider = defaultProvider;
        this.defaultUri = defaultUri;
        this.regionToEndpointSupplier = regionToEndpointSupplier;
    }

    public URI apply(@Nullable Object from) {
        if (from == null) {
            return (URI)this.defaultUri.get();
        }
        Map regionToEndpoint = (Map)this.regionToEndpointSupplier.get();
        if (from.equals(this.defaultProvider)) {
            if (regionToEndpoint.containsKey(from)) {
                return (URI)((Supplier)regionToEndpoint.get(from)).get();
            }
            return (URI)this.defaultUri.get();
        }
        Preconditions.checkArgument((boolean)regionToEndpoint.containsKey(from), (String)"requested location %s, which is not in the configured locations: %s", (Object)from, (Object)regionToEndpoint);
        return (URI)((Supplier)regionToEndpoint.get(from)).get();
    }
}

