/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.workflow.steps.flow;

import java.util.Map;
import org.apache.brooklyn.core.workflow.WorkflowExecutionContext;
import org.apache.brooklyn.core.workflow.WorkflowStepInstanceExecutionContext;
import org.apache.brooklyn.core.workflow.steps.CustomWorkflowStep;
import org.apache.brooklyn.util.collections.MutableMap;

public class ForeachWorkflowStep
extends CustomWorkflowStep {
    public static final String SHORTHAND = "${target_var_name} [ \" in \" ${target...} ]";
    public static final String SHORTHAND_TYPE_NAME_DEFAULT = "foreach";

    public ForeachWorkflowStep() {
    }

    public ForeachWorkflowStep(CustomWorkflowStep base) {
        super(base);
    }

    public void setTarget(Object x) {
        this.target = x;
    }

    public void setTargetVarName(Object x) {
        this.target_var_name = x;
    }

    @Override
    public void populateFromShorthand(String value) {
        if (this.input == null) {
            this.input = MutableMap.of();
        }
        this.populateFromShorthandTemplate(SHORTHAND, value);
        if (this.input.containsKey("target")) {
            this.target = this.input.remove("target");
        }
        this.target_var_name = this.input.remove("target_var_name");
    }

    @Override
    protected Iterable checkTarget(Object targetR) {
        if (targetR instanceof Iterable) {
            return (Iterable)targetR;
        }
        throw new IllegalArgumentException("Target of foreach must be a list or an expression that resolves to a list, not " + targetR);
    }

    @Override
    protected boolean isPermittedToSetSteps(String typeBestGuess) {
        return typeBestGuess == null || SHORTHAND_TYPE_NAME_DEFAULT.equals(typeBestGuess) || ForeachWorkflowStep.class.getName().equals(typeBestGuess);
    }

    @Override
    protected void initializeSubWorkflowForTarget(WorkflowStepInstanceExecutionContext context, Object target, WorkflowExecutionContext nestedWorkflowContext) {
        String tvn;
        if (this.target_var_name instanceof String && (tvn = ((String)this.target_var_name).trim()).startsWith("{") && tvn.endsWith("}")) {
            String[] spreadVars = tvn.substring(1, tvn.length() - 1).split(",");
            if (!(target instanceof Map)) {
                throw new IllegalStateException("Spread vars indicated in foreach but target is not a map");
            }
            nestedWorkflowContext.updateWorkflowScratchVariable("target", target);
            for (String spreadVar : spreadVars) {
                String svt = spreadVar.trim();
                nestedWorkflowContext.updateWorkflowScratchVariable(svt, ((Map)target).get(svt));
            }
            return;
        }
        super.initializeSubWorkflowForTarget(context, target, nestedWorkflowContext);
    }

    public void setIdempotent(String idempotent) {
        this.idempotent = idempotent;
    }

    public String getIdempotent() {
        return this.idempotent;
    }

    public void setConcurrency(Object concurrency) {
        this.concurrency = concurrency;
    }

    public Object getConcurrency() {
        return this.concurrency;
    }

    public void setWorkflowOutput(Object x) {
        this.workflowOutput = x;
    }
}

