/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.domain;

import java.net.URI;
import java.util.Date;
import java.util.List;
import org.jclouds.googlecloud.internal.NullSafeCopies;
import org.jclouds.googlecomputeengine.domain.AutoValue_Zone;
import org.jclouds.googlecomputeengine.domain.AutoValue_Zone_MaintenanceWindow;
import org.jclouds.googlecomputeengine.domain.Deprecated;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

public abstract class Zone {
    public abstract String id();

    public abstract Date creationTimestamp();

    public abstract URI selfLink();

    public abstract String name();

    @Nullable
    public abstract String description();

    public abstract Status status();

    public abstract List<MaintenanceWindow> maintenanceWindows();

    @Nullable
    public abstract Deprecated deprecated();

    public abstract String region();

    public abstract List<String> availableMachineTypes();

    @SerializedNames(value={"id", "creationTimestamp", "selfLink", "name", "description", "status", "maintenanceWindows", "deprecated", "region", "availableMachineTypes"})
    public static Zone create(String id, Date creationTimestamp, URI selfLink, String name, String description, Status status, List<MaintenanceWindow> maintenanceWindows, Deprecated deprecated, String region, List<String> availableMachineTypes) {
        return new AutoValue_Zone(id, creationTimestamp, selfLink, name, description, status, NullSafeCopies.copyOf(maintenanceWindows), deprecated, region, NullSafeCopies.copyOf(availableMachineTypes));
    }

    Zone() {
    }

    public static enum Status {
        UP,
        DOWN;

    }

    public static abstract class MaintenanceWindow {
        public abstract String name();

        @Nullable
        public abstract String description();

        public abstract Date beginTime();

        public abstract Date endTime();

        @SerializedNames(value={"name", "description", "beginTime", "endTime"})
        public static MaintenanceWindow create(String name, String description, Date beginTime, Date endTime) {
            return new AutoValue_Zone_MaintenanceWindow(name, description, beginTime, endTime);
        }

        MaintenanceWindow() {
        }
    }
}

