/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.machine;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.brooklyn.api.mgmt.Task;
import org.apache.brooklyn.api.mgmt.TaskAdaptable;
import org.apache.brooklyn.api.mgmt.TaskFactory;
import org.apache.brooklyn.api.objs.BrooklynObject;
import org.apache.brooklyn.core.entity.EntityInternal;
import org.apache.brooklyn.core.mgmt.BrooklynTaskTags;
import org.apache.brooklyn.location.ssh.SshMachineLocation;
import org.apache.brooklyn.util.core.file.BrooklynOsCommands;
import org.apache.brooklyn.util.core.task.DynamicTasks;
import org.apache.brooklyn.util.core.task.Tasks;
import org.apache.brooklyn.util.core.task.ssh.SshTasks;
import org.apache.brooklyn.util.core.task.system.ProcessTaskFactory;
import org.apache.brooklyn.util.core.task.system.ProcessTaskWrapper;
import org.apache.brooklyn.util.net.Protocol;
import org.apache.brooklyn.util.ssh.IptablesCommandsConfigurable;
import org.apache.brooklyn.util.text.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class MachineInitTasks {
    private static final Logger log = LoggerFactory.getLogger(MachineInitTasks.class);

    protected EntityInternal entity() {
        return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity((Task)Tasks.current());
    }

    public Task<Void> stopIptablesAsync(final SshMachineLocation machine) {
        return DynamicTasks.queue((String)"stop iptables", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineInitTasks.this.stopIptablesImpl(machine);
            }
        });
    }

    private IptablesCommandsConfigurable iptablesCommands(SshMachineLocation m) {
        return BrooklynOsCommands.bashIptables((BrooklynObject)m);
    }

    protected void stopIptablesImpl(SshMachineLocation machine) {
        log.info("Stopping iptables for {} at {}", (Object)this.entity(), (Object)machine);
        ImmutableList cmds = ImmutableList.of();
        Task<Integer> checkFirewall = this.checkLocationFirewall(machine);
        cmds = (Integer)checkFirewall.getUnchecked() == 0 ? ImmutableList.of((Object)this.iptablesCommands(machine).firewalldServiceStop(), (Object)this.iptablesCommands(machine).firewalldServiceStatus()) : ImmutableList.of((Object)this.iptablesCommands(machine).iptablesServiceStop(), (Object)this.iptablesCommands(machine).iptablesServiceStatus());
        this.subTaskHelperAllowingNonZeroExitCode("execute stop iptables", machine, cmds.toArray(new String[cmds.size()]));
    }

    public Task<Boolean> dontRequireTtyForSudoAsync(SshMachineLocation machine) {
        return (Task)DynamicTasks.queue((TaskAdaptable)((ProcessTaskWrapper)SshTasks.dontRequireTtyForSudo((SshMachineLocation)machine, (boolean)true).newTask()).asTask());
    }

    public Task<Void> openIptablesAsync(final Iterable<Integer> inboundPorts, final SshMachineLocation machine) {
        return DynamicTasks.queue((String)("open iptables " + this.toTruncatedString(inboundPorts, 6)), (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineInitTasks.this.openIptablesImpl(inboundPorts, machine);
            }
        });
    }

    protected void openIptablesImpl(Iterable<Integer> inboundPorts, SshMachineLocation machine) {
        if (inboundPorts == null || Iterables.isEmpty(inboundPorts)) {
            log.info("No ports to open in iptables (no inbound ports) for {} at {}", (Object)machine, (Object)this);
        } else {
            log.info("Opening ports in iptables for {} at {}", (Object)this.entity(), (Object)machine);
            List<Object> iptablesRules = Lists.newArrayList();
            String iptablesInstallCommands = null;
            Task<Integer> checkFirewall = this.checkLocationFirewall(machine);
            if ((Integer)checkFirewall.getUnchecked() == 0) {
                for (Integer port : inboundPorts) {
                    iptablesRules.add(this.iptablesCommands(machine).addFirewalldRule(IptablesCommandsConfigurable.Chain.INPUT, Protocol.TCP, port.intValue(), IptablesCommandsConfigurable.Policy.ACCEPT));
                }
            } else {
                iptablesRules = this.createIptablesRulesForNetworkInterface(inboundPorts, machine);
                iptablesInstallCommands = this.iptablesCommands(machine).saveIptablesRules();
            }
            this.insertIptablesRules((List<String>)iptablesRules, iptablesInstallCommands, machine);
            this.listIptablesRules(machine);
        }
    }

    public Task<Integer> checkLocationFirewall(SshMachineLocation machine) {
        return this.subTaskHelperAllowingNonZeroExitCode("check if firewall is active", machine, this.iptablesCommands(machine).firewalldServiceIsActive());
    }

    private Task<Void> insertIptablesRules(final List<String> iptablesRules, final String installCommands, final SshMachineLocation machine) {
        return DynamicTasks.queue((String)"insert rules", (Runnable)new Runnable(){

            @Override
            public void run() {
                MachineInitTasks.this.insertIptablesRulesImpl(iptablesRules, installCommands, machine);
            }
        });
    }

    private void insertIptablesRulesImpl(List<String> iptablesRules, String installCommands, SshMachineLocation machine) {
        List batches = Lists.partition(iptablesRules, (int)100);
        int batchNumber = 0;
        for (List batch : batches) {
            this.insertIptablesRulesOnCommandBatches(batch, machine, ++batchNumber);
        }
        if (installCommands != null) {
            this.serviceIptablesSave(installCommands, machine);
        }
    }

    private Task<Integer> insertIptablesRulesOnCommandBatches(List<String> commandsBatch, SshMachineLocation machine, int batchNumber) {
        return this.subTaskHelperRequiringZeroExitCode("commands batch " + batchNumber, machine, commandsBatch.toArray(new String[commandsBatch.size()]));
    }

    private Task<Integer> serviceIptablesSave(String installCommands, SshMachineLocation machine) {
        return this.subTaskHelperRequiringZeroExitCode("save", machine, installCommands);
    }

    private Task<Integer> listIptablesRules(SshMachineLocation machine) {
        return this.subTaskHelperRequiringZeroExitCode("list rules", machine, this.iptablesCommands(machine).listIptablesRule());
    }

    private Task<Integer> subTaskHelperRequiringZeroExitCode(String taskName, SshMachineLocation machine, String ... comands) {
        ProcessTaskFactory taskFactory = SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])comands).summary(taskName).requiringExitCodeZero();
        return ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).asTask();
    }

    private Task<Integer> subTaskHelperAllowingNonZeroExitCode(String taskName, SshMachineLocation machine, String ... comands) {
        ProcessTaskFactory taskFactory = SshTasks.newSshExecTaskFactory((SshMachineLocation)machine, (String[])comands).summary(taskName).allowingNonZeroExitCode();
        return ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)taskFactory)).asTask();
    }

    private List<String> createIptablesRulesForNetworkInterface(Iterable<Integer> ports, SshMachineLocation machine) {
        ArrayList iptablesRules = Lists.newArrayList();
        for (Integer port : ports) {
            iptablesRules.add(this.iptablesCommands(machine).insertIptablesRule(IptablesCommandsConfigurable.Chain.INPUT, Protocol.TCP, port.intValue(), IptablesCommandsConfigurable.Policy.ACCEPT));
        }
        return iptablesRules;
    }

    protected String toTruncatedString(Iterable<?> vals, int maxShown) {
        StringBuilder result = new StringBuilder("[");
        int shown = 0;
        Iterator iterator = (vals == null ? ImmutableList.of() : vals).iterator();
        while (iterator.hasNext()) {
            Object val = iterator.next();
            if (shown != 0) {
                result.append(", ");
            }
            if (shown < maxShown) {
                result.append(Strings.toString(val));
                ++shown;
                continue;
            }
            result.append("...");
            break;
        }
        result.append("]");
        return result.toString();
    }
}

