/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.core.resolve.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import org.apache.brooklyn.core.resolve.jackson.BrooklynJacksonSerializationUtils;
import org.apache.brooklyn.core.resolve.jackson.JacksonBetterDelegatingDeserializer;
import org.apache.brooklyn.util.core.flags.TypeCoercions;
import org.apache.brooklyn.util.guava.Maybe;
import org.apache.brooklyn.util.text.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReferencingSerialization {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectReferencingSerialization.class);
    public static final String PREFIX = "_" + ObjectReferencingSerialization.class.getSimpleName() + "_";
    final BiMap<String, Object> backingMap = HashBiMap.create();
    ObjectMapper mapper = null;

    public Object serializeAndDeserialize(Object input) throws IOException {
        return this.getMapper().readValue((Reader)new StringReader(this.getMapper().writer().writeValueAsString(input)), Object.class);
    }

    public BiMap<String, Object> getBackingMap() {
        return this.backingMap;
    }

    public ObjectMapper getMapper() {
        if (this.mapper == null) {
            this.useAndApplytoMapper(YAMLMapper.builder().build());
        }
        return this.mapper;
    }

    public ObjectMapper useAndApplytoMapper(ObjectMapper mapper) {
        mapper.setSerializerFactory((SerializerFactory)ObjectReferencingSerializerFactory.extending(mapper.getSerializerFactory(), new ObjectReferenceSerializer(this.backingMap)));
        this.mapper = mapper = new BrooklynJacksonSerializationUtils.ConfigurableBeanDeserializerModifier().addDeserializerWrapper(d -> new ObjectReferencingJsonDeserializer((JsonDeserializer<?>)d, this.backingMap)).apply(mapper);
        return mapper;
    }

    static class ObjectReferencingJsonDeserializer
    extends JacksonBetterDelegatingDeserializer {
        private final BiMap<String, Object> backingMap;

        public ObjectReferencingJsonDeserializer(JsonDeserializer<?> d, BiMap<String, Object> backingMap) {
            super(d, (JsonDeserializer<?> d2) -> new ObjectReferencingJsonDeserializer((JsonDeserializer<?>)d2, backingMap));
            this.backingMap = backingMap;
        }

        @Override
        protected Object deserializeWrapper(JsonParser jp, DeserializationContext ctxt, JacksonBetterDelegatingDeserializer.BiFunctionThrowsIoException<JsonParser, DeserializationContext, Object> nestedDeserialize) throws IOException {
            String v;
            String string = v = jp.getCurrentToken() == JsonToken.VALUE_STRING ? jp.getValueAsString() : null;
            if (v != null && v.startsWith(PREFIX)) {
                Object result;
                JavaType expected2;
                Object expected = this._valueType != null ? this._valueType : this._valueClass;
                JavaType javaType = expected2 = ctxt.getContextualType() == null ? null : ctxt.getContextualType();
                if (expected2 != null) {
                    if (expected == null) {
                        expected = expected2;
                    } else {
                        LOG.debug("Object reference deserialization ambiguity, expected " + expected + " and " + expected2);
                    }
                }
                if (expected == null) {
                    expected = Object.class;
                }
                if ((result = this.backingMap.get((Object)v)) != null) {
                    Maybe resultCoerced = TypeCoercions.tryCoerce(result, TypeToken.of((Type)expected));
                    if (resultCoerced.isAbsent()) {
                        // empty if block
                    }
                    return resultCoerced.or(result);
                }
                LOG.debug("Odd - what looks like a reference was received but not found: " + v);
            }
            return nestedDeserialize.apply(jp, ctxt);
        }
    }

    public static class ObjectReferencingSerializerFactory
    extends BeanSerializerFactory {
        private final ObjectReferenceSerializer serializer;

        protected ObjectReferencingSerializerFactory(ObjectReferenceSerializer serializer, SerializerFactoryConfig config) {
            super(config);
            this.serializer = serializer;
        }

        public static ObjectReferencingSerializerFactory extending(SerializerFactory factory, ObjectReferenceSerializer serializer) {
            if (factory == null) {
                return new ObjectReferencingSerializerFactory(serializer, null);
            }
            if (factory instanceof BeanSerializerFactory) {
                return new ObjectReferencingSerializerFactory(serializer, ((BeanSerializerFactory)factory).getFactoryConfig());
            }
            throw new IllegalStateException("Cannot extend " + factory);
        }

        public ObjectReferencingSerializerFactory withConfig(SerializerFactoryConfig config) {
            if (this._factoryConfig == config) {
                return this;
            }
            return new ObjectReferencingSerializerFactory(this.serializer, config);
        }

        protected JsonSerializer<Object> constructBeanOrAddOnSerializer(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
            return this.serializer;
        }
    }

    static class ObjectReferenceSerializer
    extends StdSerializer<Object> {
        private final BiMap<String, Object> backingMap;

        public ObjectReferenceSerializer(BiMap<String, Object> backingMap) {
            super(Object.class);
            this.backingMap = backingMap;
        }

        public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
            this.serialize(value, gen, serializers);
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String id = (String)this.backingMap.inverse().get(value);
            if (id == null) {
                id = PREFIX + Identifiers.makeRandomId((int)12);
                this.backingMap.put((Object)id, value);
            }
            gen.writeObjectRef((Object)id);
        }
    }
}

