/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.rest.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.brooklyn.rest.domain.TaskSummary;

@Path(value="/activities")
@Api(value="Activities")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface ActivityApi {
    @GET
    @Path(value="/{task}")
    @ApiOperation(value="Fetch task details", response=TaskSummary.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find task"), @ApiResponse(code=500, message="Internal Server Error")})
    public Response get(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(name="timeout", value="Delay before server should block until task completes before returinging (in millis if no unit specified): '0' means 'always' return task activity ID and is the default; 'never' or '-1' means wait until the task finishes (or HTTP times out); and e.g. '1000' or '1s' will return the task as soon as it completes or after one second whichever is sooner, with 202 returned if the task is still ongoing", required=false, defaultValue="0") @QueryParam(value="timeout") String var2, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var3);

    @GET
    @Path(value="/{task}/children")
    @ApiOperation(value="Fetch list of children tasks of this task")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find task"), @ApiResponse(code=500, message="Internal Server Error")})
    public List<TaskSummary> children(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Whether to include non-subtask backgrounded tasks submitted by this task", required=false) @QueryParam(value="includeBackground") @DefaultValue(value="false") Boolean var2, @ApiParam(value="Max number of tasks to include, or -1 for all (default 200)", required=false) @QueryParam(value="limit") @DefaultValue(value="200") int var3, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var4);

    @GET
    @Path(value="/{task}/children/recurse")
    @ApiOperation(value="Fetch all child tasks and their descendants with details as Map<String,TaskSummary> map key == Task ID", response=Map.class)
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find task"), @ApiResponse(code=500, message="Internal Server Error")})
    public Map<String, TaskSummary> getAllChildrenAsMap(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Max number of tasks to include, or -1 for all (default 200)", required=false) @QueryParam(value="limit") @DefaultValue(value="200") int var2, @ApiParam(value="Max depth to traverse, or -1 for all (default)", required=false) @QueryParam(value="maxDepth") @DefaultValue(value="-1") int var3, @ApiParam(value="Whether to suppress secrets", required=false) @QueryParam(value="suppressSecrets") Boolean var4);

    @GET
    @Path(value="/{task}/stream/{streamId}")
    @ApiOperation(value="Return the contents of the given stream")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find task"), @ApiResponse(code=500, message="Internal Server Error")})
    @Produces(value={"text/plain"})
    public String stream(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Stream ID", required=true) @PathParam(value="streamId") String var2);

    @POST
    @Path(value="/{task}/cancel")
    @ApiOperation(value="Sends a cancel to a task. Returns true if it was in a cancellable state (running and not already cancelled). It is task dependent at what point tasks stop running when cancelled.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=401, message="Unauthorized"), @ApiResponse(code=404, message="Could not find task"), @ApiResponse(code=500, message="Internal Server Error")})
    public Boolean cancel(@ApiParam(value="Task ID", required=true) @PathParam(value="task") String var1, @ApiParam(value="Whether to skip sending an interrupt to the task; if true, tasks may continue to run but not be easily trackable, so use with care, only with tasks that check their cancelled status and will clean up nicely.", required=false) @QueryParam(value="noInterrupt") @DefaultValue(value="false") Boolean var2);
}

