/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.userauth;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.schmizz.concurrent.Promise;
import net.schmizz.sshj.AbstractService;
import net.schmizz.sshj.Service;
import net.schmizz.sshj.common.DisconnectReason;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHException;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.userauth.AuthParams;
import net.schmizz.sshj.userauth.UserAuth;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.method.AuthMethod;

public class UserAuthImpl
extends AbstractService
implements UserAuth {
    private final Promise<Boolean, UserAuthException> authenticated;
    private volatile String banner = "";
    private volatile boolean partialSuccess = false;
    private volatile List<String> allowedMethods = new LinkedList<String>();
    private volatile AuthMethod currentMethod;
    private volatile Service nextService;

    public UserAuthImpl(Transport trans) {
        super("ssh-userauth", trans);
        this.authenticated = new Promise("authenticated", UserAuthException.chainer, trans.getConfig().getLoggerFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean authenticate(String username, Service nextService, AuthMethod method, int timeoutMs) throws UserAuthException, TransportException {
        boolean outcome;
        this.authenticated.lock();
        try {
            super.request();
            this.currentMethod = method;
            this.nextService = nextService;
            this.currentMethod.init(this.makeAuthParams(username, nextService));
            this.authenticated.clear();
            this.log.debug("Trying `{}` auth...", (Object)method.getName());
            this.currentMethod.request();
            outcome = this.authenticated.retrieve(timeoutMs, TimeUnit.MILLISECONDS);
            if (outcome) {
                this.log.debug("`{}` auth successful", (Object)method.getName());
            } else {
                this.log.debug("`{}` auth failed", (Object)method.getName());
            }
        }
        finally {
            this.currentMethod = null;
            this.nextService = null;
            this.authenticated.unlock();
        }
        return outcome;
    }

    @Override
    public String getBanner() {
        return this.banner;
    }

    @Override
    public boolean hadPartialSuccess() {
        return this.partialSuccess;
    }

    @Override
    public Collection<String> getAllowedMethods() {
        return Collections.unmodifiableList(this.allowedMethods);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handle(Message msg, SSHPacket buf) throws SSHException {
        if (!msg.in(50, 80)) {
            throw new TransportException(DisconnectReason.PROTOCOL_ERROR);
        }
        this.authenticated.lock();
        try {
            switch (msg) {
                case USERAUTH_BANNER: {
                    this.banner = buf.readString();
                    return;
                }
                case USERAUTH_SUCCESS: {
                    this.trans.setAuthenticated();
                    this.trans.setService(this.nextService);
                    this.authenticated.deliver(true);
                    return;
                }
                case USERAUTH_FAILURE: {
                    this.allowedMethods = Arrays.asList(buf.readString().split(","));
                    this.partialSuccess |= buf.readBoolean();
                    if (this.allowedMethods.contains(this.currentMethod.getName()) && this.currentMethod.shouldRetry()) {
                        this.currentMethod.request();
                        return;
                    } else {
                        this.authenticated.deliver(false);
                        return;
                    }
                }
                default: {
                    this.log.debug("Asking `{}` method to handle {} packet", (Object)this.currentMethod.getName(), (Object)msg);
                    try {
                        this.currentMethod.handle(msg, buf);
                        return;
                    }
                    catch (UserAuthException e) {
                        this.authenticated.deliverError(e);
                    }
                    return;
                }
            }
        }
        finally {
            this.authenticated.unlock();
        }
    }

    @Override
    public void notifyError(SSHException error) {
        super.notifyError(error);
        this.authenticated.deliverError(error);
    }

    private AuthParams makeAuthParams(final String username, final Service nextService) {
        return new AuthParams(){

            @Override
            public String getNextServiceName() {
                return nextService.getName();
            }

            @Override
            public Transport getTransport() {
                return UserAuthImpl.this.trans;
            }

            @Override
            public String getUsername() {
                return username;
            }
        };
    }
}

